unit UFCidade;

interface

uses
  SysUtils, Classes, Controls, ExtCtrls, StdCtrls, DbClient, Dialogs;

type
  TUFCidade = class(TCustomPanel)
  private
    FArquivo     : String;
    FUf          : String;
    FCidade      : String;
    // Declare StdCtrls no uses para usar TLabel
    FLbUf        : TLabel;
    FLbCidade    : TLabel;
    FCombouf     : TComboBox;
    FCombocidade : TComboBox;
    // Declare DbClient no uses para usar TClientDataSet
    FClient      : TClientDataSet;
  protected
    procedure ProcessaUF(Sender:TObject);
    procedure ProcessaCidade(Sender:TObject);
    procedure SaidaUF(Sender:TObject);
    procedure SaidaCidade(Sender:TObject);
    procedure Tamanho(Sender:TObject);
  public
    Constructor Create(AOWner:TComponent); override;
    Destructor Destroy; override;
  published
    property Arquivo_XML : String  Read FArquivo Write FArquivo;
    property UF          : String  Read FUF      Write FUF;
    property Cidade      : String  Read FCidade  Write FCidade;
  end;

procedure Register;

implementation
Constructor TUFCidade.Create(AOWner:TComponent);
begin
  inherited Create(AOWner);
  // Panel ...
  Height             := 037;
  Width              := 263;
  BevelInner         := bvNone;
  BevelOuter         := bvNone;
  Caption            := '';
  // Label Uf ...
  FLbUf              := TLabel.Create(Self);
  FLbUf.Caption      := 'UF';
  FLbUf.Left         := 2;
  FLbUf.Top          := 2;
  FLbUf.Parent       := Self;
  // Label Cidade ...
  FLbCidade          := TLabel.Create(Self);
  FLbCidade.Caption  := 'Cidade';
  FLbCidade.Left     := 44;
  FLbCidade.Top      := 02;
  FLbCidade.Parent   := Self;
  // Combo UF ...
  FComboUf            := TComboBox.Create(Self);
  FComboUf.Cursor     := crHandPoint;
  FComboUF.Sorted     := True;
  FComboUf.Left       := 02;
  FComboUF.Top        := 14;
  FComboUF.Height     := 21;
  FComboUF.Width      := 39;
  FComboUF.TabStop    := True;
  FComboUF.OnEnter    := ProcessaUF;
  FComboUF.OnExit     := SaidaUF;
  FComboUF.Parent     := Self;
  // Combo Cidade ...
  FComboCidade        := TComboBox.Create(Self);
  FComboCidade.Cursor := crHandPoint;
  FComboCidade.Left   := 44;
  FComboCidade.Top    := 14;
  FComboCidade.Height := 21;
  FComboCidade.Width  := Self.Width - 45;
  FComboCidade.TabStop:= True;
  FComboCidade.OnEnter:= ProcessaCidade;
  FComboCidade.OnExit := SaidaCidade;
  FComboCidade.Parent := Self;
  // ClientDataSet ...
  FClient             := TClientDataSet.Create(Self);
  // Ajustes do Componente ...
  OnResize := Tamanho;
end;

Destructor TUFCidade.Destroy;
begin
  FLbUf.Free;
  FLbCidade.Free;
  FComboUf.Free;
  FComboCidade.Free;
  FClient.Free;
  inherited Destroy;
end;

procedure TUFCidade.ProcessaUF(Sender:TObject);
begin
  with FComboUF do
  begin
    Items.Clear;
    Items.Add('AC'); Items.Add('AM'); Items.Add('MA');
    Items.Add('BA'); Items.Add('DF'); Items.Add('CE');
    Items.Add('SP'); Items.Add('RJ'); Items.Add('RR');
    Items.Add('RO'); Items.Add('GO'); Items.Add('RS');
    Items.Add('SE'); Items.Add('ES'); Items.Add('PA');
    Items.Add('PR'); Items.Add('TO'); Items.Add('PI');
    Items.Add('RN'); Items.Add('PB'); Items.Add('PE');
    Items.Add('AL'); Items.Add('MG'); Items.Add('MT');
    Items.Add('SC'); Items.Add('MS');
    If FUF <> '' then
      ItemIndex := Items.IndexOf(FUF);
  end;
end;

procedure TUFCidade.SaidaUF(Sender:TObject);
var
  FAchou : Boolean;
begin
  FComboUF.ItemIndex := FComboUF.Items.IndexOf(UpperCase(FComboUF.Text));
  FAchou             := (FComboUF.ItemIndex >= 0);
  if not FAchou then
  begin
    // Declare Dialogs no uses para usar Messagedlg
    Messagedlg('UF no Encontrada!',mtInformation,[mbOk],0);
    FComboUF.Text := '';
    FComboUF.SetFocus;
    exit;
  end;
  FComboUF.Text := UpperCase(FComboUF.Text);
  FUF           := FComboUF.Text;
end;

procedure TUFCidade.ProcessaCidade(Sender:TObject);
begin
  if trim(FArquivo) = '' then
  begin
    Messagedlg('Informe o Arquivo XML a Processar!',mtInformation,[mbOK],0);
    exit;
  end; // if trim(vArquivo) = '' then ...
  try
    FClient.Filtered := False;
    FClient.FileName := FArquivo;
    FClient.Filter   := 'UF = ''' + FComboUF.Text + '''';
    FClient.Filtered := True;
    FClient.Open;
  except
    Messagedlg('No foi possvel abrir o arquivo XML!',mtError,[mbOK],0);
    exit;
  end;
  with FComboCidade do
  begin
    Items.BeginUpdate;
    if FCidade = '' then Text := '';
    Items.Clear;
    while not FClient.Eof do
    begin
      Items.Add(FClient.FieldByName('CIDADE').AsString);
      FClient.Next;
    end;
    FClient.Close;
    Items.EndUpdate;
    if FCidade <> '' then
      ItemIndex := Items.IndexOf(FCidade);
  end;
end;

procedure TUFCidade.SaidaCidade(Sender:TObject);
var
  FAchou : Boolean;
begin
  FComboCidade.ItemIndex := FComboCidade.Items.IndexOf(UpperCase(FComboCidade.Text));
  FAchou                 := (FComboCidade.ItemIndex >= 0);
  if not FAchou then
  begin
    Messagedlg('Cidade no Encontrada!',mtInformation,[mbOk],0);
    FComboCidade.Text := '';
    FComboCidade.SetFocus;
    exit;
  end;
  FComboCidade.Text := UpperCase(FComboCidade.Text);
  FCidade           := FComboCidade.Text;
end;

procedure TUFCidade.Tamanho(Sender:TObject);
begin
  FComboUF.Width     := 39;
  FComboUF.Left      := 02;
  FComboCidade.Width := Self.Width - 45;
  FComboCidade.Left  := FComboUF.Left + 42;
  Self.Height        := 37;
end;

procedure Register;
begin
  RegisterComponents('UFCidade', [TUFCidade]);
end;

end.
