unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RpCon, RpBase, RpSystem, RpDefine, RpRave;

type
  TDadosCliente = record
    Codigo: Integer; 
    Nome: string;
    Telefone: string;
  end;

  TForm1 = class(TForm)
    RvProject1: TRvProject;
    RvSystem1: TRvSystem;
    RvCustomConnection1: TRvCustomConnection;
    rdbArray: TRadioButton;
    rdbArquivoTXT: TRadioButton;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure RvCustomConnection1Open(Connection: TRvCustomConnection);
    procedure RvCustomConnection1Restore(Connection: TRvCustomConnection);
    procedure RvCustomConnection1GetCols(Connection: TRvCustomConnection);
    procedure RvCustomConnection1GetRow(Connection: TRvCustomConnection);
    procedure RvCustomConnection1First(Connection: TRvCustomConnection);
    procedure RvCustomConnection1Next(Connection: TRvCustomConnection);
    procedure RvCustomConnection1EOF(Connection: TRvCustomConnection;
      var Eof: Boolean);
    procedure RvCustomConnection1ValidateRow(
      Connection: TRvCustomConnection; var ValidRow: Boolean);
  private
    FArrClientes: array of TDadosCliente;
    FTxtFile: TextFile;
    FLinhaTXT: string;
    FTxtEof: Boolean;
    procedure AlimentaArray;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.AlimentaArray;
var
  intX: Integer;
begin
  Randomize;
  SetLength(FArrClientes, 10);
  for intX := Low(FArrClientes) to High(FArrClientes) do
  begin
    with FArrClientes[intX] do
    begin
      Codigo   := intX + 1;
      Nome     := 'Cliente ' + IntToStr(Codigo);
      Telefone := Format('%d%d%d%d-%d%d%d%d',
                         [Random(9), Random(9), Random(9), Random(9),
                          Random(9), Random(9), Random(9), Random(9)]);
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  RvProject1.Execute;
end;

procedure TForm1.RvCustomConnection1Open(Connection: TRvCustomConnection);
begin
  // origem Array
  if rdbArray.Checked then
  begin
    AlimentaArray;
    Connection.DataRows := Length(FArrClientes);
  end;

  // origem Arquivo TXT
  if rdbArquivoTXT.Checked then
  begin
    AssignFile(FTxtFile, ExtractFilePath(Application.ExeName) + 'registros.txt');
    FTxtEof := False;    
  end;

  Connection.DataIndex := 0;
end;

procedure TForm1.RvCustomConnection1Restore(
  Connection: TRvCustomConnection);
begin
  // origem Array
  if rdbArray.Checked then
  begin
    SetLength(FArrClientes, 0);
  end;

  // origem Arquivo TXT
  if rdbArquivoTxt.Checked then
  begin
    CloseFile(FTxtFile);
  end;
end;

procedure TForm1.RvCustomConnection1GetCols(
  Connection: TRvCustomConnection);
begin
  with Connection do
  begin
    WriteField('Codigo',   dtInteger, 0,  'Cdigo', '');
    WriteField('Nome',     dtString,  50, 'Nome'  , '');
    WriteField('Telefone', dtString,  20, 'Telefone', '');
  end;
end;

procedure TForm1.RvCustomConnection1GetRow(
  Connection: TRvCustomConnection);
begin
  with Connection do
  begin
    // usando Array
    if rdbArray.Checked then
    begin
      WriteIntData('', FArrClientes[DataIndex].Codigo);
      WriteStrData('', FArrClientes[DataIndex].Nome);
      WriteStrData('', FArrClientes[DataIndex].Telefone);
    end;

    // usando Arquivo TXT
    if rdbArquivoTXT.Checked then
    begin
      WriteIntData('', StrToInt(Trim(Copy(FLinhaTXT, 1, 5))));
      WriteStrData('', Copy(FLinhaTXT, 6, 40));
      WriteStrData('', Copy(FLinhaTXT, 46, 20));
    end;

  end;
end;

procedure TForm1.RvCustomConnection1First(Connection: TRvCustomConnection);
begin
  // usando arquivo TXT
  if rdbArquivoTxt.Checked then
  begin
    Reset(FTxtFile);
    ReadLn(FTxtFile, FLinhaTXT);
  end;
end;

procedure TForm1.RvCustomConnection1Next(Connection: TRvCustomConnection);
begin
  // usando array
  // no haveria necessidade deste bloco se
  // no tivessemos o bloco de cdigo do arquivo TXT
  if rdbArray.Checked then
  begin
    Connection.DataIndex := Connection.DataIndex + 1;
  end;

  // usando arquivo TXT
  if rdbArquivoTXT.Checked then
  begin
    Connection.DataIndex := Connection.DataIndex + 1;
    FTxtEof := Eof(FTxtFile);
    if not FTxtEof then
      ReadLn(FTxtFile, FLinhaTxt);
  end;
end;

procedure TForm1.RvCustomConnection1EOF(Connection: TRvCustomConnection;
  var Eof: Boolean);
begin
  // usando array
  // no haveria necessidade deste bloco se
  // no tivessemos o bloco de cdigo do arquivo TXT
  if rdbArray.Checked then
  begin
    Eof := Connection.DataIndex = Connection.DataRows;
  end;

  // usando arquivo TXT
  if rdbArquivoTXT.Checked then
  begin
    Eof := FTxtEof;
  end;
end;

procedure TForm1.RvCustomConnection1ValidateRow(
  Connection: TRvCustomConnection; var ValidRow: Boolean);
begin
  // filtrando para no pegar o quarto registro,
  // pois o dataindex inicia no zero
  if Connection.DataIndex = 3 then
    ValidRow := False;
end;

end.
