unit Unit2;

interface

uses
  Classes, Sysutils;

type
  TThreadActive = class(TThread)
  private
    { Private declarations }
  protected
    procedure DrawInBox;
    procedure Execute; override;
  end;

implementation

uses Unit1;

{ Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TThreadActive.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TThreadActive }

procedure TThreadActive.DrawInBox;
var x1, y1 : integer;
begin
     randomize;
     x1 := random( form1.PaintBox1.Width);
     y1 := random( form1.PaintBox1.Height);
     Form1.PaintBox1.Canvas.Pixels[x1, y1] := Random( 65535 );
end;

procedure TThreadActive.Execute;
begin
     While not Terminated do
     begin
          Synchronize( DrawInBox );
          sleep(50);
     end;
end;

end.
 