unit uControllerDll;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ServerDLL_TLB;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    ID_IServerAutoDLL: IServerAutoDLL;
    procedure EnableControls(DoEnable: Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ComObj;

{$R *.dfm}

procedure TForm1.EnableControls(DoEnable: Boolean);
begin
  Button2.Enabled := DoEnable;
  Label1.Enabled  := DoEnable;
  Edit1.Enabled   := DoEnable;
  Button4.Enabled := DoEnable;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ID_IServerAutoDLL := CreateComObject(CLASS_ServerAutoDLL) as IServerAutoDLL;
  EnableControls(True);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ID_IServerAutoDLL := nil;
  EnableControls(False);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  ID_IServerAutoDLL.MessageStr := Edit1.Text;
  ID_IServerAutoDLL.ShowMessageStr;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  EnableControls(False);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Button2.Click;
end;

end.
