unit ServerAutoTLB;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, ServerDLL_TLB, StdVcl;

type
  TServerAutoDLL = class(TAutoObject, IServerAutoDLL)
  private
    MessageStr : string;
  protected
    function Get_MessageStr: WideString; safecall;
    procedure Set_MessageStr(const Value: WideString); safecall;
    function ShowMessageStr: Integer; safecall;
  end;

implementation

uses ComServ, Windows;

function TServerAutoDLL.Get_MessageStr: WideString;
begin
  Result := MessageStr;
end;

procedure TServerAutoDLL.Set_MessageStr(const Value: WideString);
begin
  MessageStr := Value;
end;

function TServerAutoDLL.ShowMessageStr: Integer;
begin
  MessageBox(0, pChar(MessageStr), 'Your string is ...: ', MB_OK+MB_ICONQUESTION);
  Result := length(MessageStr);
end;

initialization
  TAutoObjectFactory.Create(ComServer, TServerAutoDLL, Class_ServerAutoDLL,
    ciMultiInstance, tmApartment);
end.
