unit uController;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ColorGrd, Buttons, Server_TLB;
  
type
  TForm2 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    RadioGroup1: TRadioGroup;
    GroupBox2: TGroupBox;
    Shape1: TShape;
    Button4: TButton;
    RadioGroup2: TRadioGroup;
    GroupBox3: TGroupBox;
    Edit1: TEdit;
    Button5: TButton;
    ColorDialog1: TColorDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    FIntf: IServerAutomation;
    FDispintf: IServerAutomationDisp;
    FVar: OleVariant;
    procedure SetControls;
    procedure EnableControls(DoEnable: Boolean);
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

uses ComObj;

procedure TForm2.SetControls;
begin
  case RadioGroup1.ItemIndex of
    0:
      begin
        Shape1.Brush.Color    := FIntf.ShapeColor;
        RadioGroup2.ItemIndex := FIntf.ShapeType;
        Edit1.Text            := FIntf.EditText;
      end;
    1:
      begin
        Shape1.Brush.Color    := FDispintf.ShapeColor;
        RadioGroup2.ItemIndex := FDispintf.ShapeType;
        Edit1.Text            := FDispintf.EditText;
      end;
    2:
      begin
        Shape1.Brush.Color    := FVar.ShapeColor;
        RadioGroup2.ItemIndex := FVar.ShapeType;
        Edit1.Text            := FVar.EditText;
      end;
  end;
end;

procedure TForm2.EnableControls(DoEnable: Boolean);
begin
  Button2.Enabled     := DoEnable;
  Button3.Enabled     := DoEnable;
  Button4.Enabled     := DoEnable;
  RadioGroup2.Enabled := DoEnable;
  Edit1.Enabled       := DoEnable;
  Button5.Enabled     := DoEnable;
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
  FIntf     := CoServerAutomation.Create;
  FDispintf := CreateComObject(CLASS_ServerAutomation) as IServerAutomationDisp;
  FVar      := CreateOleObject('Server.ServerAutomation');
  EnableControls(True);
  SetControls;
  Button2.SetFocus;
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
  FIntf     := nil;
  FDispintf := nil;
  FVar      := Unassigned;
  EnableControls(False);
  Button1.SetFocus;
end;

procedure TForm2.Button3Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0: FIntf.ShowInfo;
    1: FDispintf.ShowInfo;
    2: FVar.ShowInfo;
  end;
end;

procedure TForm2.Button4Click(Sender: TObject);
var
  NewColor: TColor;
begin
  if ColorDialog1.Execute then begin
    NewColor                  := ColorDialog1.Color;
    case RadioGroup1.ItemIndex of
      0: FIntf.ShapeColor     := NewColor;
      1: FDispintf.ShapeColor := NewColor;
      2: FVar.ShapeColor      := NewColor;
    end;
    Shape1.Brush.Color        := NewColor;
  end;
end;

procedure TForm2.Button5Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0: FIntf.EditText     := Edit1.Text;
    1: FDispintf.EditText := Edit1.Text;
    2: FVar.EditText      := Edit1.Text;
  end;
end;

procedure TForm2.RadioGroup2Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0: FIntf.ShapeType      := RadioGroup2.ItemIndex;
    1: FDispintf.ShapeType  := RadioGroup2.ItemIndex;
    2: FVar.ShapeType       := RadioGroup2.ItemIndex;
  end;
  Shape1.Shape              := TShapeType(RadioGroup2.ItemIndex);
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  EnableControls(False);
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Button2.Click;
end;

end.
