unit uServerTLB;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, Server_TLB, StdVcl;

type
  TServerAutomation = class(TAutoObject, IServerAutomation)
  protected
    function Get_EditText: WideString; safecall;
    procedure Set_EditText(const Value: WideString); safecall;
    function Get_ShapeColor: OLE_COLOR; safecall;
    procedure Set_ShapeColor(Value: OLE_COLOR); safecall;
    function Get_ShapeType: TxShapeType; safecall;
    procedure Set_ShapeType(Value: TxShapeType); safecall;
    procedure ShowInfo; safecall;
  end;

implementation

uses ComServ, uServer, TypInfo, ExtCtrls, Dialogs, SysUtils, Graphics;

function TServerAutomation.Get_EditText: WideString;
begin
  Result := Form1.Edit1.Text;
end;

procedure TServerAutomation.Set_EditText(const Value: WideString);
begin
  Form1.Edit1.Text := Value;
end;

function TServerAutomation.Get_ShapeColor: OLE_COLOR;
begin
  Result := ColorToRGB(Form1.Shape1.Brush.Color);
end;

procedure TServerAutomation.Set_ShapeColor(Value: OLE_COLOR);
begin
  Form1.Shape1.Brush.Color := Value;
end;

function TServerAutomation.Get_ShapeType: TxShapeType;
begin
  Result := TxShapeType(Form1.Shape1.Shape);
end;

procedure TServerAutomation.Set_ShapeType(Value: TxShapeType);
begin
  Form1.Shape1.Shape := TShapeType(Value);
end;

procedure TServerAutomation.ShowInfo;
const
  cMsgInfo = 'Object name: %s'#10#13'Color = %s'#10#13'Shape = %s'#10#13#13'Object name: %s'#10#13'Text = %s';
begin
  with Form1 do
    ShowMessage(Format(cMsgInfo, [Shape1.Name, ColorToString(Shape1.Brush.Color), GetEnumName(TypeInfo(TShapeType), Ord(Shape1.Shape)), Edit1.Name, Edit1.Text]));
end;

initialization
  TAutoObjectFactory.Create(ComServer, TServerAutomation, Class_ServerAutomation,
    ciMultiInstance, tmApartment);
end.
