unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, GLObjects, GLScene, GLWin32Viewer, GLMisc, GLHUDObjects,
  ScreenSaver, GLSpaceText, GLCadencer, GLFireFX, Geometry;

type
  TForm1 = class(TForm)
    GLScene1: TGLScene;
    GLCamera1: TGLCamera;
    DummyCube1: TDummyCube;
    GLLightSource1: TGLLightSource;
    GLSceneViewer1: TGLSceneViewer;
    SpaceText1: TSpaceText;
    GLFireFXManager1: TGLFireFXManager;
    GLCadencer1: TGLCadencer;
    SpaceText2: TSpaceText;
    ScreenSaver1: TScreenSaver;
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,
      newTime: Double);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.GLCadencer1Progress(Sender: TObject; const deltaTime,
  newTime: Double);
begin
 //Rotao do texto em torno do eixo central
 with SpaceText2.Position do
  begin
   X := SpaceText1.Position.X;
   Y := 4 * cos(DegToRad(newTime * 50));
   Z := 3 * sin(DegToRad(newTime * 50));
  end;

  GLFireFXManager1.FireBurst := 2 * sin(DegToRad(newTime * 50));
  GLFireFXManager1.FireCrown := 2 * cos(DegToRad(newTime * 50));
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if key = vk_escape then
 self.close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
action := cafree;
end;

end.
