unit Tri;

interface

uses
  OpenGL, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    procedure Draw; //Draws an OpenGL scene on request
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure setupPixelFormat(DC:HDC);
const
 pfd:TPIXELFORMATDESCRIPTOR = (
      nSize:sizeof(TPIXELFORMATDESCRIPTOR);	// size
      nVersion:1;			// version
      dwFlags:PFD_SUPPORT_OPENGL or PFD_DRAW_TO_WINDOW or
              PFD_DOUBLEBUFFER;	// support double-buffering
      iPixelType:PFD_TYPE_RGBA;	// color type
      cColorBits:24;			// preferred color depth
      cRedBits:0; cRedShift:0;	// color bits (ignored)
      cGreenBits:0;  cGreenShift:0;
      cBlueBits:0; cBlueShift:0;
      cAlphaBits:0;  cAlphaShift:0;   // no alpha buffer
      cAccumBits: 0;
      cAccumRedBits: 0;  		// no accumulation buffer,
      cAccumGreenBits: 0;     	// accum bits (ignored)
      cAccumBlueBits: 0;
      cAccumAlphaBits: 0;
      cDepthBits:16;			// depth buffer
      cStencilBits:0;			// no stencil buffer
      cAuxBuffers:0;			// no auxiliary buffers
      iLayerType:PFD_MAIN_PLANE;  	// main layer
      bReserved: 0;
      dwLayerMask: 0;
      dwVisibleMask: 0;
      dwDamageMask: 0;                    // no layer, visible, damage masks
 );
var pixelFormat:integer;
begin
 pixelFormat := ChoosePixelFormat(DC, @pfd);
 if (pixelFormat = 0) then
  exit;
 if (SetPixelFormat(DC, pixelFormat, @pfd) <> TRUE) then
  exit;
end;

procedure GLInit;
begin
 // set viewing projection
 glMatrixMode(GL_PROJECTION);
 glFrustum(-0.1, 0.1, -0.1, 0.1, 0.3, 25.0);
 // position viewer
 glMatrixMode(GL_MODELVIEW);
 glEnable(GL_DEPTH_TEST);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
 DC:HDC;
 RC:HGLRC;
begin
 DC:=GetDC(Handle);        //Actually, you can use any windowed control here
 SetupPixelFormat(DC);
 RC:=wglCreateContext(DC); //makes OpenGL window out of DC
 wglMakeCurrent(DC, RC);   //makes OpenGL window active
 GLInit;                   //initialize OpenGL
end;

procedure TForm1.Draw;
const
 S = 1.0;
 D = 5.0;
begin
   glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
   glLoadIdentity;
   glTranslatef(0.0, 0.0, -12.0);
   glBegin(GL_TRIANGLES);
   glVertex3f( -S, 0, D);
   glVertex3f(S, 0, D);
   glVertex3f(0, S, D);
   glEnd;
   SwapBuffers(wglGetCurrentDC);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
 Draw;
end;

end.

