{ Invokable implementation File for TConsultaCliente which implements IConsultaCliente }

unit ConsultaClienteImpl;

interface

uses InvokeRegistry, Types, XSBuiltIns, ConsultaClienteIntf, Variants;

type

  { TConsultaCliente }
  TConsultaCliente = class(TInvokableClass, IConsultaCliente)
  public
     function ConsultaCliente(Codigo : Integer): Variant; stdcall;
  end;

implementation

uses frServico, DB;

function TConsultaCliente.ConsultaCliente(Codigo : Integer): Variant;
var
  Retorno : Variant;
begin
   //Consulta o cliente a partir do cdigo
   try
      try
         with frmServico do
         begin
            if not tbCliente.Active then
               tbCliente.Open;

            Retorno := VarArrayCreate([0, 4], varVariant);
            if tbCliente.FindKey([Codigo]) then
            begin
               Retorno[0] := tbClienteNome.AsString;
               Retorno[1] := tbClienteLimite.AsFloat;
               if tbClienteSituacao.AsString = 'B' then
                  Retorno[2] := 'Bloqueado'
               else
                  Retorno[2] := 'Liberado';
               Retorno[3] := tbClienteUltimaCompra.AsDateTime;
            end
            else
               Retorno[0] := 'Cliente no encontrado';
         end;
      except
          //poderia gravar um log de erro para anlise posterior
          Retorno[0] := 'Erro na consulta';
      end;
   finally
      Result := Retorno;
   end;
end;

initialization
  { Invokable classes must be registered }
  InvRegistry.RegisterInvokableClass(TConsultaCliente);

end.
