unit uCadCliente;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, DBCtrls, DB, Grids, DBGrids;

type
  TfrmCadCliente = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    btnIncluir: TButton;
    btnGravar: TButton;
    btnCancelar: TButton;
    btnExcluir: TButton;
    dtsCadCliente: TDataSource;
    btnPesquisar: TButton;
    DBGrid1: TDBGrid;
    dtsCliProdutos: TDataSource;
    DBText1: TDBText;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnIncluirClick(Sender: TObject);
    procedure btnGravarClick(Sender: TObject);
    procedure btnCancelarClick(Sender: TObject);
    procedure btnExcluirClick(Sender: TObject);
    procedure btnPesquisarClick(Sender: TObject);
    procedure DBGrid1TitleClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCadCliente: TfrmCadCliente;

implementation

uses
  udmCadCliente;

{$R *.dfm}

procedure TfrmCadCliente.FormCreate(Sender: TObject);
begin
  dmCadCliente := TdmCadCliente.Create(Self);
  dmCadCliente.cdsCliente.Open;
end;

procedure TfrmCadCliente.btnIncluirClick(Sender: TObject);
begin
  dmCadCliente.cdsCliente.Append;
end;

procedure TfrmCadCliente.btnGravarClick(Sender: TObject);
begin
  with dmCadCliente.cdsCliente do
  begin
    Post;
    if ApplyUpdates(0) <> 0 then CancelUpdates;
  end;
end;

procedure TfrmCadCliente.btnCancelarClick(Sender: TObject);
begin
  with dmCadCliente.cdsCliente do
  begin
    Cancel;
    CancelUpdates;
  end;
end;

procedure TfrmCadCliente.btnExcluirClick(Sender: TObject);
begin
  with dmCadCliente.cdsCliente do
  begin
    Delete;
    if ApplyUpdates(0) <> 0 then CancelUpdates;
  end;
end;

procedure TfrmCadCliente.btnPesquisarClick(Sender: TObject);
var
  strCodigo: string;
begin
  if InputQuery('Pesquisa de Cliente', 'Informe o Cdigo', strCodigo) then
    with dmCadCliente do
    begin
      cdsCliente.Close;
      qryCliente.ParamByName('CLI_CODIGO').AsInteger := StrToInt(strCodigo);
      cdsCliente.Open;

      if cdsCliente.IsEmpty then
        ShowMessage('Cliente no encontrado !');
    end;
end;

procedure TfrmCadCliente.DBGrid1TitleClick(Column: TColumn);
begin
  dmCadCliente.cdsCliProdutos.IndexFieldNames := Column.FieldName;
end;

end.
