unit udmCadCliente;

interface

uses
  SysUtils, Classes, FMTBcd, SqlExpr, Provider, DB, DBClient;

type
  TdmCadCliente = class(TDataModule)
    cdsCliente: TClientDataSet;
    dspCliente: TDataSetProvider;
    qryCliente: TSQLQuery;
    dtsLink: TDataSource;
    cdsCliProdutos: TClientDataSet;
    qryCliProdutos: TSQLQuery;
    cdsClienteCLI_CODIGO: TIntegerField;
    cdsClienteCLI_NOME: TStringField;
    cdsClienteqryCliProdutos: TDataSetField;
    qryCliProdutosCLI_CODIGO: TIntegerField;
    qryCliProdutosPROD_CODIGO: TIntegerField;
    qryCliProdutosCLIPROD_VALOR: TFMTBCDField;
    qryCliProdutosPROD_DESCRICAO: TStringField;
    qryInfoProd: TSQLQuery;
    cdsCliProdutosCLI_CODIGO: TIntegerField;
    cdsCliProdutosPROD_CODIGO: TIntegerField;
    cdsCliProdutosCLIPROD_VALOR: TFMTBCDField;
    cdsCliProdutosPROD_DESCRICAO: TStringField;
    qryClienteCLI_CODIGO: TIntegerField;
    qryClienteCLI_NOME: TStringField;
    cdsCliProdutosVALORTOTAL: TAggregateField;
    procedure cdsClienteBeforeDelete(DataSet: TDataSet);
    procedure cdsCliProdutosPROD_CODIGOValidate(Sender: TField);
    procedure cdsCliProdutosBeforeDelete(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dmCadCliente: TdmCadCliente;

implementation

uses
  udmPrincipal;

{$R *.dfm}

procedure TdmCadCliente.cdsClienteBeforeDelete(DataSet: TDataSet);
begin
  with cdsCliProdutos do
    while not IsEmpty do Delete;
end;

procedure TdmCadCliente.cdsCliProdutosPROD_CODIGOValidate(Sender: TField);
begin
  if not Sender.IsNull then
    with qryInfoProd do
    begin
      ParamByName('PROD_CODIGO').AsInteger := Sender.AsInteger;
      Open;
      try
        if not IsEmpty then
          cdsCliProdutos.FieldByName('PROD_DESCRICAO').Value := FieldByName('PROD_DESCRICAO').Value
        else
          raise Exception.Create('Produto no encontrado !');
      finally
        Close;
      end;
    end;
end;

procedure TdmCadCliente.cdsCliProdutosBeforeDelete(DataSet: TDataSet);
begin
  with cdsCliente do
    if not (State in dsEditModes) then Edit;
end;

end.
