unit uParadox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TypInfo, StdCtrls, Db, DBTables, BDE, Buttons;

type
  TmcFieldType = (ftString, ftInteger, ftBoolean, ftFloat, ftCurrency,
    ftDate, ftTime, ftMemo, ftFmtMemo, ftAutoInc);

  mc_FieldDef = packed record
    szName    : DBINAME;
    iType     : Word;
    iSubType  : Word;
    iLength   : Word;
    iPrecision: Byte;
  end;

type
  TfParadox = class(TForm)
    Label3: TLabel;
    btnIgualarEstruturas: TButton;
    TabelaDesejada: TTable;
    OpenEstruturaDesejada: TOpenDialog;
    edEstruturaDesejada: TEdit;
    btnEstruturaDesejada: TBitBtn;
    TabelaAtual: TTable;
    OpenEstruturaAtual: TOpenDialog;
    Label6: TLabel;
    edEstruturaAtual: TEdit;
    btnEstruturaAtual: TBitBtn;
    Label1: TLabel;
    listEstruturaDesejada: TListBox;
    listEstruturaAtual: TListBox;
    listDiferencas: TListBox;
    Label2: TLabel;
    Label4: TLabel;
    procedure btnEstruturaDesejadaClick(Sender: TObject);
    procedure btnEstruturaAtualClick(Sender: TObject);
    procedure btnIgualarEstruturasClick(Sender: TObject);
  private
    { Private declarations }
    procedure AbreEstruturaDesejada(Sender: TObject);
    procedure AbreEstruturaAtual(Sender: TObject);
    procedure VerificarDiferencas;

    function mc_GetPiece(pValue: string; pNumPiece: Integer; pDelimiter: string): string;
    function mc_AddField(Table: TTable; Rec: mc_FieldDef): Boolean;
    function mc_DropField(Table: TTable; Field: TField): Boolean;
    function mc_ModifyField(Table: TTable; Field: TField; Rec: mc_FieldDef): Boolean;
  public
    { Public declarations }
  end;

var
  fParadox: TfParadox;

implementation

{$R *.DFM}

const
  AmcFieldType: array[0..9] of Word = (257, 267, 270, 258, 259, 260, 268, 262, 264, 271);

procedure TfParadox.btnEstruturaDesejadaClick(Sender: TObject);
begin
  with OpenEstruturaDesejada do begin
    Title := 'Abrir Estrutura Desejada';
    FilterIndex := 2;
    InitialDir := ExtractFilePath(ParamStr(0));
    Execute;

    if Trim(FileName) <> '' then
    begin
      edEstruturaDesejada.Text := FileName;
      AbreEstruturaDesejada(Self);
      VerificarDiferencas;
    end;
  end;
end;

procedure TfParadox.AbreEstruturaDesejada(Sender: TObject);
var
  i: Integer;
  nome, tipo, tamanho: string;
begin
  if Trim(OpenEstruturaDesejada.FileName) = '' then Exit;

  with TabelaDesejada do begin
    Active := False;
    TableName := OpenEstruturaDesejada.FileName;
    Active := True;
    listEstruturaDesejada.Items.Clear;
    FieldDefs.Update;
  end;

{ Preenche list box com os dados da estrutura desejada }
  for i := 0 to TabelaDesejada.FieldDefs.Count-1 do begin
    nome := TabelaDesejada.FieldDefs.Items[i].Name;
    tipo := GetEnumName(TypeInfo(TFieldType), Integer(TabelaDesejada.FieldDefs.Items[i].DataType));
    tamanho := IntToStr(TabelaDesejada.FieldDefs.Items[i].Size);
    listEstruturaDesejada.Items.Add(nome + ' - ' + tipo + ' - ' + tamanho);
  end;
end;

procedure TfParadox.btnEstruturaAtualClick(Sender: TObject);
begin
  with OpenEstruturaAtual do begin
    Title := 'Abrir Estrutura Atual';
    FilterIndex := 2;
    InitialDir := ExtractFilePath(ParamStr(0));
    Execute;

    if Trim(FileName) <> '' then
    begin
      edEstruturaAtual.Text := FileName;
      AbreEstruturaAtual(Self);
      VerificarDiferencas;
    end;
  end;
end;

procedure TfParadox.AbreEstruturaAtual(Sender: TObject);
var
  i: Integer;
  nome, tipo, tamanho: string;
begin
  if Trim(OpenEstruturaAtual.FileName) = '' then Exit;

  with TabelaAtual do begin
    Active := False;
    TableName := OpenEstruturaAtual.FileName;
    Active := True;
    listEstruturaAtual.Items.Clear;
    FieldDefs.Update;
  end;

{ Preenche list box com os dados da estrutura atual }
  for i := 0 to TabelaAtual.FieldDefs.Count - 1 do begin
    nome := TabelaAtual.FieldDefs.Items[i].Name;
    tipo := GetEnumName(TypeInfo(TFieldType), Integer(TabelaAtual.FieldDefs.Items[i].DataType));
    tamanho := IntToStr(TabelaAtual.FieldDefs.Items[i].Size);
    listEstruturaAtual.Items.Add(nome + ' - ' + tipo + ' - ' + tamanho);
  end;
end;

procedure TfParadox.VerificarDiferencas;
var
  i, n: Integer;
  nomeN, tipoN, tamanhoN: string;
  nome, tipo, tamanho: string;
  achou: Boolean;
begin
  if (Trim(OpenEstruturaDesejada.FileName) = '') or
     (Trim(OpenEstruturaAtual.FileName) = '') then Exit;

  listDiferencas.Items.Clear;

  TabelaDesejada.Active := True;
  TabelaDesejada.FieldDefs.Update;

  TabelaAtual.Active := True;
  TabelaAtual.FieldDefs.Update;

{ Compara a estrutura desejada com a estrutura atual para determinar
  os campos que devem ser alterados ou inseridos }
  for i := 0 to TabelaDesejada.FieldDefs.Count - 1 do begin
    nomeN := TabelaDesejada.FieldDefs.Items[i].Name;
    tipoN := GetEnumName(TypeInfo(TFieldType), Integer(TabelaDesejada.FieldDefs.Items[i].DataType));
    tamanhoN := IntToStr(TabelaDesejada.FieldDefs.Items[i].Size);
    achou := False;

    for n := 0 to TabelaAtual.FieldDefs.Count - 1 do begin
      nome := TabelaAtual.FieldDefs.Items[n].Name;
      tipo := GetEnumName(TypeInfo(TFieldType), Integer(TabelaAtual.FieldDefs.Items[n].DataType));
      tamanho := IntToStr(TabelaAtual.FieldDefs.Items[n].Size);

      if nome = nomeN then
      begin
        achou := True;
        if (tipoN <> tipo) or (tamanhoN <> tamanho) then
        begin
          // Campo a ser alterado...
          listDiferencas.Items.Add('* ; ' + nomeN + ' ; ' + tipoN + ' ; ' + tamanhoN);
          Break;
        end;
      end;
    end; //for n

    if achou = False then
      // Campo a ser inserido...
      listDiferencas.Items.Add('+ ; ' + nomeN + ' ; ' + tipoN + ' ; ' + tamanhoN);
  end; //for i

{ Compara a estrutura atual com a estrutura desejada para determinar
  os campos que devem ser excludos }
  for i := 0 to TabelaAtual.FieldDefs.Count - 1 do begin
    nome := TabelaAtual.FieldDefs.Items[i].Name;
    achou := False;

    for n := 0 to TabelaDesejada.FieldDefs.Count - 1 do begin
      nomeN := TabelaDesejada.FieldDefs.Items[n].Name;

      if nomeN = nome then
      begin
        achou := True;
        Break;
      end;
    end; //for n

    if achou = False then
      // Campo a ser excludo...
      listDiferencas.Items.Add('- ; ' + nome + ' ; ' + tipo + ' ; ' + tamanho);
  end; //for i
end;

procedure TfParadox.btnIgualarEstruturasClick(Sender: TObject);
var
  Tabela: TTable;
  Coluna: mc_FieldDef;
  i: Integer;
  operacao, nome, tipo, tamanho: string;
  wordTipo: Word;
begin
  TabelaAtual.Active := False;
  Tabela := TabelaAtual;
  Tabela.TableType := ttParadox;

  for i := 0 to listDiferencas.Items.Count - 1 do begin
    operacao := Trim(mc_GetPiece(listDiferencas.Items.Strings[i], 1, ';'));
    nome     := Trim(mc_GetPiece(listDiferencas.Items.Strings[i], 2, ';'));
    tipo     := Trim(mc_GetPiece(listDiferencas.Items.Strings[i], 3, ';'));
    tamanho  := Trim(mc_GetPiece(listDiferencas.Items.Strings[i], 4, ';'));

    wordTipo := Word(GetEnumValue(TypeInfo(TmcFieldType), tipo));
    wordTipo := AmcFieldType[wordTipo];

    if operacao = '*' then
    begin
      Tabela.Active := False;
      Tabela.Exclusive := True;
      Tabela.Open;
      FillChar(Coluna, SizeOf(Coluna), 0);
      StrPCopy(Coluna.szName, nome);
      Coluna.iType := wordTipo;
      Coluna.iLength := Word(StrToInt(tamanho));
      mc_ModifyField(Tabela, Tabela.FieldByName(nome), Coluna);
      Tabela.Close;
    end
    else
    if operacao = '+' then
    begin
      Tabela.Active := False;
      Tabela.Exclusive := True;
      Tabela.Open;
      FillChar(Coluna, SizeOf(Coluna), 0);
      StrPCopy(Coluna.szName, PChar(nome));
      Coluna.iType := wordTipo;
      Coluna.iLength := Word(StrToInt(tamanho));
      mc_AddField(Tabela, Coluna);
      Tabela.Close;
    end;
    if operacao = '-' then
    begin
      Tabela.Active := False;
      Tabela.Exclusive := True;
      Tabela.Open;
      mc_DropField(Tabela, Tabela.FieldByName(nome));
      Tabela.Close;
    end;
  end;

  AbreEstruturaAtual(Self);
  VerificarDiferencas;
end;

function TfParadox.mc_GetPiece(pValue: string; pNumPiece: Integer;
  pDelimiter: string): string;
var
  xLength, xInd, xNumPiece: Integer;
  xChar: Char;
begin
  Result := '';

  if pNumPiece < 1 then Exit;

  xLength := Length (pValue);
  xNumPiece := 0;

  for xInd := 1 to xLength do begin
    xChar := pValue [xInd];
    if xChar = pDelimiter then
    begin
      Inc(xNumPiece);
      if (xNumPiece = pNumPiece) then Exit;
      Result := '';
    end
    else
    begin
      Result := Result + xChar;
    end;
  end;

  Inc(xNumPiece);

  if (xNumPiece <> pNumPiece) or (Length(Result) < 1) then
    Result := '';
end;

function TfParadox.mc_AddField(Table: TTable; Rec: mc_FieldDef): Boolean;
var
  Props: CURProps;
  hDb: hDBIDb;
  TableDesc: CRTblDesc;
  pFields: pFLDDesc;
  pOp: pCROpType;
  B: Byte;
begin
  Result := False;

{ Verifica se a tabela est aberta em modo exclusivo }
  if (not Table.Active) or (not Table.Exclusive) then Exit;

{ Define propriedades para a tabela }
  if (DbiSetProp(hDBIObj(Table.Handle), curxltMODE, Integer(xltNONE)) <> DBIERR_NONE) then Exit;

{ Recupera propriedades da tabela }
  if (DbiGetCursorProps(Table.Handle, Props) <> DBIERR_NONE) then Exit;

{ Verifica se a tabela  do tipo Paradox ou dBase }
  if (Props.szTableType <> szPARADOX) and (Props.szTableType <> szDBASE) then Exit;

{ Aloca memria para o descritor de campos }
  pFields := AllocMem((Props.iFields+1) * SizeOf(FLDDesc));

{ Aloca memria para o descritor de operaes }
  pOp := AllocMem((Props.iFields+1) * SizeOf(CROpType));

{ Tenta reestruturar a tabela }
  try
  { Seta o modo de operao para adio de campo (crADD) }
    Inc(pOp, Props.iFields);
    pOp^ := crADD;
    Dec(pOp, Props.iFields);

  { Recupera informaes sobre os campos da tabela }
    if (DbiGetFieldDescs(Table.Handle, pFields) <> DBIERR_NONE) then Exit;

  { Verifica as definies do campo }
    Inc(pFields, Props.iFields);
    if (Length(Rec.szName) > 0) then pFields^.szName   := Rec.szName;
    if (Rec.iType > 0)          then pFields^.iFldType := Rec.iType;
    if (Rec.iSubType > 0)       then pFields^.iSubType := Rec.iSubType;
    if (Rec.iLength > 0)        then pFields^.iUnits1  := Rec.iLength;
    if (Rec.iPrecision > 0)     then pFields^.iUnits2  := Rec.iPrecision;
    Dec(pFields, Props.iFields);

  { Indexa corretamente os campos }
    for B := 1 to Props.iFields+1 do begin
      pFields^.iFldNum := B;
      Inc(pFields, 1);
    end;
    Dec(pFields, Props.iFields+1);

  { Limpa o descritor da tabela }
    FillChar(TableDesc, SizeOf(TableDesc), #0);

  { Recupera o manipulador da tabela }
    Check(DbiGetObjFromObj(hDBIObj(Table.Handle), objDATABASE, hDBIObj(hDb)));

  { Preenche informaes da tabela no descritor }
    StrPCopy(TableDesc.szTblName, Table.TableName);
    StrPCopy(TableDesc.szTblType, Props.szTableType);
    TableDesc.iFldCount := Props.iFields+1;

  { Liga o descritor de operaes ao descritor da tabela }
    TableDesc.pecrFldOp := pOp;

  { Liga o descritor de campos ao descritor da tabela }
    TableDesc.pFldDesc := pFields;

  { Fecha a tabela }
    Table.Close;

  { Chama a funo de reestruturao }
    if (DbiDoRestructure(hDb, 1, @TableDesc, nil, nil, nil, False) <> DBIERR_NONE) then Exit;
  finally
  { Libera a memria alocada no processo }
    if (pFields <> nil) then FreeMem(pFields);
    if (pOp <> nil)     then FreeMem(pOp);
  end;

  Result := True;
end;

function TfParadox.mc_DropField(Table: TTable; Field: TField): Boolean;
var
  Props: CURProps;
  hDb: hDBIDb;
  TableDesc: CRTblDesc;
  pFields: pFLDDesc;
  pOp: pCROpType;
  B: Byte;
begin
  Result := False;

{ Verifica se a tabela est aberta em modo exclusivo }
  if (not Table.Active) or (not Table.Exclusive) then Exit;

{ Define propriedades para a tabela }
  if (DbiSetProp(hDBIObj(Table.Handle), curxltMODE, Integer(xltNONE)) <> DBIERR_NONE) then Exit;

{ Recupera propriedades da tabela }
  if (DbiGetCursorProps(Table.Handle, Props) <> DBIERR_NONE) then Exit;

{ Verifica se a tabela  do tipo Paradox ou dBase }
  if (Props.szTableType <> szPARADOX) and (Props.szTableType <> szDBASE) then Exit;

{ Aloca memria para o descritor de campos }
  pFields := AllocMem(Table.FieldCount * SizeOf(FLDDesc));

{ Aloca memria para o descritor de operaes }
  pOp := AllocMem(Table.FieldCount * SizeOf(CROpType));

{ Tenta reestruturar a tabela }
  try
  { Seta o modo de operao para excluso de campo (crDROP) }
    Inc(pOp, Field.Index);
    pOp^ := crDROP;
    Dec(pOp, Field.Index);

  { Recupera informaes sobre os campos da tabela }
    if (DbiGetFieldDescs(Table.Handle, pFields) <> DBIERR_NONE) then Exit;

  { Indexa corretamente os campos }
    for B := 1 to Table.FieldCount-1 do begin
      pFields^.iFldNum := B;
      Inc(pFields, 1);
    end;
    Dec(pFields, Table.FieldCount-1);

  { Limpa o descritor da tabela }
    FillChar(TableDesc, SizeOf(TableDesc), #0);

  { Recupera o manipulador da tabela }
    if (DbiGetObjFromObj(hDBIObj(Table.Handle), objDATABASE, hDBIObj(hDb)) <> DBIERR_NONE) then Exit;

  { Preenche informaes da tabela no descritor }
    StrPCopy(TableDesc.szTblName, Table.TableName);
    StrPCopy(TableDesc.szTblType, Props.szTableType);
    TableDesc.iFldCount := Table.FieldCount-1;

  { Liga o descritor de operaes ao descritor da tabela }
    TableDesc.pecrFldOp := pOp;

  { Liga o descritor de campos ao descritor da tabela }
    TableDesc.pFldDesc := pFields;

  { Fecha a tabela }
    Table.Close;

  { Chama a funo de reestruturao }
    if (DbiDoRestructure(hDb, 1, @TableDesc, nil, nil, nil, False) <> DBIERR_NONE) then Exit;
  finally
  { Libera a memria alocada no processo }
    if (pFields <> nil) then FreeMem(pFields);
    if (pOp <> nil)     then FreeMem(pOp);
  end;

  Result := True;
end;

function TfParadox.mc_ModifyField(Table: TTable; Field: TField;
  Rec: mc_FieldDef): Boolean;
var
  Props: CURProps;
  hDb: hDBIDb;
  TableDesc: CRTblDesc;
  pFields: pFLDDesc;
  pOp: pCROpType;
  B: Byte;
begin
  Result := False;

{ Verifica se a tabela est aberta em modo exclusivo }
  if (not Table.Active) or (not Table.Exclusive) then Exit;

{ Define propriedades para a tabela }
  if (DbiSetProp(hDBIObj(Table.Handle), curxltMODE,Integer(xltNONE)) <> DBIERR_NONE) then Exit;

{ Recupera propriedades da tabela }
  if (DbiGetCursorProps(Table.Handle, Props) <> DBIERR_NONE) then Exit;

{ Verifica se a tabela  do tipo Paradox ou dBase }
  if (Props.szTableType <> szPARADOX) and (Props.szTableType <> szDBASE) then Exit;

{ Aloca memria para o descritor de campos }
  pFields := AllocMem(Table.FieldCount * SizeOf(FLDDesc));

{ Aloca memria para o descritor de operaes }
  pOp := AllocMem(Table.FieldCount * SizeOf(CROpType));

{ Tenta reestruturar a tabela }
  try
  { Seta o modo de operao para modificao de campo (crMODIFY) }
    Inc(pOp, Field.Index);
    pOp^ := crMODIFY;
    Dec(pOp, Field.Index);

  { Recupera informaes sobre os campos da tabela }
    if (DbiGetFieldDescs(Table.Handle, pFields) <> DBIERR_NONE) then Exit;

  { Verifica as definies do campo }
    Inc(pFields, Field.Index);
    if (Length(Rec.szName) > 0) then pFields^.szName   := Rec.szName;
    if (Rec.iType > 0)          then pFields^.iFldType := Rec.iType;
    if (Rec.iSubType > 0)       then pFields^.iSubType := Rec.iSubType;
    if (Rec.iLength > 0)        then pFields^.iUnits1  := Rec.iLength;
    if (Rec.iPrecision > 0)     then pFields^.iUnits2  := Rec.iPrecision;
    Dec(pFields, Field.Index);

  { Indexa corretamente os campos }
    for B := 1 to Table.FieldCount do begin
      pFields^.iFldNum := B;
      Inc(pFields, 1);
    end;
    Dec(pFields, Table.FieldCount);

  { Limpa o descritor da tabela }
    FillChar(TableDesc, SizeOf(TableDesc), #0);

  { Recupera o manipulador da tabela }
    if (DbiGetObjFromObj(hDBIObj(Table.Handle), objDATABASE, hDBIObj(hDb)) <> DBIERR_NONE) then Exit;

  { Preenche informaes da tabela no descritor }
    StrPCopy(TableDesc.szTblName, Table.TableName);
    StrPCopy(TableDesc.szTblType, Props.szTableType);
    TableDesc.iFldCount := Table.FieldCount;

  { Liga o descritor de operaes ao descritor da tabela }
    TableDesc.pecrFldOp := pOp;

  { Liga o descritor de campos ao descritor da tabela }
    TableDesc.pFldDesc := pFields;

  { Fecha a tabela }
    Table.Close;

  { Chama a funo de reestruturao }
    if (DbiDoRestructure(hDb, 1, @TableDesc, nil, nil, nil, False) <> DBIERR_NONE) then Exit;
  finally
  { Libera a memria alocada no processo }
    if (pFields <> nil) then FreeMem(pFields);
    if (pOp <> nil)     then FreeMem(pOp);
  end;

  Result := True;
end;

end.

