unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TPessoa = class
  private
    FNome: String;
    FIdade: Integer;
    FProfissao: String;
  public
    property Nome: String read FNome write FNome;
    property Idade: Integer read FIdade write FIdade;
    property Profissao: String read FProfissao write FProfissao;
  end;

  TForm1 = class(TForm)
    edtNome: TEdit;
    edtIdade: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    edtProfissao: TEdit;
    Label3: TLabel;
    btnInserir: TButton;
    btnPrimeiro: TButton;
    btnAnterior: TButton;
    btnProximo: TButton;
    btnUltimo: TButton;
    btnSalvar: TButton;
    btnApagar: TButton;
    Label4: TLabel;
    lblQtdeObjetos: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure edtProfissaoChange(Sender: TObject);
    procedure btnPrimeiroClick(Sender: TObject);
    procedure btnUltimoClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnInserirClick(Sender: TObject);
    procedure btnApagarClick(Sender: TObject);
    procedure btnAnteriorClick(Sender: TObject);
    procedure btnProximoClick(Sender: TObject);
  private
    FListaObjetos: TList;
    FPessoa: TPessoa;
    FRecordCount: Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // incializa a lista que conter nossos Objetos
  // da classe TPessoa.
  FListaObjetos := TList.Create;
end;

procedure TForm1.edtProfissaoChange(Sender: TObject);
begin
  // habilita o boto apenas se houver inserido valores.
  btnSalvar.Enabled := (Length(Trim(edtProfissao.Text)) > 0) and
                       (Length(Trim(edtNome.Text)) > 0)      and
                       (Length(Trim(edtIdade.Text)) > 0);
end;

procedure TForm1.btnPrimeiroClick(Sender: TObject);
begin
  // inicializo o contador de registros.
  FRecordCount := 0;
  // recebo os valores do primeiro Item da Lista.
  edtNome.Text := (TObject(FListaObjetos.First) as TPessoa).Nome;
  edtIdade.Text := IntToStr((TObject(FListaObjetos.First) as TPessoa).Idade);
  edtProfissao.Text := (TObject(FListaObjetos.First) as TPessoa).Profissao;
end;

procedure TForm1.btnUltimoClick(Sender: TObject);
begin
  // recebo o total de Itens na Lista.
  FRecordCount := FListaObjetos.Count - 1;
  // recebo os valores do ltimo Item da Lista.
  edtNome.Text := (TObject(FListaObjetos.Last) as TPessoa).Nome;
  edtIdade.Text := IntToStr((TObject(FListaObjetos.Last) as TPessoa).Idade);
  edtProfissao.Text := (TObject(FListaObjetos.Last) as TPessoa).Profissao;
end;

procedure TForm1.btnSalvarClick(Sender: TObject);
begin
  // Intancio um novo Objeto FPessoa.
  FPessoa := TPessoa.Create;
  // recebo os valores informados.
  FPessoa.Nome := edtNome.Text;
  FPessoa.Idade := StrToInt(edtIdade.Text);
  FPessoa.Profissao := edtProfissao.Text;
  // adiciono o novo objeto na lista.
  FListaObjetos.Add(FPessoa);
  // recebo o total de itens cadastrados.
  FRecordCount := FListaObjetos.Count - 1;
  // informo ao Usurio quantos Itens existem na lista.
  lblQtdeObjetos.Caption := Format('%d', [FListaObjetos.Count]);
end;

procedure TForm1.btnInserirClick(Sender: TObject);
begin
  // limpa os Edit's.
  edtNome.Text := EmptyStr;
  edtIdade.Text := EmptyStr;
  edtProfissao.Text := EmptyStr;
end;

procedure TForm1.btnApagarClick(Sender: TObject);
begin
  // apaga o Item corrente da lista.
  FListaObjetos.Delete(FRecordCount);
  // pega a nova quantidade de registros.
  FRecordCount := FListaObjetos.Count - 1;
  // caso no haja mais itens na lista desabilita o boto de apagar.
  btnApagar.Enabled := FListaObjetos.Count > 0;
  // caso no haja mais itens na lista limpa os edits
  // e no atribui mais nenhum valor  eles.
  if FRecordCount = -1 then
  begin
    edtNome.Text := EmptyStr;
    edtIdade.Text := EmptyStr;
    edtProfissao.Text := EmptyStr;
    Exit;
  end;
  // atribui aos edits os valores das Propriedades da Classe corrente
  // contida nessa posicao da lista.
  edtNome.Text := (TObject(FListaObjetos[FRecordCount]) as TPessoa).Nome;
  edtIdade.Text := IntToStr((TObject(FListaObjetos[FRecordCount]) as TPessoa).Idade);
  edtProfissao.Text := (TObject(FListaObjetos[FRecordCount]) as TPessoa).Profissao;
end;

procedure TForm1.btnAnteriorClick(Sender: TObject);
begin
  // Decrementa o indice de "registros" na lista.
  Dec(FRecordCount, 1);
  // verifica se o indice de registros ultrapassou a quantidade
  // mnima de registros, se passou atribuimos a ele 0(Zero) que
  // indica o primeiro item da lista.
  if FRecordCount < 0 then
    FRecordCount := 0;
  // atribui aos edits os valores das Propriedades da Classe corrente
  // contida nessa posicao da lista.
  edtNome.Text := (TObject(FListaObjetos[FRecordCount]) as TPessoa).Nome;
  edtIdade.Text := IntToStr((TObject(FListaObjetos[FRecordCount]) as TPessoa).Idade);
  edtProfissao.Text := (TObject(FListaObjetos[FRecordCount]) as TPessoa).Profissao;
end;

procedure TForm1.btnProximoClick(Sender: TObject);
begin
  // Incrementa o indice de "registros" na lista.
  Inc(FRecordCount, 1);
  // verifica se o indice de registros ultrapassou a quantidade
  // mxima de registros, se passou atribuimos a ele a quantidade mxima
  // menos -1.
  if FRecordCount > FListaObjetos.Count - 1 then
    FRecordCount := FListaObjetos.Count - 1;
  // atribui aos edits os valores das Propriedades da Classe corrente
  // contida nessa posicao da lista.
  edtNome.Text := (TObject(FListaObjetos[FRecordCount]) as TPessoa).Nome;
  edtIdade.Text := IntToStr((TObject(FListaObjetos[FRecordCount]) as TPessoa).Idade);
  edtProfissao.Text := (TObject(FListaObjetos[FRecordCount]) as TPessoa).Profissao;
end;

end.
