unit uf_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Db, StdCtrls, DBTables, Grids, DBGrids, ImgList;

type
  TfrmMain = class(TForm)
    DataSource: TDataSource;
    ImageList1: TImageList;
    TreeView: TTreeView;
    DBGrid1: TDBGrid;
    Splitter1: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure TreeViewExpanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
  private
    { Private declarations }
    procedure PopulaTreeView(const TreeView: TTreeView; const Node: TTreeNode;
      const Dataset: TDataset; const Field: String; const ImageIndex, SelectedIndex: Integer;
      ChildTable, ChildField: String);
    procedure VerificaTemFilhos(ChildTable, ChildField, Filter: String; var AddFalseNode: Boolean);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses ud_data;

{$R *.DFM}

procedure TfrmMain.PopulaTreeView(const TreeView: TTreeView; const Node: TTreeNode;
  const Dataset: TDataset; const Field: String; const ImageIndex, SelectedIndex: Integer;
  ChildTable, ChildField: String);
var
  TreeNode: TTreeNode;
  AddFalseNode: Boolean;
begin
  Dataset.AutoCalcFields:=False;
  try
    TreeView.Items.BeginUpdate;
    Dataset.First;
    if Node<>Nil then
      Node.DeleteChildren;
    while not Dataset.EOF do
      begin
        TreeNode:=TreeView.Items.AddChild(Node, Dataset.FieldByName(Field).AsString);
        TreeNode.ImageIndex:=ImageIndex;
        TreeNode.SelectedIndex:=SelectedIndex;
        AddFalseNode:=False;
        if (ChildTable<>'') and (ChildField<>'') then
          VerificaTemFilhos(ChildTable, ChildField, ChildField+'='''+Dataset.FieldByName(ChildField).AsString+'''', AddFalseNode);
        if AddFalseNode then
          TreeView.Items.AddChild(TreeNode, '');
       Dataset.Next;
      end
  finally
    Dataset.AutoCalcFields:=True;
    TreeView.Items.EndUpdate;
  end;
end;

procedure TfrmMain.VerificaTemFilhos(ChildTable, ChildField, Filter: String; var AddFalseNode: Boolean);
var
  Query: TQuery;
begin
  Query:=TQuery.Create(NIL);
  Query.DatabaseName:='DBDEMOS';
  Query.SQL.Add('Select Count('+ChildField+') From '+ChildTable);
  if Filter<>'' then
    Query.SQL.Add('Where '+Filter);
  Query.Open;
  AddFalseNode:=Query.Fields[0].AsInteger<>0;
  Query.Close;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Dados.qryCountry.Open;
  //TreeView, Node, Dataset, Field, ImageIndex, ChildTable, ChildField
  PopulaTreeView(TreeView, Nil, Dados.qryCountry, 'Country', 0, 1, 'Customer', 'Country');
end;

procedure TfrmMain.TreeViewExpanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
var
  AuxNode: TTreeNode;
begin
  try
    Screen.Cursor:=crHourGlass;
    case Node.Level of
    0: // se a expanso  no n do pas
      begin
        if Node.GetFirstChild.Text <> '' then
          Exit;
        with Dados.qryCustomer do
          begin
            Close;
            ParamByName('country').AsString:=Node.Text;
            Open;
          end;
        Node.DeleteChildren;
        //TreeView, Node, Dataset, Field, ImageIndex, ChildTable, ChildField
        PopulaTreeView(TreeView, Node, Dados.qryCustomer, 'Company', 2, 3, 'orders', 'custno');
        AllowExpansion:=True;
        DataSource.Dataset:=Dados.qryCustomer;
      end;
    1: // se a expanso  no n do cliente
      begin
        if Node.GetFirstChild.Text <> '' then
          Exit;
        with Dados.qryCustomer do
          begin
            Close;
            ParamByName('country').AsString:=Node.Parent.Text;
            Open;
            Locate('Company',Node.Text,[]);
          end;
        with Dados.qryPedidosCustomer do
          begin
            Close;
            ParamByName('custno').AsInteger:=Dados.qryCustomer.FieldByName('custno').AsInteger;
            Open;
          end;
        Node.DeleteChildren;
        //TreeView, Node, Dataset, Field, ImageIndex, ChildTable, ChildField
        PopulaTreeView(TreeView, Node, Dados.qryPedidosCustomer, 'OrderNo', 4, 5, '', '');
        AllowExpansion:=True;
        DataSource.Dataset:=Dados.qryPedidosCustomer;
      end;
    end; // case
  finally
    Screen.Cursor:=crDefault;
  end;
end;

procedure TfrmMain.TreeViewChange(Sender: TObject; Node: TTreeNode);
begin
  case Node.Level of
    0: // se  o pas
      begin
        with Dados.qryCustomer do
          begin
            Close;
            ParamByName('country').AsString:=Node.Text;
            Open;
          end;
        DataSource.Dataset:=Dados.qryCustomer;
      end;
    1: // se  o cliente
      begin
        with Dados.qryCustomer do
          begin
            Close;
            ParamByName('country').AsString:=Node.Parent.Text;
            Open;
            Locate('Company',Node.Text,[]);
          end;
        with Dados.qryPedidosCustomer do
          begin
            Close;
            ParamByName('custno').AsInteger:=Dados.qryCustomer.FieldByName('custno').AsInteger;
            Open;
          end;
        DataSource.Dataset:=Dados.qryPedidosCustomer;
      end;
    2: // se  o pedido
      begin
        with Dados.qryDetalhesPedido do
          begin
            Close;
            ParamByName('OrderNo').AsInteger:=StrToInt(Node.Text);
            Open;
          end;
        DataSource.Dataset:=Dados.qryDetalhesPedido;
      end;
  end;
end;

end.
