unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, DB, DBClient, StdCtrls;

type
  TForm1 = class(TForm)
    cdsCliente: TClientDataSet;
    dtsCliente: TDataSource;
    dbgrdCliente: TDBGrid;
    cdsClienteCLI_CODIGO: TIntegerField;
    cdsClienteCLI_NOME: TStringField;
    btnSalvar: TButton;
    btnLer: TButton;
    btnTransacaoMemoria: TButton;
    dbgrdClone: TDBGrid;
    dtsClone: TDataSource;
    cdsClone: TClientDataSet;
    cdsClienteCLI_INTCALCVALOR: TFloatField;
    cdsClienteCLI_VALOR: TFloatField;
    cdsClienteCLI_CALCVALOR: TFloatField;
    procedure FormCreate(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnLerClick(Sender: TObject);
    procedure btnTransacaoMemoriaClick(Sender: TObject);
    procedure cdsClienteAfterOpen(DataSet: TDataSet);
    procedure cdsClienteCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  with cdsCliente do
  begin
    CreateDataSet;
  end;
end;

procedure TForm1.btnSalvarClick(Sender: TObject);
begin
  cdsCliente.SaveToFile('c:\teste.cds');
end;

procedure TForm1.btnLerClick(Sender: TObject);
begin
  cdsCliente.LoadFromFile('c:\teste.cds');
end;

procedure TForm1.btnTransacaoMemoriaClick(Sender: TObject);
var
  intPoint,
  intX: Integer;
  strCodigo: string;
begin
  with cdsCliente do
  begin
    intPoint := SavePoint;
    try
      for intX := 1 to 10 do
        if InputQuery('Inserindo Cliente', 'Informe o Cdigo do Cliente', strCodigo) then
        begin
          Append;
          FieldByName('CLI_CODIGO').AsInteger := StrToInt(strCodigo);
          Post;
        end;
    except
      SavePoint := intPoint;
      raise;
    end;
  end;
end;

procedure TForm1.cdsClienteAfterOpen(DataSet: TDataSet);
begin
  cdsClone.CloneCursor(cdsCliente, True, False);
end;

procedure TForm1.cdsClienteCalcFields(DataSet: TDataSet);
begin
  with cdsCliente do
  begin
    if State = dsInternalCalc then
      FieldByName('CLI_INTCALCVALOR').AsFloat := FieldByName('CLI_VALOR').AsFloat + 10;
    FieldByName('CLI_CALCVALOR').AsFloat := FieldByName('CLI_VALOR').AsFloat + 10;
  end;
end;

end.
