unit frConsultaCliente;

interface

uses
  Classes, SysUtils, IWAppForm, IWApplication, IWTypes, IWCompLabel,
  IWCompEdit, Controls, IWBaseControl, IWControl, IWCompButton,
  InvokeRegistry, Rio, SOAPHTTPClient, IConsultaCliente1, Variants,
  ActiveX, Windows;

type
  TfrmConsultaCliente = class(TIWAppForm)
    IWButton1: TIWButton;
    edtCodigo: TIWEdit;
    IWLabel1: TIWLabel;
    IWLabel2: TIWLabel;
    IWLabel3: TIWLabel;
    IWLabel4: TIWLabel;
    IWLabel5: TIWLabel;
    edtNome: TIWEdit;
    edtSituacao: TIWEdit;
    edtUltimaCompra: TIWEdit;
    edtLimite: TIWEdit;
    btnSair: TIWButton;
    HTTPRIO: THTTPRIO;
    procedure btnSairClick(Sender: TObject);
    procedure IWButton1Click(Sender: TObject);
    procedure HTTPRIOAfterExecute(const MethodName: String;
      SOAPResponse: TStream);
    procedure HTTPRIOBeforeExecute(const MethodName: String;
      var SOAPRequest: WideString);
  public
  end;

implementation

{$R *.dfm}

uses
  ServerController, IWBaseForm;


procedure TfrmConsultaCliente.btnSairClick(Sender: TObject);
begin
   WebApplication.Terminate('Aplicao finalizada !!!');
end;

procedure TfrmConsultaCliente.IWButton1Click(Sender: TObject);
var
   Consulta: Variant;
begin
  if edtCodigo.Text = '' then
  begin
     WebApplication.ShowMessage('Informe o cdigo a pesquisar', smNewWindow,'');
     exit;
  end;

  Consulta := (HTTPRIO as IConsultaCliente).ConsultaCliente(StrToInt(edtCodigo.Text));

  edtNome.Text         := Consulta[0];
  if Consulta[0] = 'Cliente no encontrado' then
  begin
     edtLimite.Text       := '';
     edtSituacao.Text     := '';
     edtUltimaCompra.Text := '';
  end
  else
  begin
     edtLimite.Text       := Consulta[1];
     edtSituacao.Text     := Consulta[2];
     edtUltimaCompra.Text := Consulta[3];
  end;
end;

procedure TfrmConsultaCliente.HTTPRIOAfterExecute(const MethodName: String;
  SOAPResponse: TStream);
var
  Stream: TFileStream;
begin
  SOAPResponse.Position := 0;
  Stream := TFileStream.Create('\response.xml', fmCreate);
  Stream.CopyFrom(SOAPResponse, SOAPResponse.Size);
  Stream.Free;
  SOAPResponse.Position := 0;
end;

procedure TfrmConsultaCliente.HTTPRIOBeforeExecute(
  const MethodName: String; var SOAPRequest: WideString);
var
  Stream: TFileStream;
  Buffer: PChar;
  Texto: String;
begin
  Texto := SOAPRequest;
  Buffer := PChar(Texto);
  Stream := TFileStream.Create('\request.xml', fmCreate);
  Stream.WriteBuffer(Buffer^, Length(Texto));
  Stream.Free;
end;

initialization
  TfrmConsultaCliente.SetAsMainForm;

end.
