unit uClientActiveDelphi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBClient, SOAPConn, DBCtrls, StdCtrls, Mask, ExtCtrls,
  Buttons, ExtDlgs;

type
  TForm1 = class(TForm)
    SoapConnection1: TSoapConnection;
    ClientDataSet1: TClientDataSet;
    DataSource1: TDataSource;
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    DBImage1: TDBImage;
    Label4: TLabel;
    DBNavigator1: TDBNavigator;
    BitBtn1: TBitBtn;
    ClientDataSet1ID_ALUNO: TIntegerField;
    ClientDataSet1NM_ALUNO: TStringField;
    ClientDataSet1DT_NASCIMENTO: TDateField;
    ClientDataSet1IM_FOTO: TBlobField;
    OpenPictureDialog1: TOpenPictureDialog;
    procedure ApplyUpdates(DataSet: TDataSet);
    procedure CancelUpdates(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure ClientDataSet1AfterInsert(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ApplyUpdates(DataSet: TDataSet);
begin
  if (ClientDataSet1.ChangeCount > 0) then
    ClientDataSet1.ApplyUpdates(-1);
end;

procedure TForm1.CancelUpdates(DataSet: TDataSet);
begin
  if (ClientDataSet1.ChangeCount > 0) then
    ClientDataSet1.CancelUpdates;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  SoapConnection1.Connected := True;
  ClientDataSet1.Open;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ClientDataSet1.Close;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then begin
    with ClientDataSet1 do begin
      if not (State in [dsEdit, dsInsert]) then
        Edit;
      ClientDataSet1IM_FOTO.LoadFromFile(OpenPictureDialog1.FileName);
      ClientDataSet1.Post;
    end;
  end;
end;

procedure TForm1.ClientDataSet1AfterInsert(DataSet: TDataSet);
begin
  ClientDataSet1ID_ALUNO.FocusControl;
end;

end.

