unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, XMLDoc, StdCtrls,XMLIntf,INIFiles;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Procedure INI2XML(__Arq:String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}




procedure TForm1.INI2XML(__Arq:String);
var
 XMLDoc              : IXMLDocument;
 lNode               : IXMLNode;
 lINIFile            : TIniFile;
 lSecao   , lItems   : TStringList;
 ContSecao, ContItens: integer;
begin
   XMLDoc                 := TXMLDocument.Create(nil);
   XMLDoc.Active          := True;
   XMLDoc.Version         := '1.0';
   lINIFile := TIniFile.Create(__Arq);
   XMLDoc.DocumentElement := XMLDoc.CreateNode ('ROOT');
   try
      lSecao := TStringList.Create;
      try
         lItems := TStringList.Create;
         try
            lINIFile.ReadSections(lSecao);
            for ContSecao := 0 to pred(lSecao.Count) do
            begin
               lItems.Clear;
               lINIFile.ReadSection(lSecao[ContSecao],lItems);
               lNode := XMLDoc.DocumentElement.AddChild (lSecao[contSecao]);
               for ContItens := 0 to pred(lItems.Count) do
                begin
                   lNode.AddChild(lItems[ContItens]).Text :=
                      lINIFile.ReadString(lSecao[ContSecao],lItems[ContItens],'');
                end;
           end;
         finally lItems.Free; end;
      finally lSecao.Free; end;
   finally lINIFile.Free; end;
   XMLDoc.SaveToFile(Copy(__Arq,1,length(__Arq)-4)+'.xml');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   INI2XML(edit1.Text);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   OpenDialog1.Execute;
   EDIT1.Text:= OpenDialog1.FileName;
end;

end.
