unit Principal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, FMTBcd, DBXpress, DB, SqlExpr, Provider, DBClient, Grids,
  DBGrids, ExtCtrls, DBCtrls, StdCtrls;

type
  TfrmPrincipal = class(TForm)
    DBGrid1: TDBGrid;
    dtsCliente: TDataSource;
    cdsCliente: TClientDataSet;
    dspCliente: TDataSetProvider;
    qryCliente: TSQLQuery;
    SQLConnection1: TSQLConnection;
    qryGen: TSQLQuery;
    cdsClienteCLI_CODIGO: TIntegerField;
    cdsClienteCLI_NOME: TStringField;
    qryCliPedido: TSQLQuery;
    dtsLink: TDataSource;
    cdsCliPedido: TClientDataSet;
    DBGrid2: TDBGrid;
    dtsCliPedido: TDataSource;
    cdsClienteqryCliPedido: TDataSetField;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure cdsClienteNewRecord(DataSet: TDataSet);
    procedure dspClienteBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure cdsClienteCLI_CODIGOGetText(Sender: TField; var Text: String;
      DisplayText: Boolean);
    procedure dspClienteUpdateError(Sender: TObject;
      DataSet: TCustomClientDataSet; E: EUpdateError;
      UpdateKind: TUpdateKind; var Response: TResolverResponse);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure cdsClienteBeforeDelete(DataSet: TDataSet);
  private
    FCodigo: Integer;
    FNewCod: Integer;
    function RetornaNovoGenerator: Integer;
  public
    { Public declarations }
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

{$R *.dfm}

function TfrmPrincipal.RetornaNovoGenerator: Integer;
begin
  with qryGen do
  begin
    Open;
    try
      Result := FieldByName('NEWGEN').AsInteger;
    finally
      Close;
    end;
  end;
end;

procedure TfrmPrincipal.cdsClienteNewRecord(DataSet: TDataSet);
begin
  Dec(FCodigo);
  cdsCliente.FieldByName('CLI_CODIGO').AsInteger := FCodigo;
end;

procedure TfrmPrincipal.dspClienteBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  if UpdateKind = ukInsert then
  begin
    if SourceDs = qryCliente then
    begin
      FNewCod := RetornaNovoGenerator;
      DeltaDs.FieldByName('CLI_CODIGO').NewValue := FNewCod;
    end
    else
      if SourceDs = qryCliPedido then
        if DeltaDs.FieldByName('CLI_CODIGO').AsInteger < 0 then
          DeltaDs.FieldByName('CLI_CODIGO').NewValue := FNewCod;
  end;
end;

procedure TfrmPrincipal.FormCreate(Sender: TObject);
begin
  FCodigo := 0;
  cdsCliente.Open;
end;

procedure TfrmPrincipal.cdsClienteCLI_CODIGOGetText(Sender: TField;
  var Text: String; DisplayText: Boolean);
begin
  if Sender.AsInteger < 0 then Text := '' else Text := Sender.AsString;
end;

procedure TfrmPrincipal.dspClienteUpdateError(Sender: TObject;
  DataSet: TCustomClientDataSet; E: EUpdateError; UpdateKind: TUpdateKind;
  var Response: TResolverResponse);
begin
  MessageDlg(E.Message, mtError, [mbOk], 0);
end;

procedure TfrmPrincipal.Button1Click(Sender: TObject);
begin
  with cdsCliente do
  begin
    if State in dsEditModes then Post;
    if ApplyUpdates(0) <> 0 then CancelUpdates;
  end;
end;

procedure TfrmPrincipal.Button2Click(Sender: TObject);
begin
  cdsCliente.Append;
end;

procedure TfrmPrincipal.Button3Click(Sender: TObject);
begin
  with cdsCliente do
  begin
    if State in dsEditModes then Cancel;
    CancelUpdates;
  end;
end;

procedure TfrmPrincipal.Button4Click(Sender: TObject);
begin
  with cdsCliente do
  begin
    Delete;
    if ApplyUpdates(0) <> 0 then CancelUpdates;
  end;
end;

procedure TfrmPrincipal.cdsClienteBeforeDelete(DataSet: TDataSet);
begin
  with cdsCliPedido do
    while not IsEmpty do Delete;
end;

end.
