{ Invokable implementation File for TClientes which implements IClientes }

unit ClientesImpl;

interface

uses InvokeRegistry, Types, XSBuiltIns, ClientesIntf, DataClientes, SQLExpr;

type

  { TClientes }
  TClientes = class(TInvokableClass, IClientes)
  public
    procedure AtualizarStatusPedido; stdcall;
    procedure EfetuarDesconto; stdcall;
    function CalcularTotais(ACust_No: integer):Currency; stdcall;
  end;

implementation

uses SysUtils, DB, DBXpress;

var
  TD: TTransactionDesc;

{ TClientes }

procedure TClientes.AtualizarStatusPedido;
begin
  with dmDataClientes, sqlUpdate do
  begin
    try
      TD.TransactionID := 1;
      TD.IsolationLevel := xilREADCOMMITTED;

      if not SQLConnection.InTransaction then
        SQLConnection.StartTransaction(TD);

      sqlUpdate.CommandText := 'update sales set order_status = '+
       Quotedstr('cancel') + ' where order_status = ' + QuotedStr('waiting');
      sqlUpdate.ExecSQL;
      SQLConnection.Commit(TD);
    except
      SQLConnection.Rollback(TD);
    end;
  end;
end;

function TClientes.CalcularTotais(ACust_No: integer): Currency;
begin
  with dmDataClientes do
  begin
    try

      try
        qrTotais.ParamByName('cust_no').AsInteger := ACust_No;
        qrTotais.Open;
        Result := qrTotais.Fields[0].AsCurrency;
      except
        Result := 0;
      end;

    finally
      qrTotais.Close;
    end;
  end;
end;

procedure TClientes.EfetuarDesconto;
begin
 with dmDataClientes, qrClientes do
 begin
   try
   
     try
      SQL.Clear;
      SQL.Add('select cust_no, count(cust_no) from sales');
      SQL.Add('where order_status = '+ QuotedStr('open'));
      SQL.Add('group by cust_no');
      Open;
      First;

      TD.TransactionID := 1;
      TD.IsolationLevel := xilREADCOMMITTED;

      if not SQLConnection.InTransaction then
        SQLConnection.StartTransaction(TD);

      while not Eof do
      begin
        case Fields[1].AsInteger of
        1: begin
             sqlUpdate.CommandText := 'update sales set discount = discount * 1.25' +
               ' where cust_no = ' + Fields[0].AsString + ' and order_status = ' +
                QuotedStr('open');
             sqlUpdate.ExecSQL;
           end;

        2: begin
             sqlUpdate.CommandText := 'update sales set discount = discount * 1.5' +
              ' where cust_no = ' + Fields[0].AsString + ' and order_status = ' +
               QuotedStr('open');
             sqlUpdate.ExecSQL;
           end;

        3..10: begin
                sqlUpdate.CommandText := 'update sales set discount = discount * 2.0' +
                 ' where cust_no = ' + Fields[0].AsString + ' and order_status = ' +
                  QuotedStr('open');
                sqlUpdate.ExecSQL;
               end;
        end;
        Next;
      end;

      SQLConnection.Commit(TD);

     except
       on E:Exception do
       begin
         SQLConnection.Rollback(TD);
         raise Exception.Create(E.Message);
       end;
     end;

   finally
     Close;
   end;
 end;

end;

initialization
  { Invokable classes must be registered }
  InvRegistry.RegisterInvokableClass(TClientes);

end.
