{ Invokable implementation File for TConexao which implements IConexao }

unit uConexaoImpl;

interface

uses InvokeRegistry, Types, XSBuiltIns, uConexaoIntf, SQLExpr, Classes,
     DataConexao;

type

  { TConexao }
  TConexao = class(TInvokableClass, IConexao)
  private
    FConexao: boolean;
    function LPacotes(APacote: string): boolean;
    function UPacotes(APacote: string): boolean;
    procedure SetConexao(const Value: boolean);

  public
    property Conexao: boolean read FConexao write SetConexao;
    function ConexaoAtiva: boolean; stdcall;
    procedure CarregaPacotes;
    procedure DescarregaPacotes;
  end;

implementation

uses SysUtils, ComObj, AppServer;

var
  HandlesPackages: TList;
  HandlesPackagesNm: TStringList;

{ TConexao }

procedure TConexao.CarregaPacotes;
var
  vQry : TSQLQuery;
  vCount: integer;
begin
  try
    vQry := TSQLQuery.Create(nil);
    vQry.SQLConnection := dmDataConexao.DBEmployee;

    vQry.Sql.Add('select ptpkg from pacotes');
    vQry.open;
    vQry.first;
    vCount := 0;

    while not vQry.Eof do
    begin
      if not LPacotes(vQry.Fields[0].AsString) = False then
      begin
        inc(vCount);
        fmAppServer.NPac := vCount;
      end;
      vQry.Next;
    end;

   if vCount > 0 then
   begin
     Conexao := True;
     fmAppServer.Log := '--------------------------------------------------------';
   end;

  finally
    FreeAndNil(vQry);
  end;
end;

procedure TConexao.DescarregaPacotes;
var
  vI,vCount: integer;
begin

  vCount := 0;
  for vI := 0 to HandlesPackagesNm.Count - 1 do
  begin
    if not UPacotes(HandlesPackagesNm[vI]) = False then
    begin
      fmAppServer.NPac := fmAppServer.NPac  - 1;
      inc(vCount);
    end;
  end;

  if fmAppServer.NPac = 0 then
    Conexao := False;
      
  if vCount > 0 then
    fmAppServer.Log := '--------------------------------------------------------';
end;

function TConexao.ConexaoAtiva: boolean;
begin
  Result := Conexao;
end;

function TConexao.LPacotes(APacote: string): boolean;
var
  Handle: HModule;
  vIndex: integer;
begin
  Result := True;

  try
    Handle := LoadPackage(APacote);

    if (Handle > 0) and not (HandlesPackagesNm.Find(APacote, vIndex)) then
    begin
      HandlesPackages.Add(Pointer(Handle));
      HandlesPackagesNm.Add(APacote);
      fmAppServer.Log :=  'Pacote Carregado: ' + APacote;
    end
    else
      Result := False;

  except
    Result := False;
  end;
end;

function TConexao.UPacotes(APacote: string): boolean;
var
  vI: Integer;
  vModule: Cardinal;
begin
  Result := True;

  try
    vI := HandlesPackagesNm.IndexOf(APacote);
    vModule := Cardinal (HandlesPackages [vI]);
    UnRegisterModuleClasses(vModule);
    UnloadPackage(vModule);
    HandlesPackages.Delete(vI);
    HandlesPackagesNm.Delete(vI);
    fmAppServer.Log := 'Pacote Descarregado: ' + APacote;

  except
    Result:= False;
  end;

end;

procedure TConexao.SetConexao(const Value: boolean);
begin
  FConexao := Value;
  if FConexao = False then
    dmDataConexao.DBEmployee.Connected := False;
end;

initialization
  { Invokable classes must be registered }
  HandlesPackages := TList.Create;
  HandlesPackagesNm := TStringList.Create;
  InvRegistry.RegisterInvokableClass(TConexao);

finalization
  FreeAndNil(HandlesPackages);
  FreeAndNil(HandlesPackagesNm);
end.
