unit uAcesso;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, DBTables;

type
  TfmAcesso = class(TForm)
    Identificador: TLabel;
    Senha: TLabel;
    pnUsuario: TPanel;
    edIdentificador: TEdit;
    edSenha: TEdit;
    btEntrar: TBitBtn;
    btCancelar: TBitBtn;
    btAlterarSenha: TBitBtn;
    procedure edIdentificadorExit(Sender: TObject);
    procedure edSenhaExit(Sender: TObject);
    procedure btEntrarClick(Sender: TObject);
    procedure btCancelarClick(Sender: TObject);
    procedure edIdentificadorKeyPress(Sender: TObject; var Key: Char);
    procedure btAlterarSenhaClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    Contador: Word;
    AcessoLiberado: Boolean;
  public
    { Public declarations }
    IdUsuario: string;
  end;

var
  fmAcesso: TfmAcesso;

implementation

{$R *.DFM}

procedure TfmAcesso.FormActivate(Sender: TObject);
begin
  Contador := 0;
  AcessoLiberado := False;
  btEntrar.Enabled := False;
  btAlterarSenha.Enabled := False;
  edIdentificador.Text := '';
  edSenha.Text := '';
end;

procedure TfmAcesso.FormShow(Sender: TObject);
begin
  edIdentificador.SetFocus;
end;

procedure TfmAcesso.edIdentificadorExit(Sender: TObject);
begin
  if Contador = 3 then
    btCancelarClick(Self);
end;

procedure TfmAcesso.edSenhaExit(Sender: TObject);
var
  qryX: TQuery;
begin
  if Trim(edIdentificador.Text) = '' then
  begin
    Inc(Contador);
    pnUsuario.Caption := 'Usurio no identificado';
    edIdentificador.SetFocus;
    Exit;
  end;

  AcessoLiberado := False;
  pnUsuario.Caption := '';

  qryX := TQuery.Create(Self);

  with qryX do begin
    DatabaseName := 'C:\Ivan\Artigos\MenusDinamicos\Exemplo';
    Close;
    SQL.Text := ' select Nome, Senha from Usuario where IdUsuario = '
              + edIdentificador.Text;
    Open;
    if IsEmpty then
    begin
      Inc(Contador);
      pnUsuario.Caption := 'Usurio no identificado';
      edIdentificador.SetFocus;
    end
    else
    begin
      if FieldByName('Senha').AsString = edSenha.Text then
      begin
        AcessoLiberado := True;
        IdUsuario := edIdentificador.Text;
        pnUsuario.Caption := FieldByName('Nome').AsString;
        btEntrar.Enabled := True;
        btAlterarSenha.Enabled := True;
        btEntrar.SetFocus;
      end
      else
      begin
        Inc(Contador);
        pnUsuario.Caption := 'Usurio no identificado';
        edIdentificador.SetFocus;
      end;
    end;
  end;
end;

procedure TfmAcesso.btEntrarClick(Sender: TObject);
begin
  if AcessoLiberado then
    ModalResult := mrOK;
end;

procedure TfmAcesso.btAlterarSenhaClick(Sender: TObject);
var
  NovaSenha: string;
  qryX: TQuery;
begin
  NovaSenha := InputBox('Nova Senha', 'Digite a nova senha (at 10 caracteres)', '');

  if NovaSenha = '' then
  begin
    ShowMessage('A senha no pode estar em branco!');
    Exit;
  end;

  if Length(NovaSenha) > 10 then
  begin
    ShowMessage('A senha no pode ter mais de 10 caracteres!');
    Exit;
  end;

  qryX := TQuery.Create(Self);

  try
    with qryX do begin
      DatabaseName := 'C:\Ivan\Artigos\MenusDinamicos\Exemplo';
      Close;
      SQL.Text := ' update Usuario set Senha = "' + NovaSenha + '"'
                + ' where IdUsuario = ' + edIdentificador.Text;
      ExecSQL;
      ShowMessage('Senha alterada!');
      btEntrar.Enabled := False;
      btAlterarSenha.Enabled := False;
      edSenha.SetFocus;
    end;
  except
    raise;
  end;
end;

procedure TfmAcesso.btCancelarClick(Sender: TObject);
begin
  IdUsuario := '';
  ModalResult := mrOK;
end;

procedure TfmAcesso.edIdentificadorKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = #13 then
  begin
    Key := #0;
    Perform(CM_DialogKey, VK_TAB, 0);
  end;
end;

end.
