unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, DBTables, Buttons, Menus;

type
  TfmMain = class(TForm)
    tvMenu: TTreeView;
    Label1: TLabel;
    btNovoAcesso: TBitBtn;
    btSair: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure tvMenuClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure tvMenuKeyPress(Sender: TObject; var Key: Char);
    procedure btNovoAcessoClick(Sender: TObject);
    procedure btSairClick(Sender: TObject);
  private
    { Private declarations }
    tsForms: TStringList;
    IdUsuario: string;
    procedure MontaMenu;
    procedure MontaMenu2;
    function  GetPiece(AValue: string; ANumPiece: Integer; ADelimiter: string): string;
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

uses
  uAcesso, uCadastroClientes, uCadastroFornecedores, uPesquisaClientes,
  uPesquisaFornecedores;

{$R *.DFM}

procedure TfmMain.FormCreate(Sender: TObject);
begin
  tsForms := TStringList.Create;
  IdUsuario := '';
end;

procedure TfmMain.FormActivate(Sender: TObject);
begin
  if IdUsuario = '' then
  begin
    MontaMenu;
    tvMenu.FullExpand;
  end;
end;

procedure TfmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  tsForms.Free;
end;

procedure TfmMain.tvMenuClick(Sender: TObject);
var
  Form: TForm;
  FormRef: TComponentClass;
  FormName: string;
  i: Integer;
begin
  try
    for i := 0 to tsForms.Count - 1 do begin
      if AnsiPos(tvMenu.Selected.Text, tsForms.Strings[i]) > 0 then
      begin
        FormName := GetPiece(tsForms.Strings[i], 2, ';');
        Break;
      end;
    end;
    FormRef := TComponentClass(GetClass('T' + FormName));
    if FormRef <> nil then
    begin
      Application.CreateForm(FormRef, Form);
      Form.Show;
    end;
  except
    raise;
  end;
end;

procedure TfmMain.tvMenuKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    tvMenuClick(Self);
end;

procedure TfmMain.btNovoAcessoClick(Sender: TObject);
begin
  IdUsuario := '';
  MontaMenu;
  tvMenu.SetFocus;
  tvMenu.FullExpand;
end;

procedure TfmMain.btSairClick(Sender: TObject);
begin
  Close;
end;

procedure TfmMain.MontaMenu;
var
  Titulo: string;
  qryX: TQuery;
  node, subnode: TTreeNode;
begin
  Titulo := '';

  try
    fmAcesso.ShowModal;
  finally
    IdUsuario := fmAcesso.IdUsuario;
  end;

  if IdUsuario = '' then  Application.Terminate;

  tvMenu.Items.Clear;
  qryX := TQuery.Create(Self);
  qryX.DatabaseName := 'C:\Ivan\Artigos\MenusDinamicos\Exemplo';

  with qryX do begin
    Close;
    SQL.Text := ' select Titulo from Menu where IdMenu = 0 ';
    Open;

    if IsEmpty then
      node := tvMenu.Items.AddFirst(nil, 'Menu Principal')
    else
      node := tvMenu.Items.AddFirst(nil, FieldByName('Titulo').AsString);

    Close;
    SQL.Text := ' select p.IdPrograma, p.Nome, p.Form, p.IdMenu, m.Titulo '
              + ' from Programa p, Perfil f, Menu m '
              + ' where  f.IdPrograma = p.IdPrograma '
              + ' and    p.IdMenu     = m.IdMenu '
              + ' and    f.IdUsuario  = ' + IdUsuario
              + ' order  by p.IdPrograma, p.IdMenu ';
    Open;

    tsForms.Clear;

    while not Eof do begin
      if Titulo = '' then
      begin
        Titulo := FieldByName('Titulo').AsString;
        node := tvMenu.Items.AddChild(node, Titulo);
        tsForms.Add(Titulo + ';' + '');
        subnode := tvMenu.Items.AddChild(node, FieldByName('Nome').AsString);
        tsForms.Add(FieldByName('Nome').AsString + ';' + FieldByName('Form').AsString);
      end
      else
      if Titulo = FieldByName('Titulo').AsString then
      begin
        subnode := tvMenu.Items.AddChild(node, FieldByName('Nome').AsString);
        tsForms.Add(FieldByName('Nome').AsString + ';' + FieldByName('Form').AsString);
      end
      else
      begin
        Titulo := FieldByName('Titulo').AsString;
        node := tvMenu.Items.Add(node, Titulo);
        tsForms.Add(Titulo + ';' + '');
        subnode := tvMenu.Items.AddChild(node, FieldByName('Nome').AsString);
        tsForms.Add(FieldByName('Nome').AsString + ';' + FieldByName('Form').AsString);
      end;
      Next;
    end;
  end;
end;

procedure TfmMain.MontaMenu2;
var
  Menu: TextFile;
  Titulo: string;
  qryX: TQuery;
begin
  Titulo := '';

  try
    fmAcesso.ShowModal;
  finally
    IdUsuario := fmAcesso.IdUsuario;
  end;

  if IdUsuario = '' then Application.Terminate;

  AssignFile(Menu, ExtractFilePath(Application.ExeName) + 'menu.txt');
  Rewrite(Menu);

  qryX := TQuery.Create(Self);
  qryX.DatabaseName := 'C:\Ivan\Artigos\MenusDinamicos\Exemplo';

  with qryX do begin
    Close;
    SQL.Text := ' select Titulo from Menu where IdMenu = 0 ';
    Open;
    if IsEmpty then
      Writeln(Menu, 'Menu Principal')
    else
      Writeln(Menu, FieldByName('Titulo').AsString);

    Close;
    SQL.Text := ' select p.IdPrograma, p.Nome, p.Form, p.IdMenu, m.Titulo '
              + ' from Programa p, Perfil f, Menu m '
              + ' where  f.IdPrograma = p.IdPrograma '
              + ' and    p.IdMenu     = m.IdMenu '
              + ' and    f.IdUsuario  = ' + IdUsuario
              + ' order  by p.IdPrograma, p.IdMenu ';
    Open;

    tsForms.Clear;

    while not Eof do begin
      if Titulo = '' then
      begin
        Titulo := FieldByName('Titulo').AsString;
        Writeln(Menu, #9 + Titulo);
        tsForms.Add(Titulo + ';' + '');
        Writeln(Menu, #9#9 + FieldByName('Nome').AsString);
        tsForms.Add(FieldByName('Nome').AsString + ';' + FieldByName('Form').AsString);
      end
      else
      if Titulo = FieldByName('Titulo').AsString then
      begin
        Writeln(Menu, #9#9 + FieldByName('Nome').AsString);
        tsForms.Add(FieldByName('Nome').AsString + ';' + FieldByName('Form').AsString);
      end
      else
      begin
        Titulo := FieldByName('Titulo').AsString;
        Writeln(Menu, #9 + Titulo);
        tsForms.Add(Titulo + ';' + '');
        Writeln(Menu, #9#9 + FieldByName('Nome').AsString);
        tsForms.Add(FieldByName('Nome').AsString + ';' + FieldByName('Form').AsString);
      end;
      Next;
    end;
  end;

  CloseFile(Menu);
  tvMenu.LoadFromFile(ExtractFilePath(Application.ExeName) + 'menu.txt');
  DeleteFile('C:\Ivan\Artigos\MenusDinamicos\Exemplo\menu.txt');
end;

function TfmMain.GetPiece(AValue: string; ANumPiece: Integer;
  ADelimiter: string): string;
var
  xLength, xInd, xNumPiece: Integer;
  xChar: Char;
begin
  Result := '';

  if ANumPiece < 1 then Exit;

  xLength := Length(AValue);
  xNumPiece := 0;

  for xInd := 1 to xLength do begin
    xChar := AValue[xInd];
    if xChar = ADelimiter then
    begin
      Inc(xNumPiece);
      if (xNumPiece = ANumPiece) then Exit;
      Result := '';
    end
    else
    begin
      Result := Result + xChar;
    end;
  end;

  Inc(xNumPiece);

  if (xNumPiece <> ANumPiece) or (Length(Result) < 1) then
    Result := '';
end;

end.

