//==============================================================================
// Unit.......: uExemplo.pas
// Created....: 20/07/2004 20:15
// -----------------------------------------------------------------------------
// Author.....: Dennys dos Santos Sobrinho
// Copyright..: Revista ActiveDelphi
// E-Mail.....: dennys@activedelphi.com.br
//==============================================================================

unit uExemplo;

interface

uses
  SysUtils, Classes, HTTPApp, HTTPProd, DBXpress, FMTBcd, DB, SqlExpr;

type

  TTypeUsers    = (UserAdmin, 
                   UserDefault);
  
  TWebForms     = (LoginUser,
                   UserMenu,
                   RegisterUsers,
                   RegisterStudents);
                  
  TWebMessages  = (None, 
                   EmptyLogin, 
                   EmptyPassword, 
                   EmptyLoginPassword, 
                   EmptyUserName,
                   EmptyStudentName,
                   EmptyDocNumber,
                   EmptyDateBirth,
                   EmptyAddress,
                   DateBirthError,
                   DocNumberError,
                   UserNotLocated,
                   RegisteredSuccess);
  
  TWebModule1 = class(TWebModule)
    pp_Login: TPageProducer;
    pp_Menu: TPageProducer;
    pp_CadUsuarios: TPageProducer;
    pp_CadAlunos: TPageProducer;
    pp_Mensagem: TPageProducer;
    db_exemplo: TSQLConnection;
    qry_Usuarios: TSQLQuery;
    qry_UsuariosID_USER: TIntegerField;
    qry_UsuariosNM_USER: TStringField;
    qry_UsuariosDS_LOGIN: TStringField;
    qry_UsuariosDS_PASSWORD: TStringField;
    qry_Auxilio: TSQLQuery;
    procedure WebModule1wa_ValidateUserAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure pp_MensagemHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule1wa_LoginAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1wa_CadUsuariosAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1wa_CadAlunosAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1wa_gravarAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure pp_MenuHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
  private
    { Private declarations }
    function Login(sUsuario, sSenha : string) : byte;
  public
    { Public declarations }
    tpMessage : TWebMessages;
    tpForms   : TWebForms;
    tpUser    : TTypeUsers;  
  end;

var
  WebModule1: TWebModule1;

implementation

{$R *.xfm}

// -----------------------------------------------------------------------------

procedure TWebModule1.WebModule1wa_LoginAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  tpForms           := LoginUser;
  tpMessage         := None;
  Response.Content  := pp_Login.Content;
end;

// -----------------------------------------------------------------------------

procedure TWebModule1.WebModule1wa_ValidateUserAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  sLogin    : string;
  sPassword : string;
  iResult   : byte;
begin
  sLogin    := Request.ContentFields.Values['login'];
  sPassword := Request.ContentFields.Values['password'];
  if (Trim(sLogin) = '') and (Trim(sPassword) = '') then begin
    tpMessage         := EmptyLoginPassword;
    Response.Content  := pp_Mensagem.Content;
  end else if (Trim(sLogin) = '') then begin
    tpMessage         := EmptyLogin;
    Response.Content  := pp_Mensagem.Content;
  end else if (Trim(sPassword) = '') then begin
    tpMessage         := EmptyPassword;
    Response.Content  := pp_Mensagem.Content;
  end else begin
    tpForms   := USerMenu;
    tpMessage := None;
    iResult   := Login(sLogin, sPassword);
    if (iResult = 0) then begin
      tpMessage         := UserNotLocated;
      Response.Content  := pp_Mensagem.Content;
    end else if (iResult = 1) then begin
      tpUser            := UserAdmin;
      Response.Content  := pp_Menu.Content;
    end else if (iResult = 2) then begin
      tpUser            := UserDefault;
      Response.Content  := pp_Menu.Content;
    end;  
  end;
end;

// -----------------------------------------------------------------------------

procedure TWebModule1.pp_MensagemHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if (TagString = 'acao') then begin
    case tpMessage of
      EmptyLogin,
      EmptyPassword,
      EmptyLoginPassword,
      UserNotLocated,
      RegisteredSuccess: 
      begin
        case tpForms of
          LoginUser:        ReplaceText := 'pp_login';
          RegisterUsers:    ReplaceText := 'pp_cadusuarios';
          RegisterStudents: ReplaceText := 'pp_cadalunos';
        end;  
      end;  
    end;
  end else if (TagString = 'mensagem') then begin
    case tpMessage of
      EmptyLogin:         ReplaceText := ' necessrio informar o seu login de usurio!';
      EmptyPassword:      ReplaceText := ' necessrio informar a sua senha de acesso!';
      EmptyLoginPassword: ReplaceText := ' necessrio informar o seu usurio e senha de acesso!';
      UserNotLocated:     ReplaceText := 'No foi possvel localizar o usurio e senha no banco de dados!';
      EmptyUserName:      ReplaceText := ' necessrio informar o nome do usurio!';
      RegisteredSuccess:  ReplaceText := 'Registro gravado com sucesso!';
      EmptyStudentName:   ReplaceText := ' necessrio informar o nome do aluno!';
      EmptyDocNumber:     ReplaceText := ' necessrio informar o nmero do RG. do aluno!';
      EmptyDateBirth:     ReplaceText := ' necessrio informar a data de nascimento do aluno!';
      EmptyAddress:       ReplaceText := ' necessrio informar o endereo do aluno!';
      DateBirthError:     ReplaceText := 'Data de nascimento invlida.';
      DocNumberError:     ReplaceText := 'Nmero do RG. invlido.';
    end;
  end;  
end;

// -----------------------------------------------------------------------------

function TWebModule1.Login(sUsuario, sSenha : string) : byte;
var
  sValue : string;
begin
  with qry_Auxilio do begin
    Close;
    SQL.Text  := Format('select fl_administrator from users where (ds_login = %s and ds_password = %s)', [QuotedStr(UpperCase(sUsuario)), QuotedStr(LowerCase(sSenha))]);
    Open;
    sValue    := Fields[0].AsString;
    if (sValue = '') then
      Result := 0
    else if (sValue = 'SIM') then
      Result := 1
    else if (sValue = 'NAO') then
      Result := 2;
    Close;
  end;
end;

// -----------------------------------------------------------------------------

procedure TWebModule1.WebModule1wa_CadUsuariosAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  tpForms           := RegisterUsers;
  Response.Content  := pp_CadUsuarios.Content;
end;

// -----------------------------------------------------------------------------

procedure TWebModule1.WebModule1wa_CadAlunosAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  tpForms           := RegisterStudents;
  Response.Content  := pp_CadAlunos.Content;
end;

// -----------------------------------------------------------------------------

procedure TWebModule1.WebModule1wa_gravarAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  sUserName       : string;
  sLogin          : string;
  sPassword       : string;
  sAdministrator  : string;
  
  sStudentName    : string;
  sDocNumber      : string;
  sDateBirth      : string;
  sAddress        : string;
  //............................................................................
  function IsChar(sValue : string) : boolean;
  var
    iIndex : longword;
  begin
    for iIndex := 1 to Length(sValue) do
      Result := (sValue[iIndex] in ['A'..'Z', 'a'..'z']);
  end;
  //............................................................................
begin
  case tpForms of
    RegisterUsers:
    begin
      sUserName       := Request.ContentFields.Values['username'];
      sLogin          := UpperCase(Request.ContentFields.Values['login']);
      sPassword       := LowerCase(Request.ContentFields.Values['password']);
      sAdministrator  := Request.ContentFields.Values['admin'];
      if (Trim(sUserName) = '') then begin
        tpMessage         := EmptyUserName;
        Response.Content  := pp_Mensagem.Content;
      end else if (Trim(sLogin) = '') then begin
        tpMessage         := EmptyLogin;
        Response.Content  := pp_Mensagem.Content;
      end else if (Trim(sPassword) = '') then begin
        tpMessage         := EmptyPassword;
        Response.Content  := pp_Mensagem.Content;
      end else begin
        with qry_Auxilio do begin
          Close;
          SQL.Text := Format('insert into users (id_user, nm_user, ds_login, ds_password, fl_administrator) values ((select max(id_user)+1 from users), %s, %s, %s, %s)', [QuotedStr(sUserName), QuotedStr(sLogin), QuotedStr(sPassword), QuotedStr(sAdministrator)]);
          ExecSQL;                                               
        end;
        tpMessage         := RegisteredSuccess;
        Response.Content  := pp_Mensagem.Content;
      end;
    end;
    RegisterStudents:
    begin
      sStudentName    := Request.ContentFields.Values['studentname'];
      sDocNumber      := Request.ContentFields.Values['docnumber'];
      sDateBirth      := Request.ContentFields.Values['datebirth'];
      sAddress        := Request.ContentFields.Values['address'];
      if (Trim(sStudentName) = '') then begin
        tpMessage         := EmptyStudentName;
        Response.Content  := pp_Mensagem.Content;
      end else if (Trim(sDocNumber) = '') then begin
        tpMessage         := EmptyDocNumber;
        Response.Content  := pp_Mensagem.Content;
      end else if (Trim(sDateBirth) = '') then begin
        tpMessage         := EmptyDateBirth;
        Response.Content  := pp_Mensagem.Content;
      end else if (Trim(sAddress) = '') then begin
        tpMessage         := EmptyAddress;
        Response.Content  := pp_Mensagem.Content;
      end else if IsChar(sDocNumber) then begin  
        tpMessage         := DocNumberError;
        Response.Content  := pp_Mensagem.Content;
      end else begin
        try
          StrToDate(sDateBirth);
        except
          tpMessage         := DateBirthError;
          Response.Content  := pp_Mensagem.Content;
          Exit;
        end;
        with qry_Auxilio do begin
          Close;
          SQL.Text := Format('insert into students (id_student, nm_student, nr_document, dt_birth, nm_address) values ((select max(id_student)+1 from students), %s, %s, %s, %s)', [QuotedStr(sStudentName), QuotedStr(sDocNumber), QuotedStr(sDateBirth), QuotedStr(sAddress)]);
          ExecSQL;                                               
        end;
        tpMessage         := RegisteredSuccess;
        Response.Content  := pp_Mensagem.Content;
      end;
    end;
  end;    
end;

// -----------------------------------------------------------------------------

procedure TWebModule1.pp_MenuHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
  if (TagString = 'itemmenu') then begin
    case tpUser of
      UserAdmin:    ReplaceText := '<li><a href=''/exemplo/pp_cadusuarios''> Cadastro de Usurios </a>';
      UserDefault:  ReplaceText := '';
    end;  
  end;
end;

// -----------------------------------------------------------------------------

end.
