{-----------------------------------------------------------------------------
 Unit Name: MainFrm
 Author:    Jos Roberto
 Date:      19-jul-2004
 Purpose:   Revista ActiveDelphi - 6 Edio
-----------------------------------------------------------------------------}
unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Contnrs, ExtCtrls;

type
  TForm1 = class(TForm)
    lvContatos: TListView;
    pnlDescricao: TPanel;
    gbDadosAmigos: TGroupBox;
    Label1: TLabel;
    edtCodigo: TEdit;
    edtNomeAmigo: TEdit;
    Label2: TLabel;
    dtpDataAniversario: TDateTimePicker;
    Label3: TLabel;
    memEndereco: TMemo;
    Label4: TLabel;
    pnlButtonsContato: TPanel;
    btnIncluirContato: TButton;
    btnEditarContato: TButton;
    btnDeletarContato: TButton;
    pnlButtonsCtrl: TPanel;
    btnIncluir: TButton;
    btnEditar: TButton;
    btnDeletar: TButton;
    btnGravar: TButton;
    btnCancelar: TButton;
    lblQtdeAmigos: TLabel;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnIncluirClick(Sender: TObject);
    procedure btnGravarClick(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure btnIncluirContatoClick(Sender: TObject);
    procedure btnCancelarClick(Sender: TObject);
    procedure btnEditarClick(Sender: TObject);
    procedure btnDeletarContatoClick(Sender: TObject);
    procedure btnEditarContatoClick(Sender: TObject);
    procedure btnDeletarClick(Sender: TObject);
  private
    // Atualiza o Label informando o Registro atual.
    procedure UpdateRecordNo(const ARecNo, ARecordCount: Integer);
    // Habilita / Desabilita os Botes de Gravao das informaes de um Amigo na Agenda.
    procedure EnableButtons(const AEnable: Boolean);
  end;

  TContatoAmigo = class(TComponent)
  private
    FID: Integer;
    FTelefone: string;
    FContato: string;
  public
    constructor Create(const AID: Integer; ATelefone, AContato: String); reintroduce;
    //*
    property ID: Integer read FID;
    property Telefone: string read FTelefone write FTelefone;
    property Contato: string read FContato write FContato;
  end;

  TAmigos = class(TCollectionItem)
  private
    FContatos: TComponentList;
    FAmigoID: Integer;
    FNomeAmigo: String;
    FDataAniversario: TDate;
    FEndereco: TStrings;
  protected
    (* Lista de contatos de um Amigo *)
    property Contatos: TComponentList read FContatos write FContatos;
  public
    // Contrutor
    constructor Create(Collection: TCollection); override;
    // Destrutor
    destructor Destroy; override;
    (* Adicionar Contato(s) ao Amigo *)
    procedure AdicionarContato(const ATelefone, AContato: String);
    (* Atualizar Contato(s) *)
    procedure AtualizarContato(const AID: Integer; const ATelefone, AContato: String);
    (* Listar Todos os Contatos de um Amigo *)
    procedure ListarContatos(AListView: TListView);
    (* Remover Todos os Contatos de um Amigo *)
    procedure RemoverContatos;
    (* Remover um Contato especfico de um Amigo *)
    procedure RemoverContato(const AID: Integer);
    // ID do amigo na  Agenda.
    property AmigoID: Integer read FAmigoID;
    property NomeAmigo: String read FNomeAmigo write FNomeAmigo;
    property Endereco: TStrings read FEndereco write FEndereco;
    property DataAniversario: TDate read FDataAniversario write FDataAniversario;
  end;

  TAgendaState = (asInserting, asEditing, asBrowser);

  TAgenda = class(TCollection)
  private
    FRecNo: Integer;
    FListView: TListView;
    FAgendaState: TAgendaState;
  protected
    procedure Notify(Item: TCollectionItem; Action: TCollectionNotification); override;
    property ListView: TListView read FListView write FListView;
  public
    // Construtor
    constructor Create(const AListView: TListView); reintroduce;
    // Destrutor
    function Add: TAmigos;
    function Next: TAmigos;
    function Prior: TAmigos;
    function First: TAmigos;
    function Last: TAmigos;
    property RecNo: Integer read FRecNo;
    property AgendaState: TAgendaState read FAgendaState write FAgendaState;
  end;

var
  Form1: TForm1;

implementation

uses CadContatoFrm;

{$R *.dfm}

var
  Agenda: TAgenda;

resourcestring
  strQtdeAmigos = 'Registros --- %d/%d';

{ TAgenda }

// Mtodo para adicionar um Novo Item  Coleo.
function TAgenda.Add: TAmigos;
begin
  Result := TAmigos(inherited Add);
end;

// Construtor da Coleo.
constructor TAgenda.Create(const AListView: TListView);
begin
  inherited Create(TAmigos);
  FRecNo := 0;
  FListView := AListView;
  FAgendaState := asBrowser;
end;

{ TAmigos }

// Adiciona um contato  um Amigo corrente na Agenda.
procedure TAmigos.AdicionarContato(const ATelefone, AContato: String);
begin
  if not Assigned(FContatos) then
    FContatos := TComponentList.Create;
  FContatos.Add(TContatoAmigo.Create(FContatos.Count + 1, ATelefone, AContato));
end;

// Atualiza o Contato corrente.
procedure TAmigos.AtualizarContato(const AID: Integer; const ATelefone, AContato: String);
begin
  with (FContatos[AID] as TContatoAmigo) do
  begin
    Telefone := ATelefone;
    Contato := AContato;
  end;//with..do.
end;

constructor TAmigos.Create(Collection: TCollection);
begin
  inherited;
  FContatos := TComponentList.Create;
  Endereco := TStringList.Create;
end;

// verifica se h Contatos, se tiver libera-os.
destructor TAmigos.Destroy;
begin
  if Assigned(FContatos) then
    FContatos.Free;
  FEndereco.Free;
  inherited;
end;

// Mtodo que recebe um TListView para poder mostrar os
// contatos do Amigo corrente.
procedure TAmigos.ListarContatos(AListView: TListView);
var
  AListItem: TListItem;
  inIndex: Integer;
begin
  if not(Assigned(FContatos)) then
    raise Exception.Create('No temos contato(s) para ser exebido(s)');

  AListView.Clear;
  for inIndex := 0 to FContatos.Count - 1 do
  begin
    AListItem := AListView.Items.Add;
    AListItem.Caption := IntToStr(TContatoAmigo(FContatos[inIndex]).ID);
    AListItem.SubItems.Add( TContatoAmigo(FContatos[inIndex]).Contato );
    AListItem.SubItems.Add( TContatoAmigo(FContatos[inIndex]).Telefone );
  end;//for..do
end;

(* Mtodos de Controle dos Registros de Amigos da Agenda
   suas funcionalidades so idnticas s de um TDataSet. *)

// vai para o ultimmo registro.
function TAgenda.Last: TAmigos;
begin
  FRecNo := Count - 1;
  Result := (Items[FRecNo] as TAmigos);
  // Exibe os contatos.
  Result.ListarContatos(ListView);
end;

// vai para o proximo registro.
function TAgenda.Next: TAmigos;
begin
  if( FRecNo < Count - 1 ) then
    Inc(FRecNo);
  Result := (Items[FRecNo] as TAmigos);
  // Exibe os contatos.
  Result.ListarContatos(ListView);
end;

// vai para o registro anterior.
function TAgenda.Prior: TAmigos;
begin
  if (FRecNo > 0) then
    Dec(FRecNo);
  Result := (Items[FRecNo] as TAmigos);
  // Exibe os contatos.
  Result.ListarContatos(ListView);
end;

// vai para o primeiro registro.
function TAgenda.First: TAmigos;
begin
  FRecNo := 0;
  Result := (Items[FRecNo] as TAmigos);
  // Exibe os contatos.
  Result.ListarContatos(ListView);
end;

(* Fim dos Mtodos de Controle dos Registros *)

// Checa o tipo de ao executado na Agenda.
procedure TAgenda.Notify(Item: TCollectionItem; Action: TCollectionNotification);
begin
  inherited;
  case Action of
    // adicionar um item na agenda(Coleo de Amigos)
    cnAdded: begin
      FRecNo := Count - 1;
      TAmigos(Items[Count - 1]).FAmigoID := Count;
    end;
  end;
end;

// remove um contato especifico.
procedure TAmigos.RemoverContato(const AID: Integer);
begin
  FContatos[AID].Free;
  // Exibe os contatos.
  ListarContatos(Agenda.ListView);
end;

procedure TAmigos.RemoverContatos;
begin
  FreeAndNil(FContatos);
end;

{ TContatoAmigo }

constructor TContatoAmigo.Create(const AID: Integer; ATelefone,
  AContato: String);
begin
  FID := AID;
  FTelefone := ATelefone;
  FContato := AContato;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  // recebe a data atual.
  dtpDataAniversario.Date := Date;
  // Instancia um Objeto Agenda.
  Agenda := TAgenda.Create(lvContatos);
  // atualiza o Label de registro atual/Quantidade de registros.
  UpdateRecordNo(Agenda.RecNo, Agenda.Count);
end;

procedure TForm1.btnIncluirClick(Sender: TObject);
begin
  // Limpa os Controles
  edtCodigo.Clear;
  edtNomeAmigo.Clear;
  memEndereco.Clear;
  lvContatos.Clear;
  // Habilita o GroupBox.
  gbDadosAmigos.Enabled := True;
  edtNomeAmigo.SetFocus;
  // Habilita os Botoes de Gravao das Informaes do Amigo.
  EnableButtons(True);
  // atualiza o Estado da Agenda.
  Agenda.AgendaState := asInserting;
end;

procedure TForm1.btnGravarClick(Sender: TObject);
begin
  case Agenda.AgendaState of
    asInserting: begin
      // Adiciona um novo amigo na Agenda.
      with Agenda.Add do
      begin
        NomeAmigo := edtNomeAmigo.Text;
        DataAniversario := dtpDataAniversario.Date;
        // recebe o conteudo do Memo.
        Endereco.Assign(memEndereco.Lines);
      end;//with..do.

      // recebe o Codigo do Novo Amigo Cadastrado.
      edtCodigo.Text := IntToStr(TAmigos(Agenda.Items[Agenda.Count - 1]).AmigoID);
      // atualiza o Label de registro atual/Quantidade de registros.
      lblQtdeAmigos.Caption := Format(strQtdeAmigos, [Agenda.RecNo + 1, Agenda.Count]);
    end;//asInserting.
    asEditing: begin
      // Adiciona um novo amigo na Agenda.
      with (Agenda.Items[Agenda.RecNo] as TAmigos) do
      begin
        NomeAmigo := edtNomeAmigo.Text;
        DataAniversario := dtpDataAniversario.Date;
        // recebe o conteudo do Memo.
        Endereco.Assign(memEndereco.Lines);
      end;//with..do.
    end;//asEditing.
  end;//case..of.

  // Habilita / desabilita os Botoes de gravao das informaes do amigo na Agenda.
  EnableButtons(False);
  // Desabilita o GroupBox.
  gbDadosAmigos.Enabled := False;
  // atualiza o Estado da Agenda.
  Agenda.AgendaState := asBrowser;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  // volta ao primeiro amigo na agenda.
  with Agenda.First do
  begin
    edtCodigo.Text := IntToStr(AmigoID);
    edtNomeAmigo.Text := NomeAmigo;
    memEndereco.Lines.Assign(Endereco);
    // Atualiza o Label de registro atual/Quantidade de registros.
    UpdateRecordNo(Agenda.RecNo + 1, Agenda.Count);
  end;
end;

// Mtodo: Para Atualizar o Label de registro atual/Quantidade de registros.
procedure TForm1.UpdateRecordNo(const ARecNo, ARecordCount: Integer);
begin
  lblQtdeAmigos.Caption := Format(strQtdeAmigos, [ARecNo, ARecordCount]);
end;

procedure TForm1.Button12Click(Sender: TObject);
begin
  // retorna ao amigo anterior na lista.
  with Agenda.Prior do
  begin
    edtCodigo.Text := IntToStr(AmigoID);
    edtNomeAmigo.Text := NomeAmigo;
    memEndereco.Lines.Assign(Endereco);
    // Atualiza o Label de registro atual/Quantidade de registros.
    UpdateRecordNo(Agenda.RecNo + 1, Agenda.Count)
  end;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
  // avana para o prximo amigo na agenda.
  with Agenda.Next do
  begin
    edtCodigo.Text := IntToStr(AmigoID);
    edtNomeAmigo.Text := NomeAmigo;
    memEndereco.Lines.Assign(Endereco);
    // Atualiza o Label de registro atual/Quantidade de registros.
    UpdateRecordNo(Agenda.RecNo + 1, Agenda.Count);
  end;
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
  // avana para o ltimo item na agenda.
  with Agenda.Last do
  begin
    edtCodigo.Text := IntToStr(AmigoID);
    edtNomeAmigo.Text := NomeAmigo;
    memEndereco.Lines.Assign(Endereco);
    // Atualiza o Label de registro atual/Quantidade de registros.
    UpdateRecordNo(Agenda.RecNo + 1, Agenda.Count);
  end;
end;

procedure TForm1.btnIncluirContatoClick(Sender: TObject);
begin
  // caso no tenha sido cadastrado nenhum amigo na agenda levanta uma exeo.
  if Agenda.Count = 0 then
    raise Exception.Create('No Existe Nenhum Amigo na Agenda!');
  try
    // chama o Formulrio de Cadastramento de Contatos.
    FrmCadContato := TFrmCadContato.Create(Application);
    if FrmCadContato.ShowModal = mrOK then
    begin
      // adiciona o Contato para o amigo corrente na Agenda.
      (Agenda.Items[Agenda.RecNo] as TAmigos).AdicionarContato(FrmCadContato.Telefone, FrmCadContato.Contato);
      // Lista o(s) Contato(s) do amigo corrente na Agenda.
      (Agenda.Items[Agenda.RecNo] as TAmigos).ListarContatos(lvContatos);
    end;
  finally
    // libera o Form de cadastramento de Contatos.
    FrmCadContato.Free;
  end;
end;

// Habilita / Desabilita os Botoes de Gravao das
// informaes de um Amigo na Agenda.
procedure TForm1.EnableButtons(const AEnable: Boolean);
begin
  btnIncluir.Enabled := not AEnable;
  btnEditar.Enabled := not AEnable;
  btnDeletar.Enabled := not AEnable;
  btnGravar.Enabled := AEnable;
  btnCancelar.Enabled := AEnable;        
end;

procedure TForm1.btnCancelarClick(Sender: TObject);
begin
  // Limpa os campos.
  edtCodigo.Clear;
  edtNomeAmigo.Clear;
  memEndereco.Clear;
  lvContatos.Clear;
  //*
  EnableButtons(False);
  // Vai para o Primeiro Registro.
  with Agenda.First do
  begin
    // recebe as informaes da Coleo.
    edtCodigo.Text := IntToStr(AmigoID);
    edtNomeAmigo.Text := NomeAmigo;
    memEndereco.Lines.Assign(Endereco);
  end;
  // desabilita o GroupBox.
  gbDadosAmigos.Enabled := False;
end;

procedure TForm1.btnEditarClick(Sender: TObject);
begin
  gbDadosAmigos.Enabled := True;
  edtNomeAmigo.SetFocus;
  EnableButtons(True);
  Agenda.AgendaState := asEditing;  
end;

procedure TForm1.btnDeletarContatoClick(Sender: TObject);
begin
  // verifica se h contato na lista.
  if lvContatos.Items.Count < 1 then
    // em caso de no existir contatos, levanta exceo.
    raise Exception.Create('No h contato(s) para ser deletado(s)');
  // deleta o contato corrente na lista de contato. 
  (Agenda.Items[Agenda.RecNo] as TAmigos).RemoverContato(lvContatos.Selected.Index);
end;

procedure TForm1.btnEditarContatoClick(Sender: TObject);
begin
  // caso no tenha sido cadastrado nenhum amigo na agenda levanta uma exeo.
  if Agenda.Count = 0 then
    raise Exception.Create('No Existe Nenhum Amigo na Agenda!');
  if lvContatos.SelCount = 0 then
    raise Exception.Create('Selecione um Contato para Edio');
  try
    // chama o Formulrio de Cadastramento de Contatos.
    FrmCadContato := TFrmCadContato.Create(Application);
    // passa as informaes do contato a ser editato.
    FrmCadContato.edtPessoaContato.Text := lvContatos.Items[lvContatos.Selected.Index].SubItems[0];
    FrmCadContato.medtTelefone.Text := lvContatos.Items[lvContatos.Selected.Index].SubItems[1];
    if FrmCadContato.ShowModal = mrOK then
    begin
      // Atualiza o Contato para o amigo corrente na Agenda.
      (Agenda.Items[Agenda.RecNo] as TAmigos).AtualizarContato(lvContatos.Selected.Index, FrmCadContato.Telefone, FrmCadContato.Contato);
      // Lista o(s) Contato(s) do amigo corrente na Agenda.
      (Agenda.Items[Agenda.RecNo] as TAmigos).ListarContatos(lvContatos);
    end;
  finally
    // libera o Form de cadastramento de Contatos.
    FrmCadContato.Free;
  end;
end;

procedure TForm1.btnDeletarClick(Sender: TObject);
begin
  if (Agenda.Count > 0) and
     (MessageBox(Handle, 'Deseja apagar o amigo da Agenda e Seus Contatos?', 'Agenda', MB_ICONQUESTION + MB_YESNO + MB_DEFBUTTON1) = IDYes) then
  begin
    (Agenda.Items[Agenda.RecNo] as TAmigos).RemoverContatos;
    Agenda.Items[Agenda.RecNo].Free;
    // Atualiza o Label de registro atual/Quantidade de registros.
    UpdateRecordNo(Agenda.RecNo + 1, Agenda.Count);

    // caso ainda tenha alguem na lista da Agenda
    // executa o Prior, trazendo o Amigo anterior.
    if Agenda.Count > 0 then
      Button12Click(nil)
    // seno limpa todos os campos.
    else begin
      edtCodigo.Clear;
      edtNomeAmigo.Clear;
      memEndereco.Clear;
      lvContatos.Clear;
    end;
  end;
end;

end.
