unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFrmReader = class(TForm)
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmReader: TFrmReader;

implementation

{$R *.dfm}

const
  //our ExeBuffer signature
  ExeBufSig = 'EB1.0';

type
  EExeBuf = class (Exception);

  //the actual buffer type
  TExeBuf = Array of char;

  //the Footer for our executable format
  TExeBufFooter = record
    OriginalSize : Integer;
    Sig : Array[0..4] of char;
  end;

{-----------------------------------------------------------------------------
  Procedure: ExeBufToString
  Author:    Roberto Arajo
  Date:      19-ago-2004
  Arguments: const ExeBuf : TExeBuf
  Result:    L o Buffer do executvel e converte em String.
-----------------------------------------------------------------------------}
function ExeBufToString (const ExeBuf : TExeBuf) : String;
begin
  // seta o tamanho do resultado da funo para o tamanho do
  // Buffer localizado no final do arquivo.
  SetLength (Result,Length(ExeBuf));
  // copia os Bytes do Buffer para o resultado da funo.
  Move (Pointer(ExeBuf)^,Pointer(Result)^,Length(ExeBuf));
end;

{-----------------------------------------------------------------------------
  Procedure: GetExeDataEx
  Author:    Roberto Arajo
  Date:      20-ago-2004
  Arguments: ExeName : String; var ExeBuf : TExeBuf
  Result:    Obtem as informaes da seo Footer.
-----------------------------------------------------------------------------}
procedure GetExeDataEx(ExeName : String; var ExeBuf : TExeBuf);
var
  FileStream: TFileStream;
  CurrSz, BufSize: Integer;
  Footer: TExeBufFooter;
begin
  // inicializa o objeto de stream.
  FileStream := nil;
  try
    // cria o objeto de Stream, com o nome do arquivo que ser lido.
    FileStream := TFileStream.Create(ExeName, fmShareDenyNone);
    // obtem o tamanho inicial do arquivo.
    CurrSz := FileStream.Size;

    // direciona o cursor do inicio para o final do arquivo e
    // l o contedo que est no final do arquivo.
    FileStream.Seek(CurrSz - SizeOf(Footer), soFromBeginning);
    FileStream.ReadBuffer(Footer, Sizeof(Footer));

    // verifica se a TAG que est no Footer(Rodap) do arquivo  igual a Constante.
    if Footer.Sig <> ExeBufSig then
      raise EExeBuf.Create ('Sem dados escritos no EXE!');

    // pega o tamanho do do buffer que possui o texto.
    BufSize := CurrSz - Footer.OriginalSize - SizeOf(Footer);
    // seta o tamanho da variavel que conter o texto localizado no final do arquivo.
    SetLength(ExeBuf,BufSize);

    // Direciona o cursor do inicio para o final onde encontra-se o texto procurado.
    FileStream.Seek(Footer.OriginalSize, soFromBeginning);
    // L o texto!
    FileStream.ReadBuffer(Pointer(ExeBuf)^, BufSize);
  finally
    // Libera o objeto de Stream.
    FileStream.Free;
  end;
end;

procedure TFrmReader.FormCreate(Sender: TObject);
var
  ExeBuf : TExeBuf;
begin
  GetExeDataEx('Master_EXE.exe', ExeBuf);
  Label1.Caption := Format(Label1.Caption, [ExeBufToString(ExeBuf)]);
  if ExeBufToString(ExeBuf) <> 'Active Delphi' then
  begin
    ShowMessage('Dados do Arquivo esto Corrompidos');
    Application.Terminate;
  end
end;

end.
