unit MainWriterFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFrmWriter = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmWriter: TFrmWriter;

implementation

{$R *.dfm}

const
  // Assinatura do Buffer do arquivo.
  ExeBufSig = 'EB1.0';

type
  EExeBuf = class (Exception);

  // Tipo para o buffer.
  TExeBuf = Array of char;

  // Rodap para nosso formato do executvel.
  TExeBufFooter = record
    OriginalSize : Integer;
    Sig : Array[0..4] of char;
  end;

{-----------------------------------------------------------------------------
  Procedure: StringToExeBuf
  Author:    Roberto Arajo
  Date:      19-ago-2004
  Arguments: const S : String; var ExeBuf : TExeBuf
  Result:    Repassa a string  ser escrita no arquivo para um Buffer, o
             qual ser inserido no rodap do arquivo.
-----------------------------------------------------------------------------}
procedure StringToExeBuf (const S : String; var ExeBuf : TExeBuf);
begin
  // seta o tamanho do parametro ExeBuf para o tamanho da string informada.
  SetLength(ExeBuf, Length(S));
  // Copia os Bytes da String informada para o parametro ExeBuf
  Move(Pointer(S)^,Pointer(ExeBuf)^,Length(S));
end;

{-----------------------------------------------------------------------------
  Procedure: SetExeData
  Author:    Roberto Arajo
  Date:      19-ago-2004
  Arguments: ExeName : String; ExeBuf : TExeBuf
  Result:    escrever o contedo do buffer passado como parametro no rodap
             do arquivo.
-----------------------------------------------------------------------------}
procedure SetExeData (ExeName : String; ExeBuf : TExeBuf);
var
  fFile : File;
  BufSz,OrigSz : Integer;
  Footer : TExeBufFooter;
begin
  // associa o arquivo informado no parametro da procedure
  // para a varivel "fFile".
  AssignFile (fFile, ExeName);
  // inicializa
  Reset(fFile, 1);
  try
    // Obtem o tamanho original do arquivo.
    OrigSz := FileSize(fFile);
    // vai para o final do arquivo.
    Seek(fFile, OrigSz);
    // escrevendo nossa informao padronizada alm do final do arquivo.
    BufSz := Length(ExeBuf);
    BlockWrite(fFile, Pointer(ExeBuf)^, BufSz);
    { Escrevendo em nosso rodap. }

    // inicializado a estrutura de registro.
    FillChar (Footer, SizeOf(Footer), 0);
    // setando valores que sero teis no momento de
    // validao do contedo do rodap.
    Footer.OriginalSize := OrigSz;
    Footer.Sig := ExeBufSig;
    // escreve nossa informao padronizada no final do arquivo.
    BlockWrite(fFile, Footer, Sizeof(Footer));
  finally
    // fecha o processo do arquivo, consequentemente fechando o arquivo.
    CloseFile (fFile);
  end;
end;

procedure TFrmWriter.Button1Click(Sender: TObject);
const
  FileName = 'Master_EXE.exe';
var
  ExeBuf : TExeBuf;
begin
  StringToExeBuf(Edit1.Text,ExeBuf);
  SetExeData(FileName,ExeBuf);
  ShowMessage('Informao escrita com Sucesso!');
end;

end.
