program Project1;

{$APPTYPE CONSOLE}

type
  Numero = record
    ValorReal: Double;

    class operator Explicit(Num: Numero): string;
    class operator Explicit(Num: Numero): Double;
    class operator Explicit(Num: Numero): Int32;

    class operator Implicit(Valor: Double): Numero;
    class operator Implicit(Valor: Int32): Numero;
    class operator Implicit(Valor: string): Numero;

    class operator Add(Num1, Num2: Numero): Numero;
    class operator Subtract(Num1, Num2: Numero): Numero;
    class operator Multiply(Num1, Num2: Numero): Numero;
    class operator Divide(Num1, Num2: Numero): Numero;
  end;

{ Numero }

class operator Numero.Explicit(Num: Numero): Double;
begin
  // resultado em double
  Result := Num.ValorReal;
end;

class operator Numero.Explicit(Num: Numero): Int32;
begin
  // resultado em inteiro
  Result := Convert.ToInt32(Num.ValorReal);
end;

class operator Numero.Explicit(Num: Numero): string;
begin
  // resultado em string
  Result := System.String.Format('{0:C2}', [Num.ValorReal]);
end;

class operator Numero.Implicit(Valor: Double): Numero;
begin
  // pegando o valor em formato double
  Result.ValorReal := Valor;
end;

class operator Numero.Implicit(Valor: Int32): Numero;
begin
  // pegando o valor em formato inteiro
  Result.ValorReal := Convert.ToDouble(Valor);
end;

class operator Numero.Implicit(Valor: string): Numero;
begin
  // pegando o valor em formato string
  Result.ValorReal := Convert.ToDouble(Valor);
end;

class operator Numero.Add(Num1, Num2: Numero): Numero;
begin
  // adio
  Result.ValorReal := Num1.ValorReal + Num2.ValorReal;
end;

class operator Numero.Subtract(Num1, Num2: Numero): Numero;
begin
  // subtrao
  Result.ValorReal := Num1.ValorReal - Num2.ValorReal;
end;

class operator Numero.Divide(Num1, Num2: Numero): Numero;
begin
  // diviso
  Result.ValorReal := Num1.ValorReal / Num2.ValorReal;
end;

class operator Numero.Multiply(Num1, Num2: Numero): Numero;
begin
  // multiplicao
  Result.ValorReal := Num1.ValorReal * Num2.ValorReal;
end;

var
  Num1,
  Num2: Numero;
begin
  Num1 := 10;
  Num1 := '10';
  Num2 := 20.5;
  
  Num1 := Num1 + Num2;

  // imprimindo em formato string
  WriteLn(Num1);
  WriteLn(string(Num1));

  // imprimindo em formato inteiro
  WriteLn(Int32(Num1));

  // imprimindo em formato double
  WriteLn(Double(Num1));

  ReadLn;
end.
