unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Diagnostics, System.Text;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    txtNumero1: System.Windows.Forms.TextBox;
    txtNumero2: System.Windows.Forms.TextBox;
    lblResultado: System.Windows.Forms.Label;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    const
       // Constante que sera usada para definir o nome do log da nossa aplicao.
      LogName = 'MyLog';
      // Constante que ser usada para definir a origem dos eventos de nossa aplicao
      LogSource = 'MySource';
      // Constante que ser usada para definir o computador onde ser gravado o log
      Computador = '.';
    Var
      // Objeto para acesso ao log de eventos
      WEvent : EventLog;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.txtNumero1 := System.Windows.Forms.TextBox.Create;
  Self.txtNumero2 := System.Windows.Forms.TextBox.Create;
  Self.lblResultado := System.Windows.Forms.Label.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(32, 112);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Dividir';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // txtNumero1
  // 
  Self.txtNumero1.Location := System.Drawing.Point.Create(32, 24);
  Self.txtNumero1.Name := 'txtNumero1';
  Self.txtNumero1.TabIndex := 1;
  Self.txtNumero1.Text := 'txtNumero1';
  // 
  // txtNumero2
  // 
  Self.txtNumero2.Location := System.Drawing.Point.Create(32, 72);
  Self.txtNumero2.Name := 'txtNumero2';
  Self.txtNumero2.TabIndex := 2;
  Self.txtNumero2.Text := 'txtNumero2';
  // 
  // lblResultado
  // 
  Self.lblResultado.Location := System.Drawing.Point.Create(32, 152);
  Self.lblResultado.Name := 'lblResultado';
  Self.lblResultado.TabIndex := 3;
  Self.lblResultado.Text := 'lblResultado';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(168, 182);
  Self.Controls.Add(Self.lblResultado);
  Self.Controls.Add(Self.txtNumero2);
  Self.Controls.Add(Self.txtNumero1);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Include(Self.Closing, Self.TWinForm_Closing);
  Include(Self.Load, Self.TWinForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
Var
  N1, N2: Int32;
  Resultado: Double;
  Descricao: String;
begin
  try
    N1 := Int32.Parse(txtNumero1.Text);
    N2 := Int32.Parse(txtNumero2.Text);
    Resultado := N1 / N2;
    lblResultado.Text := TObject(Resultado).ToString
  except
    on E:Exception do
    begin
      Descricao := 'Um erro da classe ' + e.ClassName +
      ' foi gerado na aplicao com a seguinte mensagem: ' +
      e.Message;

      WEvent.WriteEntry(LogSource, Descricao, EventLogEntryType.Error, 2, 2);

      MessageBox.Show('No foi possivel completar a operao' +
                      #13 + 'Verifique o log de eventos para mais informaes.');
    end;
  end;
end;

procedure TWinForm.TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  WEvent.WriteEntry(LogSource, 'Aplicao encerrada.', EventLogEntryType.Information, 1, 1);
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  if not EventLog.SourceExists(LogSource, Computador) then
  begin
    EventLog.CreateEventSource(LogSource, LogName, Computador);
  end;
  WEvent := EventLog.Create;
  WEvent.WriteEntry(LogSource, 'Aplicao iniciada.', EventLogEntryType.Information, 1, 1);
end;

end.

