unit UCLIENTES;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Tabnotbk, Mask, StdCtrls, Buttons, ExtCtrls,db, UObjCLIENTES,
  jpeg;

type
  TFCLIENTES = class(TForm)
    Guia: TTabbedNotebook;
    Btnovo: TBitBtn;
    btpesquisar: TBitBtn;
    btrelatorios: TBitBtn;
    btalterar: TBitBtn;
    btgravar: TBitBtn;
    btexcluir: TBitBtn;
    btsair: TBitBtn;
    btcancelar: TBitBtn;
    LbCodigo: TLabel;
    EdtCodigo: TEdit;
    LbNome: TLabel;
    EdtNome: TEdit;
    LbDataNascimento: TLabel;
    EdtDataNascimento: TMaskEdit;
    LbHoraNascimento: TLabel;
    EdtHoraNascimento: TMaskEdit;     
    LbLimiteCompra: TLabel;
    EdtLimiteCompra: TEdit;
//DECLARA COMPONENTES

    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure BtnovoClick(Sender: TObject);
    procedure btalterarClick(Sender: TObject);
    procedure btgravarClick(Sender: TObject);
    procedure btexcluirClick(Sender: TObject);
    procedure btcancelarClick(Sender: TObject);
    procedure btsairClick(Sender: TObject);
    procedure btpesquisarClick(Sender: TObject);
  private
         Function  ControlesParaObjeto:Boolean;
         Function  ObjetoParaControles:Boolean;
         Function  TabelaParaControles:Boolean;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FCLIENTES: TFCLIENTES;
  ObjCLIENTES:TObjCLIENTES;

implementation

uses Uessencial, Upesquisa;



{$R *.DFM}
//****************************************
//*************MANIPULACAO DO OBJETO******
//****************************************
function TFCLIENTES.ControlesParaObjeto: Boolean;
Begin
  Try
    With ObjCLIENTES do
    Begin
        Submit_Codigo(edtCodigo.text);
        Submit_Nome(edtNome.text);
        Submit_DataNascimento(edtDataNascimento.text);
        Submit_HoraNascimento(edtHoraNascimento.text);
        Submit_LimiteCompra(edtLimiteCompra.text);
//CODIFICA SUBMITS
    

         result:=true;
    End;
  Except
        result:=False;
  End;
End;

function TFCLIENTES.ObjetoParaControles: Boolean;
Begin
  Try
     With ObjCLIENTES do
     Begin
        EdtCodigo.text:=Get_Codigo;
        EdtNome.text:=Get_Nome;
        EdtDataNascimento.text:=Get_DataNascimento;
        EdtHoraNascimento.text:=Get_HoraNascimento;
        EdtLimiteCompra.text:=Get_LimiteCompra;
//CODIFICA GETS

      
        result:=True;
     End;
  Except
        Result:=False;
  End;
End;

function TFCLIENTES.TabelaParaControles: Boolean;
begin
     If (ObjCLIENTES.TabelaparaObjeto=False)
     Then Begin
                result:=False;
                exit;
          End;
     If (ObjetoParaControles=False)
     Then Begin
                result:=False;
                exit;
          End;
     Result:=True;
end;



//****************************************
procedure TFCLIENTES.FormActivate(Sender: TObject);
begin
     limpaedit(Self);
     desabilita_campos(Self);
     Guia.PageIndex:=0;

     Try
        ObjCLIENTES:=TObjCLIENTES.create;
     Except
           Messagedlg('Erro na Inicializao do Objeto !',mterror,[mbok],0);
           Self.close;
     End;
     PegaFiguraBotoes(btnovo,btalterar,btcancelar,btgravar,btpesquisar,btrelatorios,btexcluir,btsair);
end;

procedure TFCLIENTES.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     If (ObjCLIENTES=Nil)
     Then exit;

If (ObjCLIENTES.status<>dsinactive)
Then Begin
          Messagedlg('No  possvel Finalizar antes de Cancelar ou Salvar as Alteraes!',mterror,[mbok],0);
          abort;
          exit;
     End;

ObjCLIENTES.free;
end;

procedure TFCLIENTES.FormKeyPress(Sender: TObject; var Key: Char);
begin
      if key=#13
      Then Perform(Wm_NextDlgCtl,0,0);
end;



procedure TFCLIENTES.BtnovoClick(Sender: TObject);
begin
     limpaedit(Self);
     habilita_campos(Self);
     desab_botoes(Self);

     //edtcodigo.text:='0';
     edtcodigo.text:=ObjCLIENTES.Get_novocodigo;
     edtcodigo.enabled:=False;

     
     Btgravar.enabled:=True;
     BtCancelar.enabled:=True;
     btpesquisar.enabled:=True;

     ObjCLIENTES.status:=dsInsert;
     Guia.pageindex:=0;
     EdtNome.setfocus;

end;


procedure TFCLIENTES.btalterarClick(Sender: TObject);
begin
    If (ObjCLIENTES.Status=dsinactive) and (EdtCodigo.text<>'')
    Then Begin
                habilita_campos(Self);
                EdtCodigo.enabled:=False;
                ObjCLIENTES.Status:=dsEdit;
                guia.pageindex:=0;
                edtnome.setfocus;
                desab_botoes(Self);
                Btgravar.enabled:=True;
                BtCancelar.enabled:=True;
                btpesquisar.enabled:=True;
          End;


end;

procedure TFCLIENTES.btgravarClick(Sender: TObject);
begin

     If ObjCLIENTES.Status=dsInactive
     Then exit;

     If ControlesParaObjeto=False
     Then Begin
               Messagedlg('Erro na tentativa de Transferir os Dados dos Edits para o Objeto!',mterror,[mbok],0);
               exit;
          End;

     If (ObjCLIENTES.salvar(true)=False)
     Then exit;

     habilita_botoes(Self);
     limpaedit(Self);
     desabilita_campos(Self);
     Messagedlg('Os Dados foram Salvos com Sucesso!',mtinformation,[mbok],0);

end;

procedure TFCLIENTES.btexcluirClick(Sender: TObject);
begin
     If (ObjCLIENTES.status<>dsinactive) or (Edtcodigo.text='')
     Then exit;

     If (ObjCLIENTES.LocalizaCodigo(edtcodigo.text)=False)
     Then Begin
               Messagedlg('Registro no localizado para ser excludo!',mterror,[mbok],0);
               exit;
          End;

     If (Messagedlg('Certeza que deseja Excluir?',mtconfirmation,[mbyes,mbno],0)=Mrno)
     Then exit;     
     
     If (ObjCLIENTES.exclui(edtcodigo.text,true)=False)
     Then Begin
               Messagedlg('Erro Durante a Excluso!!'+#13+'Possveis Causas: Registro bloqueado por outro usurio!',mterror,[mbok],0);
               exit;
          End;
     limpaedit(Self);
     Messagedlg('Excluso Concluda com Sucesso!',mtinformation,[mbok],0);


end;

procedure TFCLIENTES.btcancelarClick(Sender: TObject);
begin
     ObjCLIENTES.status:=dsInactive;
     limpaedit(Self);
     desabilita_campos(Self);
     habilita_botoes(Self);

end;

procedure TFCLIENTES.btsairClick(Sender: TObject);
begin
    Close;
end;

procedure TFCLIENTES.btpesquisarClick(Sender: TObject);
var
   FpesquisaLocal:TFpesquisa;
begin

        Try
           Fpesquisalocal:=Tfpesquisa.create(Self);

            If (FpesquisaLocal.PreparaPesquisa(ObjCLIENTES.Get_pesquisa,ObjCLIENTES.Get_TituloPesquisa,Nil)=True)
            Then Begin
                      Try
                        If (FpesquisaLocal.showmodal=mrok)
                        Then Begin
                                  If ObjCLIENTES.status<>dsinactive
                                  then exit;

                                  If (ObjCLIENTES.LocalizaCodigo(FpesquisaLocal.QueryPesq.fieldbyname('codigo').asstring)=False)
                                  Then Begin
                                            Messagedlg('Dados no encontrados!',mterror,[mbok],0);
                                            exit;
                                       End;
                                  ObjCLIENTES.ZERARTABELA;
                                  If (TabelaParaControles=False)
                                  Then Begin
                                            Messagedlg('Erro na Transferncia dos Dados!',mterror,[mbok],0);
                                            limpaedit(Self);
                                            exit;
                                       End; 

                             End;
                      Finally
                        FpesquisaLocal.QueryPesq.close;
                      End;
                 End;

        Finally
           FreeandNil(FPesquisaLocal);
        End;


end;


end.
{var
   FpesquisaLocal:Tfpesquisa;
begin

     If (key <>vk_f9)
     Then exit;

     Try
            Fpesquisalocal:=Tfpesquisa.create(Self);
            If (FpesquisaLocal.PreparaPesquisa(ObjCLIENTES.OBJETO.Get_Pesquisa,ObjCLIENTES.OBJETO.Get_TituloPesquisa,NOMEDOFORM_OU_NIL)=True)
            Then Begin
                      Try
                        If (FpesquisaLocal.showmodal=mrok)
                        Then Begin
                                 TEdit(Sender).text:=FpesquisaLocal.QueryPesq.fieldbyname(OBJCLIENTES.objeto.RETORNACAMPOCODIGO).asstring;
                                 If TEdit(Sender).text<>''
                                 Then Begin
                                        If OBJCLIENTES.objeto.RETORNACAMPONOME<>''
                                        Then Self.Lb.caption:=FpesquisaLocal.QueryPesq.fieldbyname(OBJCLIENTES.objeto.RETORNACAMPONOME).asstring
                                        Else Self.Lb.caption:='';
                                 End;
                             End;
                      Finally
                             FpesquisaLocal.QueryPesq.close;
                      End;
                  End;

     Finally
           FreeandNil(FPesquisaLocal);
     End;
end;




}
