unit UObjCLIENTES;
Interface
Uses windows,stdctrls,Classes,Db,Uessencial,Ibcustomdataset,IBStoredProc;

Type
   TObjCLIENTES=class

          Public
                Status                                      :TDataSetState;

                Constructor Create;
                Destructor  Free;
                Function    Salvar(ComCommit:Boolean)       :Boolean;
                Function    LocalizaCodigo(Parametro:Str09) :boolean;
                Function    Exclui(Pcodigo:str09;ComCommit:boolean)            :Boolean;
                Function    Get_Pesquisa                    :TStringList;
                Function    Get_TituloPesquisa              :Str100;

                Function    TabelaparaObjeto:Boolean;
                Procedure   ZerarTabela;
                Procedure   Commit;
                procedure   RollBack;

                Function    Get_NovoCodigo:Str09;

                Procedure   Submit_Codigo(parametro: STR09);
                Function    Get_Codigo: STR09;
                Procedure   Submit_Nome(parametro: STR50);
                Function    Get_Nome: STR50;
                Procedure   Submit_DataNascimento(parametro: STR10);
                Function    Get_DataNascimento: STR10;
                Procedure   Submit_HoraNascimento(parametro: STR05);
                Function    Get_HoraNascimento: STR05;
                Procedure   Submit_LimiteCompra(parametro: STR09);
                Function    Get_LimiteCompra: STR09;

         Private
               ObjDataset       :Tibdataset;
               ParametroPesquisa:TStringList;
               
               Codigo           :STR09;
               Nome             :STR50;
               DataNascimento   :STR10;
               HoraNascimento   :STR05;
               LimiteCompra     :STR09;

               Function  VerificaBrancos:Boolean;
               Function  VerificaRelacionamentos:Boolean;
               Function  VerificaNumericos:Boolean;
               Function  VerificaData:Boolean;
               Function  VerificaFaixa:boolean;
               Procedure ObjetoparaTabela;
   End;

implementation
uses SysUtils,Dialogs,UDatamodulo,Ibquery,Controls;

Function  TObjCLIENTES.TabelaparaObjeto:Boolean;
//procedimento que transfere os dados do DATASET para o Objeto
begin
     With ObjDataset do
     Begin
        Self.ZerarTabela;
        Self.Codigo:=fieldbyname('Codigo').asstring;
        Self.Nome:=fieldbyname('Nome').asstring;
        Self.DataNascimento:=fieldbyname('DataNascimento').asstring;
        Self.HoraNascimento:=fieldbyname('HoraNascimento').asstring;
        Self.LimiteCompra:=fieldbyname('LimiteCompra').asstring;
        result:=True;
     End;
end;


Procedure TObjCLIENTES.ObjetoparaTabela;
//procedimento que transfere os dados do Objeto
//para a Tabela para ser salvo pelo BD atravs do DATASET
begin
  With ObjDataset do
  Begin
        fieldbyname('Codigo').asstring:=Self.Codigo;
        fieldbyname('Nome').asstring:=Self.Nome;
        fieldbyname('DataNascimento').asstring:=Self.DataNascimento;
        fieldbyname('HoraNascimento').asstring:=Self.HoraNascimento;
        fieldbyname('LimiteCompra').asstring:=Self.LimiteCompra;
  End;
End;

//***********************************************************************

function TObjCLIENTES.Salvar(ComCommit:Boolean): Boolean;
//procedimento para salvar os dados do objeto na tabela
//se  insercao ou edicao depende da variavel STATUS
// testado todas as inconsistencias antes de SALVAR
begin

  if (Self.VerificaBrancos=False)
  Then Begin
           result:=false;
           Exit;
       End;

  if (Self.VerificaNumericos=False)
  Then Begin
           result:=false;
           Exit;
       End;

  if (Self.VerificaData=False)
  Then Begin
           result:=false;
           Exit;
       End;

  if (Self.VerificaFaixa=False)
  Then Begin
           result:=false;
           Exit;
       End;

  if (Self.VerificaRelacionamentos=False)
  Then Begin
           result:=false;
           Exit;
       End;


   If Self.LocalizaCodigo(Self.CODIGO)=False
   Then Begin
             if(Self.Status=dsedit)
             Then Begin
                       Messagedlg('O registro no foi encontrado para Edio!',mterror,[mbok],0);
                       result:=False;
                       exit;
                  End;
        End
   Else Begin
             if(Self.Status=dsinsert)
             Then Begin
                       Messagedlg('J existe um registro com estes dados!',mterror,[mbok],0);
                       result:=False;
                       exit;
                  End;
        End;


 if (Self.status=dsinsert)
 then Self.ObjDataset.Insert//libera para insercao
 Else
     if (Self.Status=dsedit)
     Then Self.ObjDataset.edit//se for edicao libera para tal
     Else Begin
               Messagedlg('A Varivel STATUS no est em um modo vlido (INSERO/EDIO)',mterror,[mbok],0);
               result:=False;
               exit; 
     End;


 Self.ObjetoParaTabela;
 Self.ObjDataset.Post;

 If ComCommit=True
 Then FDataModulo.IBTransaction.CommitRetaining;

 Self.status          :=dsInactive;
 result:=True;

end;

procedure TObjCLIENTES.ZerarTabela;
//limpa os campos do objeto sejam eles
//outros objetos ou no
//usado para deixar o objeto pronto
//para receber outros dados
Begin
     With Self do
     Begin
        Codigo:='';
        Nome:='';
        DataNascimento:='';
        HoraNascimento:='';
        LimiteCompra:='';
     End;
end;

Function TObjCLIENTES.VerificaBrancos:boolean;
//procedimento usado para verificar antes de salvar
//se tem algum campo que no poderia estar em branco
var
   Mensagem:string;
begin
  mensagem:='';

  With Self do
  Begin
      If (Codigo='')
      Then Mensagem:=mensagem+'/Codigo';
  End;

  if mensagem<>''
  Then Begin//mostra mensagem de erro caso existam campos requeridos em branco
            messagedlg('Os Seguintes Campos no podem estar vazios: '+mensagem,mterror,[mbok],0);
            result:=False;
            exit;
       End;
   result:=True;
end;

function TObjCLIENTES.VerificaRelacionamentos: Boolean;
//usado apenas por chaves estrangeiras
//ou seja, um campo chave estrangeira
//tem que ser NULL (depende da situacao)
//ou conter um valor valido que indique
//a chave primria de outra tabela, neste procedimento
// localizado este dado na outra tabela
var
mensagem:string;
Begin
     mensagem:='';
     {exemplo de como usar este procedimento, o CHAVEESTRANGEIRA ser trocado
     pelo atributo que represente uma chave estrangeira, este atributo ser um instncia
     da classe que ele representa
     if (Self.CHAVEESTRANGEIRA.Get_Codigo<>'')
     Then Begin
             if (Self.CHAVEESTRANGEIRA.localizacodigo(Self.CHAVEESTRANGEIRA.Get_Codigo)=False)
             Then mensagem:=Mensagem+'\O valor '+Self.CHAVEESTRANGEIRA.Get_Codigo+' no foi encontrado no cadastro de NOMECADASTRO';
     End;
     }

     If (mensagem<>'')
     Then Begin
               Messagedlg('Os Seguintes erros foram encontrados:'+#13+Mensagem,mterror,[mbok],0);
               result:=False;
               exit;
          End;
     result:=true;
End;

function TObjCLIENTES.VerificaNumericos: Boolean;
//procedimento usado para verificar
//se tem algum campo numerico com valor invalido
//ou seja em ALGUMAS situacoes campos numericos
//podem ser NULOS porem em outras somente
//valores numericos COMO o (0) por exemplo
//testo passando de string para o tipo dele
//ou inteiro ou real
var
   Mensagem:string;
begin
     Mensagem:='';
     try
        Strtoint(Self.Codigo);
     Except
           Mensagem:=mensagem+'/Codigo';
     End;
     try
        Strtofloat(Self.LimiteCompra);
     Except
           Mensagem:=mensagem+'/LimiteCompra';
     End;

     If Mensagem<>''
     Then Begin
               Messagedlg('Os seguintes campos contm valores invlidos: '+mensagem,mterror,[mbok],0);
               result:=false;;
               exit;
          End;
     result:=true;

end;

function TObjCLIENTES.VerificaData: Boolean;
//campo usado para verificar se te alguma data em branco
//que no deveria estar
//mesmo caso do numerico, em ALGUNS casos elas podem ser nulas
//em outros no
var
Mensagem:string;
begin
     mensagem:='';
     try
        Strtodate(Self.DataNascimento);
     Except
           Mensagem:=mensagem+'/Data de Nascimento';
     End;
     try
        Strtotime(Self.HoraNascimento);
     Except
           Mensagem:=mensagem+'/Hora de Nascimento';
     End;

     If Mensagem<>''
     Then Begin
           Messagedlg('Os Seguintes campos contm Datas ou Horas invlidas:'+Mensagem,mterror,[mbok],0);
           result:=false;
           exit;
     End;
     result:=true;

end;

function TObjCLIENTES.VerificaFaixa: boolean;
//USADO EM CASOS DE CAMPOS QUE TENHAM UMA FAIXA DE VALORES
//COMO POR EXEMPLO de 1 a 10, ou "S" ou "N" ,
//ou "M" ou "F"
var
   Mensagem:string;
begin

     Mensagem:='';

     {if (Self.Sexo<>'M') and (Self.Sexo<>'F')
     Then Mensagem:='O Campo Sexo est com o valor invlido';}
     If mensagem<>''
     Then Begin
               Messagedlg('Os seguintes Erros foram encontrados!'+#13+mensagem,mterror,[mbok],0);
               result:=false;
               exit;
          End;

     result:=true;

end;

function TObjCLIENTES.LocalizaCodigo(parametro: Str09): boolean;
//usado para localizar dados pela chave primaria (CODIGO)
//aqui vaum todos os campos que se deseja recuperar
//usado tmbm no salvar para verificar se os dados ja existem
//ou no
begin
       With Self.ObjDataset do
       Begin
           close;
           SelectSql.Clear;
           SelectSQL.ADD('Select Codigo,Nome,DataNascimento,HoraNascimento,LimiteCompra');
           SelectSQL.ADD(' from  TABCLIENTES');
           SelectSQL.ADD(' WHERE codigo='+parametro);

           Open;
           If (recordcount>0)
           Then Result:=True
           Else Result:=False;
       End;
end;


function TObjCLIENTES.Exclui(Pcodigo: str09;ComCommit:Boolean): Boolean;
//Localiza o registro e tenta exclusao
//o parametro COMCOMMIT indica se os dados
//poderao ser confirmados (COMMIT) ou no
begin
     Try
        result:=true;
        If (Self.LocalizaCodigo(Pcodigo)=True)
        Then Begin
                 Self.ObjDataset.delete;
                 If (ComCommit=True)
                 Then FDataModulo.IBTransaction.CommitRetaining;
             End

        Else result:=false;
     Except
           result:=false;
     End;
end;


constructor TObjCLIENTES.create;
//procedimento que cria a instancia do objeto
//e os seus objetos internos
//alem de preencher as SQLS do DATASET
begin


        Self.ObjDataset:=Tibdataset.create(nil);
        Self.ObjDataset.Database:=FDataModulo.IbDatabase;
        Self.ParametroPesquisa:=TStringList.create;
        Self.ZerarTabela;

        With Self.ObjDataset do
        Begin

                SelectSQL.clear;
                SelectSQL.ADD('Select Codigo,Nome,DataNascimento,HoraNascimento,LimiteCompra');
                SelectSQL.ADD(' from  TABCLIENTES');
                SelectSQL.ADD(' WHERE codigo=0');

                InsertSQL.clear;
                InsertSQL.add('Insert Into TABCLIENTES(Codigo,Nome,DataNascimento,HoraNascimento');
                InsertSQL.add(' ,LimiteCompra)');
                InsertSQL.add('values (:Codigo,:Nome,:DataNascimento,:HoraNascimento');
                InsertSQL.add(' ,:LimiteCompra)');

                ModifySQL.clear;
                ModifySQL.add('Update TABCLIENTES set Codigo=:Codigo,Nome=:Nome,DataNascimento=:DataNascimento');
                ModifySQL.add(',HoraNascimento=:HoraNascimento,LimiteCompra=:LimiteCompra');
                ModifySQL.add('where codigo=:codigo');

                DeleteSQL.clear;
                DeleteSql.add('Delete from TABCLIENTES where codigo=:codigo ');

                RefreshSQL.clear;
                RefreshSQL.ADD('Select Codigo,Nome,DataNascimento,HoraNascimento,LimiteCompra');
                RefreshSQL.ADD(' from  TABCLIENTES');
                RefreshSQL.ADD(' WHERE codigo=0');

                open;
                Self.ObjDataset.First ;
                Self.status          :=dsInactive;
        End;
end;

procedure TObjCLIENTES.Commit;
begin
     FDataModulo.IBTransaction.CommitRetaining;
end;

procedure TObjCLIENTES.RollBack;
begin
     FDataModulo.IBTransaction.RollbackRetaining;
end;

function TObjCLIENTES.Get_Pesquisa: TStringList;
begin
     Self.ParametroPesquisa.clear;
     Self.ParametroPesquisa.add('Select * from TabCLIENTES');
     Result:=Self.ParametroPesquisa;
end;

function TObjCLIENTES.Get_TituloPesquisa: Str100;
begin
     Result:=' Pesquisa de CLIENTES ';
end;

function TObjCLIENTES.Get_NovoCodigo: Str09;
var
StrTemp:TIBStoredProc;
begin
     Try
        Try
           StrTemp:=TIBStoredProc.create(nil);
           StrTemp.database:=ObjDataset.Database;
           StrTemp.StoredProcName:='PROCGERACODIGOCLIENTES';

           StrTemp.ExecProc;
           Result:=StrTemp.ParamByname('CODIGO').ASSTRING;
        Except
           Messagedlg('Erro durante a Criao de Um novo Cdigo para o CLIENTES',mterror,[mbok],0);
           result:='0';
           exit;
        End;
     Finally
            FreeandNil(StrTemp);
     End;
end;


destructor TObjCLIENTES.Free;
begin
     Freeandnil(Self.ObjDataset);
     Freeandnil(Self.ParametroPesquisa);
end;

procedure TObjClientes.Submit_Codigo(parametro: STR09);
begin
     Self.Codigo:=Parametro;
end;
function TObjClientes.Get_Codigo: STR09;
begin
     Result:=Self.Codigo;
end;
procedure TObjClientes.Submit_Nome(parametro: STR50);
begin
     Self.Nome:=Parametro;
end;
function TObjClientes.Get_Nome: STR50;
begin
     Result:=Self.Nome;
end;
procedure TObjClientes.Submit_DataNascimento(parametro: STR10);
begin
     Self.DataNascimento:=Parametro;
end;
function TObjClientes.Get_DataNascimento: STR10;
begin
     Result:=Self.DataNascimento;
end;
procedure TObjClientes.Submit_HoraNascimento(parametro: STR05);
begin
     Self.HoraNascimento:=Parametro;
end;
function TObjClientes.Get_HoraNascimento: STR05;
begin
     Result:=Self.HoraNascimento;
end;
procedure TObjClientes.Submit_LimiteCompra(parametro: STR09);
begin
     Self.LimiteCompra:=Parametro;
end;
function TObjClientes.Get_LimiteCompra: STR09;
begin
     Result:=Self.LimiteCompra;
end;

end.


