unit Useg;
interface
uses controls;

Function Trava: boolean;
Function VerificaSenhaAtivacao(senha:String):Boolean;
Function EncriptaDecripta(original:string):string;
Function EncriptaDecriptaSenha(original:string):string;
Function TrocaLetra(Original:string):string;



implementation

Uses Sysutils,forms,dialogs,Variants;

const  BancoConst='DbAcess.txt';
const  VerDataConst='Images.txt';



Function TrocaLetra(Original:string):string;
var
cont:integer;
palavra:string;
Begin
     palavra:=''; 
 palavra:=original; 
 
 for cont:=1 to length(palavra) do 
 Begin 
        case palavra[cont] of

        '1': palavra[cont]:='5';
        '5': palavra[cont]:='1';

        '2': palavra[cont]:='3';
        '3': palavra[cont]:='2';

        '4': palavra[cont]:='6';
        '6': palavra[cont]:='4';

        '7': palavra[cont]:='9';
        '9': palavra[cont]:='7';
        'a': palavra[cont]:='Z';
        'Z': palavra[cont]:='a';
        'e': palavra[cont]:='X';
        'X': palavra[cont]:='e';
        'i': palavra[cont]:='R';
        'R': palavra[cont]:='i';
        'o': palavra[cont]:='K';
        'K': palavra[cont]:='o';
        'u': palavra[cont]:='H';
        'H': palavra[cont]:='u';
        End;

 End;
 result:=palavra;

End;

Function EncriptaDecriptaSenha(original:string):string;
var
final:string;
cont:integer;
palavra:string;
begin
     palavra:='';
     palavra:=trocaletra(original);

     final:='';
     for cont:=1 to length(palavra) do
     begin
	final:=final+chr(256-ord(copy(palavra,cont,1)[1]));
     end;
     result:=final;

end;

Function EncriptaDecripta(original:string):string;
var
final:string;
cont:integer;
palavra:string;
begin
     palavra:='';
     palavra:=original;


     final:='';
     for cont:=1 to length(palavra) do
     begin
	final:=final+chr(256-ord(copy(palavra,cont,1)[1]));
     end;
     result:=final;

end;


Function Verifica_Ultimo_acesso:Boolean;
type
arquivo=string[50];
var
arq:file of arquivo;
path:string;
Ultimo_valor:arquivo;
Begin

     path:='';
     path:=ExtractFilePath(application.exename);

     if (path[length(path)]<>'\')
     Then path:=path+'\';

     path:=path+BancoConst;//pego o arquivo DbAcess

     Try
       assignfile(arq,path);
       reset(arq);
     Except
           Messagedlg('Arquivo no encontrado para abertura e verificao "'+path+'"',mterror,[mbok],0);
           result:=False;
           exit;

     End;

     Try
       seek(arq,(filesize(arq)-1));
       read(arq,ultimo_valor);//abro e leio o ultimo valor gravado

       //aqui vai a desenc.
       ultimo_valor:=EncriptaDecripta(ultimo_valor);

       //********************************

       if ((Date+time)<=strtodatetime(Ultimo_valor))//verifico se  menor a ultima data
       Then result:=false
       else result:=true;

     Except
           Messagedlg('Erro durante a verificao da Data no arquivo "'+path+'"',mterror,[mbok],0);
           result:=False;
           exit;
     End;
     
End;

Function Grava_Ultimo_acesso:Boolean;
var
arq:file of string[50];
path:string;
Ultimo_valor:string[50];
Begin
     path:='';
     path:=ExtractFilePath(application.exename);
     if (path[length(path)]<>'\')
     Then path:=path+'\';
     path:=path+BancoConst;//pego o local para gravar o ultimo acesso

     Try
       assignfile(arq,path);
       reset(arq);
       seek(arq,filesize(arq));//posiciono no final
       Ultimo_valor:=Datetimetostr(Date+time);
       //aqui vai a encrip.
       ultimo_valor:=EncriptaDecripta(ultimo_valor);
       //*********************
       Write(arq,Ultimo_valor);//gravo
       closefile(arq);

     Except
           Messagedlg('Erro durante a  gravao da Hora Atual!',mterror,[mbok],0);
           result:=False;
           exit;
     End;
     result:=true;//ok
End;

Function Cria_Arquivo_Acesso:Boolean;
var
arq:file of string[50];
path:string;
Ultimo_valor:string[50];
Begin
     path:='';
     path:=ExtractFilePath(application.exename);
     if (path[length(path)]<>'\')
     Then path:=path+'\';
     path:=path+BancoConst;

     Try
       assignfile(arq,path);
       rewrite(arq);
       seek(arq,filesize(arq));
       Ultimo_valor:=Datetimetostr(Date+time);
       //aqui vai a encrip.
       ultimo_valor:=EncriptaDecripta(ultimo_valor);
       //******************
       Write(arq,Ultimo_valor);
       closefile(arq);

     Except
           Messagedlg('Erro durante a  gravao da Hora Atual!',mterror,[mbok],0);
           result:=False;
           exit;
     End;
     
     result:=true;//ok
End;
//************************************************************************
Function Cria_Arquivo_Data(DataParametro:Tdate):Boolean;
var
arq:file of string[50];
path:string;
Ultimo_valor:string[50];
Begin
     path:='';
     path:=ExtractFilePath(application.exename);
     if (path[length(path)]<>'\')
     Then path:=path+'\';
     path:=path+VerDataConst;

     Try
       assignfile(arq,path);
       rewrite(arq);
       seek(arq,filesize(arq));

       Ultimo_valor:=Datetostr(DataParametro);

       
       //aqui vai a encrip.
       ultimo_valor:=EncriptaDecripta(ultimo_valor);
       //******************
       Write(arq,Ultimo_valor);
       closefile(arq);

     Except
           Messagedlg('Erro durante a  Gravao da Data Atual!',mterror,[mbok],0);
           result:=False;
           exit;
     End;

     result:=true;//ok
End;

Function DataVencida:Boolean;
Type
Arquivo=string[50];
var
arq:file of Arquivo;
path:string;
Ultimo_valor:Arquivo;

Begin

     path:='';
     path:=ExtractFilePath(application.exename);
     if (path[length(path)]<>'\')
     Then path:=path+'\';
     path:=path+VerDataConst;

     Try
       assignfile(arq,path);
       reset(arq);
       seek(arq,(filesize(arq)-1));
       read(arq,ultimo_valor);

       //aqui vai a desenc.
       ultimo_valor:=EncriptaDecripta(ultimo_valor);

       //********************************

       if (Date>=strtodate(ultimo_valor))
       Then Result:=true
       Else result:=False;

     Except
           Messagedlg('Um Arquivo necessrio ao sistema no foi encontrado!',mterror,[mbok],0);
           result:=True;
           exit;
     End;
End;

//De acordo com a data passada de parametro gera-se uma senha
Function GeraSenha(DataAtual:String):String;
var
Cont:Integer;
Senha:String;
Data:Tdate;
ano,dia,mes:word;
anos,dias,mess:String;
vetorMeses:Array[1..12] of string;
Begin

     Result:='';

     VetorMeses[01]:='Jane';
     VetorMeses[02]:='Feve';
     VetorMeses[03]:='Mar';
     VetorMeses[04]:='Abri';
     VetorMeses[05]:='Maio';
     VetorMeses[06]:='Junh';
     VetorMeses[07]:='Julh';
     VetorMeses[08]:='Agos';
     VetorMeses[09]:='Sete';
     VetorMeses[10]:='Outu';
     VetorMeses[11]:='Nove';
     VetorMeses[12]:='Deze';
     
     Try
        data:=Strtodate(dataatual);
     except
        exit;
     End;

     DecodeDate(data,ano,mes,dia);
     anos:='';
     mess:='';
     dias:='';

     If ((ano*10)<10)
     Then anos:='0'+Inttostr(Ano*10)
     Else anos:=Inttostr(Ano*10);

     If ((mes*2)<10)
     Then mess:='0'+inttostr(mes*2)
     Else mess:=inttostr(mes*2);

     If ((dia*3)<10)
     Then dias:='0'+inttostr(dia*3)
     Else dias:=inttostr(dia*3);


     senha:='';
     Senha:=VetorMeses[mes][4]+'@'+VetorMeses[mes][2]+'%'+ANOS+'#'+VetorMeses[mes][1]+'='+DIAS+'$'+MESS;
     Senha:=senha+')'+VetorMeses[mes][3];

     Result:=Senha;

End;


Function DecodeVencimentoSenha(senha:String):String;
var
cont:Integer;
APOIO:String;
Begin
     //Retira a parte do Vencimento da senha
     //e retorna so a senha
     apoio:='';

     for cont:=length(senha) downto 1 do
     Begin
          If (Senha[cont]='?')
          Then break;
     End;

     apoio:=copy(senha,1,cont-1);
     result:=apoio;

End;

Function RecuperaProximaData(senha:String):Tdate;
var
cont:Integer;
dias,mess,anos,APOIO,apoio2:String;
dia,mes,ano:Word;
Data:Tdate;
Begin
    //retira a senha e decodifica deixando
    //apenas a proxima data

     dias:='';
     mess:='';
     anos:='';
     apoio:='';
     apoio2:='';

     for cont:=length(senha) downto 1 do
     Begin
          If (Senha[cont]='?')
          Then break;
     End;

     apoio:=copy(senha,cont+1,length(senha));

     for cont:=1 to length(apoio) do
     Begin
          if (apoio[cont]='*')
          Then Begin
                     Mess:=apoio2;
                     apoio2:='';
               End
          Else Begin
                    if (apoio[cont]='(')
                    Then Begin
                                 dias:=apoio2;
                                 apoio2:='';
                        End
                    Else apoio2:=apoio2+apoio[cont]; 
               End;
     End;
     anos:=apoio2;
     Try
        dia:=Strtoint(Floattostr(int(Strtoint(dias)/7)));
        mes:=Strtoint(Floattostr(int(Strtoint(mess)/10)));
        ano:=Strtoint(Floattostr(int(Strtoint(anos)/3)));
        Data:=EncodeDate(ano,mes,dia);
     Except
           Result:=null;
     
     End;

     
     result:=data;



End;


Function VerificaSenhaAtivacao(senha:String):Boolean;
var
Ultimo_valor:string[50];
DataAtual:Tdate;
DataArquivo:Tdate;
TSenha,TSenha2:String;
Begin
     result:=False;


     Try

        DataAtual:=Now;

       Ultimo_Valor:='';
       UlTimo_Valor:=DatetoStr(DataAtual);//o calculo  feito sobre esta data

       TSenha:='';
       TSenha2:='';
       TSenha:=GeraSenha(Ultimo_Valor);
       TSenha2:=DecodeVencimentoSenha(senha);

       If (TSenha2=TSenha)
       Then Begin
                DataArquivo:=RecuperaProximaData(senha);

                If (Cria_Arquivo_Data(DataArquivo)=False)
                Then exit;

                Result:=True;
            End
       Else Begin
                 Messagedlg('Senha Invlida!',mterror,[mbok],0);
                 exit;

            End;
     Except
           Messagedlg('Um arquivo requerido ao sistema no foi encontrado!',mterror,[mbok],0);
           exit;
     End;
End;
function Trava: boolean;
var
path:string;
//Objacessos:Tobjacessos;
begin
     {try
        ObjAcessos:=TobjAcessos.create;
     Except
           Messagedlg('No foi possvel gerar o Objeto de Acessos!',mterror,[mbok],0);
           result:=True;
           exit;
     End;}
//Try
     if Verifica_Ultimo_acesso=False
     Then Begin
               Messagedlg('A Data e a Hora do seu computador esto menores ou iguais ao ltimo Acesso! O Programa ser finalizado!',mterror,[mbok],0);
               result:=True;
               exit;
     End;

     {if Objacessos.VerificaUltimoacesso=False
     Then Begin
               Messagedlg('A Data e a Hora do seu computador esto menores ou iguais ao ltimo Acesso! O Programa ser finalizado!',mterror,[mbok],0);
               result:=True;
               exit;
     End;}

     if Grava_Ultimo_acesso=False
     Then Begin
               Messagedlg('Erro de gravao do acesso!',mterror,[mbok],0);
               result:=true;
               exit;
          End;




     if (DataVencida=True)
     Then Begin
               result:=True;//signicifa que  p/ travar
               
               //Digite a senha de ativao
               path:='';
               path:=InputBox('Senha de Ativao','Verso Vencida! Digite a senha','');

               If (VerificaSenhaAtivacao(path)=False)
               Then Exit
               Else Result:=False;
           End
     Else result:=False;
     
{Finally
       objacessos.free;
End;}
end;



end.
