  unit uPessoaPublica;

interface

uses
  System.Windows.Forms;

type
  [serializable]
  TEndereco = class
  end;

  [serializable]
  TPessoaPublica = class
  private
    FNome: string;
    FDataDeNascimento: DateTime;
    FID: integer;
    FEndereco: TEndereco;
    procedure set_DataDeNascimento(const Value: DateTime);
    procedure set_Endereco(const Value: TEndereco);
    procedure set_ID(const Value: integer);
    procedure set_Nome(const Value: string);
  public
    constructor Create; overload;
    constructor Create(ANome : string; AData : DateTime); overload;
    function Idade: integer;
    procedure Falar; virtual;
    property ID   : integer read FID write set_ID;
    property Nome : string read FNome write set_Nome;
    property DataDeNascimento : DateTime read FDataDeNascimento write set_DataDeNascimento;
    property Endereco : TEndereco read FEndereco write set_Endereco;
  end;

implementation

constructor TPessoaPublica.Create(ANome: string; AData: DateTime);
begin
  inherited Create;
  ID := 0;
  Nome := ANome;
  DataDeNascimento := AData;
end;

constructor TPessoaPublica.Create;
begin
  inherited Create;
  ID := 0;
  Nome := 'Pessoa';
  DataDeNascimento := DateTime.Today;
end;

procedure TPessoaPublica.Falar;
begin
  MessageBox.Show('Ola, sou ' + Nome + ' e tenho ' + Idade.Tostring + ' anos!');
end;

function TPessoaPublica.Idade: integer;
var
  mes, anos : integer;
begin
  anos := DateTime.Today.Year - DataDeNascimento.Year;
  mes := DateTime.Today.Month - DataDeNascimento.Month;
  if mes = 0 then
    if (DateTime.Today.Day - DataDeNascimento.Day) < 0 then
      mes := -1;
  if mes < 0 then dec(anos);
  result := anos;
end;

procedure TPessoaPublica.set_DataDeNascimento(const Value: DateTime);
begin
  FDataDeNascimento := Value;
end;

procedure TPessoaPublica.set_Endereco(const Value: TEndereco);
begin
  FEndereco := Value;
end;

procedure TPessoaPublica.set_ID(const Value: integer);
begin
  FId := Value;
end;

procedure TPessoaPublica.set_Nome(const Value: string);
begin
  FNome := Value;
end;

end.
