unit WinForm1;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Xml.Serialization, system.IO,
  uPessoaPublica;

type

  TWinForm1 = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    Label3: System.Windows.Forms.Label;
    txbID: System.Windows.Forms.TextBox;
    txbNome: System.Windows.Forms.TextBox;
    dtpData: System.Windows.Forms.DateTimePicker;
    btnSalvar: System.Windows.Forms.Button;
    btnAbrir: System.Windows.Forms.Button;
    btnLimpar: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure btnAbrir_Click(sender: System.Object; e: System.EventArgs);
    procedure btnLimpar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    procedure SerializePessoa(Apessoa: TPessoaPublica; Arquivo: string);
    function DeSerializePessoa(Arquivo : string): TPessoaPublica;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm1))]

implementation

const
  SArquivo = 'Pessoa.xml';

{$AUTOBOX ON}


{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm1.InitializeComponent;
begin
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.txbID := System.Windows.Forms.TextBox.Create;
  Self.txbNome := System.Windows.Forms.TextBox.Create;
  Self.dtpData := System.Windows.Forms.DateTimePicker.Create;
  Self.btnSalvar := System.Windows.Forms.Button.Create;
  Self.btnAbrir := System.Windows.Forms.Button.Create;
  Self.btnLimpar := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(16, 24);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(52, 12);
  Self.Label1.TabIndex := 0;
  Self.Label1.Text := 'ID';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(16, 44);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(52, 16);
  Self.Label2.TabIndex := 1;
  Self.Label2.Text := 'Nome';
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(16, 72);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(52, 16);
  Self.Label3.TabIndex := 2;
  Self.Label3.Text := 'Data';
  // 
  // txbID
  // 
  Self.txbID.Location := System.Drawing.Point.Create(76, 20);
  Self.txbID.Name := 'txbID';
  Self.txbID.TabIndex := 3;
  Self.txbID.Text := 'TextBox1';
  // 
  // txbNome
  // 
  Self.txbNome.Location := System.Drawing.Point.Create(76, 44);
  Self.txbNome.Name := 'txbNome';
  Self.txbNome.Size := System.Drawing.Size.Create(200, 20);
  Self.txbNome.TabIndex := 4;
  Self.txbNome.Text := 'TextBox2';
  // 
  // dtpData
  // 
  Self.dtpData.Format := System.Windows.Forms.DateTimePickerFormat.Short;
  Self.dtpData.Location := System.Drawing.Point.Create(76, 68);
  Self.dtpData.Name := 'dtpData';
  Self.dtpData.Size := System.Drawing.Size.Create(148, 20);
  Self.dtpData.TabIndex := 5;
  // 
  // btnSalvar
  // 
  Self.btnSalvar.Location := System.Drawing.Point.Create(100, 108);
  Self.btnSalvar.Name := 'btnSalvar';
  Self.btnSalvar.TabIndex := 6;
  Self.btnSalvar.Text := 'Salvar';
  Include(Self.btnSalvar.Click, Self.Button1_Click);
  // 
  // btnAbrir
  // 
  Self.btnAbrir.Location := System.Drawing.Point.Create(184, 108);
  Self.btnAbrir.Name := 'btnAbrir';
  Self.btnAbrir.TabIndex := 7;
  Self.btnAbrir.Text := 'Abrir';
  Include(Self.btnAbrir.Click, Self.btnAbrir_Click);
  // 
  // btnLimpar
  // 
  Self.btnLimpar.Location := System.Drawing.Point.Create(16, 108);
  Self.btnLimpar.Name := 'btnLimpar';
  Self.btnLimpar.TabIndex := 8;
  Self.btnLimpar.Text := 'Limpar';
  Include(Self.btnLimpar.Click, Self.btnLimpar_Click);
  // 
  // TWinForm1
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(296, 145);
  Self.Controls.Add(Self.btnLimpar);
  Self.Controls.Add(Self.btnAbrir);
  Self.Controls.Add(Self.btnSalvar);
  Self.Controls.Add(Self.dtpData);
  Self.Controls.Add(Self.txbNome);
  Self.Controls.Add(Self.txbID);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label1);
  Self.Name := 'TWinForm1';
  Self.Text := 'WinForm';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm1.SerializePessoa(Apessoa: TPessoaPublica; Arquivo: string);
var
  xmlSer : XmlSerializer;
  writer : TextWriter;
begin
  writer := StreamWriter.Create(Arquivo);
  try
    xmlSer := XmlSerializer.Create(TPessoaPublica.ClassInfo);
    xmlSer.Serialize(writer, APessoa);
  finally
    writer.Close;
  end;
end;

function TWinForm1.DeSerializePessoa(Arquivo : string): TPessoaPublica;
var
  xmlSer : XmlSerializer;
  reader : TextReader;
begin
  result := nil;
  reader := StreamReader.Create(Arquivo);
  try
    xmlSer := XmlSerializer.Create(TPessoaPublica.ClassInfo);
    result :=  XmlSer.Deserialize(reader) as TPessoaPublica;
  finally
    reader.Close;
  end;
end;

procedure TWinForm1.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm1.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm1.btnLimpar_Click(sender: System.Object; e: System.EventArgs);
begin
  txbID.Clear;
  txbNome.Clear;
  dtpData.Value := DateTime.Today;
end;

procedure TWinForm1.btnAbrir_Click(sender: System.Object; e: System.EventArgs);
var
  UmaPessoa : TPessoaPublica;
begin
  Cursor := Cursors.WaitCursor;

  UmaPessoa := DeserializePessoa(SArquivo);  // Deserialization de UmaPessoa

  txbNome.Text := UmaPessoa.Nome;
  txbID.Text := UmaPessoa.ID.ToString;
  dtpData.Value := UmaPessoa.DataDeNascimento;
  UmaPessoa.Falar;
  UmaPessoa.Free;
  Cursor := Cursors.Default;
end;

procedure TWinForm1.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  UmaPessoa : TPessoaPublica;
begin
  Cursor := Cursors.WaitCursor;
  UmaPessoa := TPessoaPublica.Create(txbNome.Text, dtpData.Value);
  UmaPessoa.ID := Int32.Parse(txbID.Text);

  SerializePessoa(UmaPessoa, SArquivo); //Serialization de UmaPessoa

  UmaPessoa.Free;
  txbNome.Clear;
  txbID.Clear;
  dtpData.Value := DateTime.Today;
  Cursor := Cursors.Default;
end;
end.
