unit uPessoaPublica;

interface

uses
  System.Windows.Forms;

type
[Serializable]  
TPessoaPublica = class
  public
    ID : integer;
    Nome : string;
    DataDeNascimento : DateTime;
    constructor Create; overload;
    constructor Create(ANome : string; AData : DateTime); overload;
    function Idade: integer;
    procedure Falar; virtual;
end;

implementation

constructor TPessoaPublica.Create(ANome: string; AData: DateTime);
begin
  inherited Create;
  ID := 0;
  Nome := ANome;
  DataDeNascimento := AData;
end;

constructor TPessoaPublica.Create;
begin
  inherited Create;
  ID := 0;
  Nome := 'Pessoa';
  DataDeNascimento := DateTime.Today;
end;

procedure TPessoaPublica.Falar;
begin
  MessageBox.Show('Ola, sou ' + Nome + ' e tenho ' + Idade.Tostring + ' anos!');
end;

function TPessoaPublica.Idade: integer;
var
  mes, anos : integer;
begin
  anos := DateTime.Today.Year - DataDeNascimento.Year;
  mes := DateTime.Today.Month - DataDeNascimento.Month;
  if mes = 0 then
    if (DateTime.Today.Day - DataDeNascimento.Day) < 0 then
      mes := -1;
  if mes < 0 then dec(anos);
  result := anos;
end;

end.
