unit untAssistente;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, DBXpress, DB, SqlExpr, ComCtrls, FMTBcd,
  ExtCtrls, Buttons, Provider, DBClient;

type
  TfrmAssistente = class(TForm)
    Panel1: TPanel;
    trvCampos: TTreeView;
    Splitter1: TSplitter;
    Panel2: TPanel;
    Panel3: TPanel;
    mmoSelect: TMemo;
    Splitter2: TSplitter;
    pcDef: TPageControl;
    tsCampos: TTabSheet;
    tsCondicoes: TTabSheet;
    tsOrdem: TTabSheet;
    tsJoins: TTabSheet;
    cmbFormato: TComboBox;
    grdCampos: TStringGrid;
    Label1: TLabel;
    edtRotulo: TEdit;
    Label2: TLabel;
    btnAdCampos: TSpeedButton;
    btnReCampos: TSpeedButton;
    grdCondicoes: TStringGrid;
    btnReCond: TSpeedButton;
    btnAdCond: TSpeedButton;
    edtValorInicial: TEdit;
    cmbCondicoes: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    grdOrdem: TStringGrid;
    btnReOrdem: TSpeedButton;
    btnAdOrdem: TSpeedButton;
    cmbOrdem: TComboBox;
    Label6: TLabel;
    grdLigacoes: TStringGrid;
    btnReLig: TSpeedButton;
    btnAdLig: TSpeedButton;
    edtValorFinal: TEdit;
    Label9: TLabel;
    rdgTipo: TRadioGroup;
    Panel4: TPanel;
    btnGerarSelect: TSpeedButton;
    btnCopiar: TSpeedButton;
    btnSair: TSpeedButton;
    btnSalvar: TSpeedButton;
    sdSalvar: TSaveDialog;
    odAbrir: TOpenDialog;
    btnAbrir: TSpeedButton;
    btnExecutar: TSpeedButton;
    btnConecxao: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure trvCamposClick(Sender: TObject);
    procedure btnAdCamposClick(Sender: TObject);
    procedure btnReCamposClick(Sender: TObject);
    procedure btnReCondClick(Sender: TObject);
    procedure btnAdCondClick(Sender: TObject);
    procedure cmbCondicoesChange(Sender: TObject);
    procedure btnReOrdemClick(Sender: TObject);
    procedure btnAdOrdemClick(Sender: TObject);
    procedure btnReLigClick(Sender: TObject);
    procedure btnAdLigClick(Sender: TObject);
    procedure btnSairClick(Sender: TObject);
    procedure pcDefChange(Sender: TObject);
    procedure btnGerarSelectClick(Sender: TObject);
    procedure btnCopiarClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnAbrirClick(Sender: TObject);
    procedure btnConecxaoClick(Sender: TObject);
    procedure btnExecutarClick(Sender: TObject);
  private
    { Private declarations }
    lFrom: TStringList;
    procedure RemoveLinha(Grade: TStringGrid; Linha: Integer);
    procedure MonteTabelas(Tabela: String);
    procedure VerificaTabelas();
    function RecTabela(Texto: String): String;
  public
    { Public declarations }
  end;

var
  frmAssistente: TfrmAssistente;

implementation

uses untConexao, untDM, untGrade;

{$R *.dfm}

procedure TfrmAssistente.FormCreate(Sender: TObject);
begin
    With grdCampos Do
    Begin
      Cells[0, 0] := 'Tabela.Campo';
      Cells[1, 0] := 'Formato';
      Cells[2, 0] := 'Rtulo';
    End;

    With grdCondicoes Do
    Begin
      Cells[0, 0] := 'Tabela.Campo';
      Cells[1, 0] := 'Condio';
      Cells[2, 0] := 'Valor Inicial';
      Cells[3, 0] := 'Valor Final';
    End;

    With grdOrdem Do
    Begin
      Cells[0, 0] := 'Tabela.Campo';
      Cells[1, 0] := 'Ordem';
    End;

    With grdLigacoes Do
    Begin
      Cells[0, 0] := 'Tabela.Campo 1';
      Cells[1, 0] := 'Tabela.Campo 2';
    End;
end;

procedure TfrmAssistente.trvCamposClick(Sender: TObject);
begin
  If Not trvCampos.Selected.HasChildren Then
  Begin
    edtRotulo.Text := trvCampos.Selected.Text;
  End;
  btnAdCampos.Enabled := Not trvCampos.Selected.HasChildren;
  btnReCampos.Enabled := Not trvCampos.Selected.HasChildren;

  btnAdCond.Enabled := Not trvCampos.Selected.HasChildren;
  btnReCond.Enabled := Not trvCampos.Selected.HasChildren;

  btnAdOrdem.Enabled := Not trvCampos.Selected.HasChildren;
  btnReOrdem.Enabled := Not trvCampos.Selected.HasChildren;

  btnAdLig.Enabled := Not trvCampos.Selected.HasChildren;
  btnReLig.Enabled := Not trvCampos.Selected.HasChildren;
end;

procedure TfrmAssistente.btnAdCamposClick(Sender: TObject);
const aFormato : Array[0..4] of String = ('','SUM','AVG','MIN','MAX');
begin
  With grdCampos Do
  Begin
    If Cells[0,1] <> '' Then
      RowCount := RowCount + 1;
    Cells[0, RowCount - 1] := trvCampos.Selected.Text;
    Cells[1, RowCount - 1] := aFormato[cmbFormato.ItemIndex];
    Cells[2, RowCount - 1] := edtRotulo.Text;
  End;
end;

procedure TfrmAssistente.btnReCamposClick(Sender: TObject);
begin
  RemoveLinha(grdCampos, grdCampos.row);
end;

procedure TfrmAssistente.RemoveLinha(Grade: TStringGrid; Linha: Integer);
var
  i, j: Integer;
begin
  With Grade Do
  Begin
    For i := Linha To RowCount - 1 Do
      For j := 0 To ColCount - 1 Do
      Begin
        If RowCount > 2 Then
          Cells[j, i] := Cells[j, i + 1]
        Else
          Cells[j, i] := '';
      End;
    If RowCount > 2 Then
      RowCount := RowCount - 1
  End;
end;

procedure TfrmAssistente.btnReCondClick(Sender: TObject);
begin
  RemoveLinha(grdCondicoes, grdCondicoes.row);
end;

procedure TfrmAssistente.btnAdCondClick(Sender: TObject);
const aCondicoes : Array[0..5] of String = ('=','>','>','BETWEEN','LIKE','LIKE');
var
  Aspas, Porc1, Porc2: String;
begin
  Aspas := '';
  With grdCondicoes Do
  Begin
    If Cells[0,1] <> '' Then
      RowCount := RowCount + 1;
    Cells[0, RowCount - 1] := trvCampos.Selected.Text;
    Cells[1, RowCount - 1] := aCondicoes[cmbCondicoes.ItemIndex];
    If rdgTipo.ItemIndex = 1 Then
      Aspas := ''''
    Else
      Aspas := '';

    If cmbCondicoes.ItemIndex in [4, 5] Then
    Begin
      If cmbCondicoes.ItemIndex = 5 Then
        Porc1 := '%'
      Else
        Porc1 := '';
      Porc2 := '%';
    End
    Else
    Begin
      Porc1 := '';
      Porc2 := '';
    End;

      Cells[2, RowCount - 1] := Aspas + Porc1 + edtValorInicial.Text + Porc2 + Aspas;

    If edtValorFinal.Text <> '' Then
      Cells[3, RowCount - 1] := Aspas + edtValorFinal.Text + Aspas;
  End;

end;

procedure TfrmAssistente.cmbCondicoesChange(Sender: TObject);
begin
  If cmbCondicoes.ItemIndex In [4, 5] Then
  Begin
    rdgTipo.ItemIndex := 1;
    rdgTipo.Enabled := False;
  End
  Else
    rdgTipo.Enabled := True;

  edtValorFinal.Enabled := (cmbCondicoes.ItemIndex = 3);
  If Not edtValorFinal.Enabled Then
    edtValorFinal.Text := '';
end;

procedure TfrmAssistente.btnReOrdemClick(Sender: TObject);
begin
  RemoveLinha(grdOrdem, grdOrdem.Row);
end;

procedure TfrmAssistente.btnAdOrdemClick(Sender: TObject);
const aOrdem : Array[0..1] of String = ('ASC','DESC');
begin
  With grdOrdem Do
  Begin
    If Cells[0,1] <> '' Then
      RowCount := RowCount + 1;
    Cells[0, RowCount - 1] := trvCampos.Selected.Text;
    Cells[1, RowCount - 1] := aOrdem[cmbOrdem.ItemIndex];
  End;
end;

procedure TfrmAssistente.btnReLigClick(Sender: TObject);
begin
  RemoveLinha(grdLigacoes, grdLigacoes.Row);
end;

procedure TfrmAssistente.btnAdLigClick(Sender: TObject);
begin
  With grdLigacoes Do
  Begin
    If Cells[0,1] <> '' Then
      RowCount := RowCount + 1;
    Cells[0, RowCount - 1] := trvCampos.Selections[0].Text;
    Cells[1, RowCount - 1] := trvCampos.Selections[1].Text;
  End;
end;

procedure TfrmAssistente.btnSairClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmAssistente.pcDefChange(Sender: TObject);
begin
  trvCampos.MultiSelect := (pcDef.ActivePageIndex = 3);
end;

procedure TfrmAssistente.btnGerarSelectClick(Sender: TObject);
var
  sSelect, sFrom, sWhere, sOrder, sGroup: String;
  i: Integer;
  v, v1: String;
begin
  mmoSelect.Clear;

  lFrom := TStringList.Create;

  VerificaTabelas;

  sSelect := 'SELECT ';
  sGroup := 'GROUP BY ';
  v := '';
  v1 := '';
  With grdCampos Do
  Begin
    For i := 1 To RowCount - 1 Do
    Begin
      sSelect := sSelect + v + Cells[1,i] + '(' + Cells[0,i] + ')';
      If Cells[2,i] <> '' Then
        sSelect := sSelect + ' AS "' + Cells[2,i] + '"';
      If Cells[1,i] = '' Then
      Begin
        sGroup := sGroup + v1 + Cells[0,i];
        v1 := ', ';
      End;
      v := ', ';
    End;
  End;

  sFrom := 'FROM ';
  v := '';
  For i := 0 To lFrom.Count - 1 Do
  Begin
    If lFrom.Strings[i] <> '' Then
      sFrom := sFrom + v + lFrom.Strings[i];
    v := ', ';
  End;

  sWhere := '';
  v := '';
  With grdLigacoes Do
  Begin
    For i := 1 To RowCount - 1 Do
    Begin
      If Cells[0, i] <> '' Then
        sWhere := sWhere + v + Cells[0, i] + ' = ' + Cells[1, i];
      v := ' AND ';
    End;
  End;

  With grdCondicoes Do
  Begin
    For i := 1 To RowCount - 1 Do
    Begin
      If Cells[0, i] <> '' Then
      Begin
        sWhere := sWhere + v + Cells[0, i] + ' ' + Cells[1, i] + ' ' + Cells[2, i];
        If Cells[3, i] <> '' Then
          sWhere := sWhere + ' AND ' + Cells[3, i];
      End;
      v := ' AND ';
    End;
  End;

  v := '';
  With grdOrdem Do
  Begin
    For i := 1 To RowCount - 1 Do
    Begin
      If Cells[0, i] <> '' Then
        sOrder := sOrder + v + Cells[0, i] + ' ' + Cells[1, i];
      v := ', ';
    End;
  End;

  mmoSelect.Lines.Add(sSelect);
  mmoSelect.Lines.Add(sFrom);
  If sWhere <> '' Then mmoSelect.Lines.Add('WHERE ' + sWhere);
  mmoSelect.Lines.Add(sGroup);
  If sOrder <> '' Then mmoSelect.Lines.Add('ORDER BY ' + sOrder);
end;

function TfrmAssistente.RecTabela(Texto: String): String;
begin
  Result := Copy(Texto, 1, Pos('.', Texto) - 1);
end;

procedure TfrmAssistente.MonteTabelas(Tabela: String);
var
  i: Integer;
begin
  For i := 0 To lFrom.Count - 1 Do
    If Tabela = lFrom.Strings[i] Then
      Exit;
  lFrom.Add(Tabela);
end;

procedure TfrmAssistente.VerificaTabelas;
var
  aGrids: Array[0..3] of TStringGrid;
  i, j: Integer;
begin
  aGrids[0] := grdCampos;
  aGrids[1] := grdCondicoes;
  aGrids[2] := grdOrdem;
  aGrids[3] := grdLigacoes;
  
  For j := 0 To 3 Do
    For i := 1 To aGrids[j].RowCount - 1 Do
      MonteTabelas(RecTabela(aGrids[j].Cells[0, i]));
end;

procedure TfrmAssistente.btnCopiarClick(Sender: TObject);
begin
  mmoSelect.SelectAll;
  mmoSelect.CopyToClipboard;
end;

procedure TfrmAssistente.btnSalvarClick(Sender: TObject);
begin
  sdSalvar.Execute;
  mmoSelect.Lines.SaveToFile(sdSalvar.FileName);
end;

procedure TfrmAssistente.btnAbrirClick(Sender: TObject);
begin
  odAbrir.Execute;
  mmoSelect.Lines.LoadFromFile(odAbrir.FileName);
end;

procedure TfrmAssistente.btnConecxaoClick(Sender: TObject);
var
  Tn: TTreeNode;
  lTabelas, lCampos: TStrings;
  i, j: Integer;
begin
  With dmPrincipal Do
  Begin
    If frmConexao.Active(sqlConn) = mrOK Then
      Try
        Screen.Cursor := crHourGlass;
        lTabelas := TStringList.Create;
        lCampos := TStringList.Create;
        sqlConn.Connected := True;
        sqlConn.GetTableNames(lTabelas, False);
        For i := 0 To lTabelas.Count - 1 Do
        Begin
          sqlConn.GetFieldNames(lTabelas.Strings[i], lCampos);
          Tn := trvCampos.Items.Add(nil, lTabelas.Strings[i]);
          For j := 0 To lCampos.Count - 1 Do
            trvCampos.Items.AddChild(Tn, lTabelas.Strings[i] + '.' + lCampos.Strings[j]);
        End;
    Finally
      Screen.Cursor := crDefault;
    End;
  End;
end;

procedure TfrmAssistente.btnExecutarClick(Sender: TObject);
begin
  frmGrade.Active(mmoSelect.Text);
end;

end.
