unit untConexao;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, SqlExpr;

type
  TfrmConexao = class(TForm)
    cmbDriver: TComboBox;
    lblDriver: TLabel;
    edtPassword: TEdit;
    edtUserName: TEdit;
    cmbDialect: TComboBox;
    edtHostName: TEdit;
    edtDatabase: TEdit;
    lblHost: TLabel;
    lblBanco: TLabel;
    lblUsuario: TLabel;
    lblSenha: TLabel;
    lblDialeto: TLabel;
    btnOK: TBitBtn;
    btnCancelar: TBitBtn;
    procedure btnOKClick(Sender: TObject);
    procedure cmbDriverChange(Sender: TObject);
  private
    { Private declarations }
    sqlConn: TSQLConnection;
    procedure SetConection;
  public
    { Public declarations }
    function Active(Conn: TSQLConnection): TModalResult;
  end;

var
  frmConexao: TfrmConexao;

implementation

uses untDM;

{$R *.dfm}

procedure TfrmConexao.btnOKClick(Sender: TObject);
begin
  SetConection;
  ModalResult := mrOK;
end;

procedure TfrmConexao.cmbDriverChange(Sender: TObject);
begin
  edtHostName.Enabled := (cmbDriver.ItemIndex = 2);
  cmbDialect.Enabled := (cmbDriver.ItemIndex = 1);
end;

procedure TfrmConexao.SetConection;
const sDriver: Array[0..3] of String = ('DB2','Interbase','MySql','Oracle');
const sDll: Array[0..3] of String = ('DB2CLI.DLL','GDS32.DLL','LibMySql.DLL','OCI.DLL');
const sLib: Array[0..3] of String = ('dbExpdb2.DLL','dbExpint.DLL','dbExpmys.DLL','dbExpora.DLL');
begin
  With sqlConn Do
  Begin
    If Connected Then Connected := False;
    ConnectionName := cmbDriver.Text;
    DriverName := sDriver[cmbDriver.ItemIndex];
    VendorLib := sDll[cmbDriver.ItemIndex];
    LibraryName := sLib[cmbDriver.ItemIndex];
    GetDriverFunc := 'getSQLDriver' + UpperCase(sDriver[cmbDriver.ItemIndex]);
    Params.Values['Database'] := edtDatabase.Text;
    Params.Values['User_Name'] := edtUserName.Text;
    Params.Values['Password'] := edtPassword.Text;

    If cmbDriver.ItemIndex = 2 Then
      Params.Values['HostName'] := edtHostName.Text;

    If cmbDriver.ItemIndex = 1 Then
      Params.Values['SQLDialect'] := cmbDialect.Text;
  End;
end;

function TfrmConexao.Active(Conn: TSQLConnection): TModalResult;
var
  frm: TfrmConexao;
begin
  frm := TfrmConexao.Create(nil);

  frm.sqlConn := Conn;

  Result := frm.ShowModal;

  frm.Free;
end;

end.
