unit untGrade;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, DB, sqlExpr;

type
  TfrmGrade = class(TForm)
    grdVisualizacao: TDBGrid;
    dsGrade: TDataSource;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    procedure SetSql(Sql: String; sqlDs: TSQLDataSet);
  public
    { Public declarations }
    procedure Active(Sql: String);
  end;

var
  frmGrade: TfrmGrade;

implementation

uses untDM;

{$R *.dfm}

procedure TfrmGrade.Active(Sql: String);
var
  frm: TfrmGrade;
begin
  frm := TfrmGrade.Create(nil);

  SetSql(Sql, dmPrincipal.sqlGrade);

  frm.dsGrade.DataSet.Open;

  frm.ShowModal;

  frm.Free
end;

procedure TfrmGrade.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  frmGrade := nil;
end;

procedure TfrmGrade.SetSql(Sql: String; sqlDs: TSQLDataSet);
begin
  With sqlDs Do
  Begin
    Active := False;
    CommandText := Sql;
    Active := True;
  End;
end;

end.
