unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, DB, DBTables;

type
  TForm1 = class(TForm)
    qryCustomers: TQuery;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure FixDBGridColumnsWidth(const DBGrid: TDBGrid);
var
  i : integer;
  TotWidth : integer;
  VarWidth : integer;
  ResizableColumnCount : integer;
  AColumn : TColumn;
begin
  //Largura total de todas as colunas antes do redimensionamento
  TotWidth := 0;
  //Como dividir qualquer espao extra na grade
  VarWidth := 0;
  //Quantas colunas precisam de auto-redimensionamento
  ResizableColumnCount := 0;

  for i := 0 to -1 + DBGrid.Columns.Count do
  begin
    TotWidth := TotWidth + DBGrid.Columns[i].Width;
    if DBGrid.Columns[i].Field.Tag <> 0 then 
      Inc(ResizableColumnCount);
  end;

  //adiciona 1px para a linha de separao de colunas
  if dgColLines in DBGrid.Options then
    TotWidth := TotWidth + DBGrid.Columns.Count;

  //Adiciona indicador de largura
  if dgIndicator in DBGrid.Options then
    TotWidth := TotWidth + IndicatorWidth;

  //Largura recebe o valor da esquerda (left)
  VarWidth :=  DBGrid.ClientWidth - TotWidth;

  //Distribuio por igual da VarWidth
  //para todas as colunas auto-redimensionveis
  if ResizableColumnCount > 0 then
    VarWidth := varWidth div ResizableColumnCount;

  for i := 0 to -1 + DBGrid.Columns.Count do
  begin
    AColumn := DBGrid.Columns[i];
    if AColumn.Field.Tag <> 0 then
    begin
      AColumn.Width := AColumn.Width + VarWidth;
      if AColumn.Width < AColumn.Field.Tag then
        AColumn.Width := AColumn.Field.Tag;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  qryCustomers.Open;
  
  // Configurando o auto-redimensionamento das colunas por atribuir largura
  // mnima na propriedade Tag.

  // usando valor fixo: 40 px

  qryCustomers.FieldByName('LastName').Tag := 40;

  //usando valor varivel: largura padro do texto do ttulo da Coluna

  qryCustomers.FieldByName('Salary').Tag :=
    4 + Canvas.TextWidth(qryCustomers.FieldByName('Salary').DisplayName);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  FixDBGridColumnsWidth(DBGrid1);
end;

end.
