unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Mask, DBCtrls, DBTables, XPMan, Grids, DBGrids,
  ExtCtrls, ADODB;

type THackDBGrid = class(TDBGrid);
type
  TForm1 = class(TForm)
    XPManifest1: TXPManifest;
    dsCustomers: TDataSource;
    DBGrid1: TDBGrid;
    adoEmployee: TADOTable;
    adoEmployeeLastName: TWideStringField;
    adoEmployeeFirstName: TWideStringField;
    adoEmployeeHireDate: TDateTimeField;
    adoEmployeeSalary: TFloatField;
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure DBGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure DBGrid1OnClick(Sender : TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
procedure FixDBGridColumnsWidth(const DBGrid: TDBGrid);
var
  i : integer;
  TotWidth : integer;
  VarWidth : integer;
  ResizableColumnCount : integer;
  AColumn : TColumn;
begin
  //Largura total de todas as colunas antes do redimensionamento
  TotWidth := 0;
  //Como dividir qualquer espao extra na grade
  VarWidth := 0;
  //Quantas colunas precisam de auto-redimensionamento
  ResizableColumnCount := 0;

  for i := 0 to -1 + DBGrid.Columns.Count do
  begin
    TotWidth := TotWidth + DBGrid.Columns[i].Width;
    if DBGrid.Columns[i].Field.Tag <> 0 then 
      Inc(ResizableColumnCount);
  end;

  //adiciona 1px para a linha de separao de colunas
  if dgColLines in DBGrid.Options then
    TotWidth := TotWidth + DBGrid.Columns.Count;

  //Adiciona indicador de largura
  if dgIndicator in DBGrid.Options then
    TotWidth := TotWidth + IndicatorWidth;

  //Largura recebe o valor de "left"
  VarWidth :=  DBGrid.ClientWidth - TotWidth;

  //Distribuio por igual da VarWidth
  //para todas as colunas auto-redimensionveis
  if ResizableColumnCount > 0 then
    VarWidth := varWidth div ResizableColumnCount;

  for i := 0 to -1 + DBGrid.Columns.Count do
  begin
    AColumn := DBGrid.Columns[i];
    if AColumn.Field.Tag <> 0 then
    begin
      AColumn.Width := AColumn.Width + VarWidth;
      if AColumn.Width < AColumn.Field.Tag then
        AColumn.Width := AColumn.Field.Tag;
    end;
  end;
end; (*FixDBGridColumnsWidth*)



procedure TForm1.FormShow(Sender: TObject);
begin
  //Configurando o autoredimensionamento das colunas por atribuir
  //Largura mnima na propriedade Tag.
  
  //usando valor fixo: 40 px
  adoEmployee.FieldByName('LastName').Tag := 40;

  //usando valor varivel: largura
  //padro do texto do ttulo da Coluna
  adoEmployee.FieldByName('Salary').Tag :=
    4 + Canvas.TextWidth(
        adoEmployee.FieldByName('Salary').DisplayName);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
FixDBGridColumnsWidth(DBGrid1);
end;

procedure TForm1.DBGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  pt: TGridCoord;
begin
  pt:= DBGrid1.MouseCoord(x, y);
  if pt.y=0 then
    DBGrid1.Cursor:=crHandPoint
  else
    DBGrid1.Cursor:=crDefault;
end;

procedure TForm1.DBGrid1TitleClick(Column: TColumn);
{$J+}
 const PreviousColumnIndex : integer = -1;
begin
  if DBGrid1.DataSource.DataSet is TCustomADODataSet then
  with TCustomADODataSet(DBGrid1.DataSource.DataSet) do
  begin
    try
      DBGrid1.Columns[PreviousColumnIndex].title.Font.Style :=
      DBGrid1.Columns[PreviousColumnIndex].title.Font.Style - [fsBold];
    except
    end;

    Column.title.Font.Style := 
    Column.title.Font.Style + [fsBold];
    PreviousColumnIndex := Column.Index;

    if (Pos(Column.Field.FieldName, Sort) = 1) and (Pos(' DESC', Sort)= 0) then
      Sort := Column.Field.FieldName + ' DESC'
    else
      Sort := Column.Field.FieldName + ' ASC';
  end;
end;

procedure TForm1.DBGrid1OnClick(Sender: TObject);
begin
    ShowMessage('ActiveDelphi - Edio 11');
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  pt: TGridCoord;
begin
  pt:= DBGrid1.MouseCoord(x, y);
  if pt.y=0 then
    DBGrid1.Cursor:=crHandPoint
  else
    DBGrid1.Cursor:=crDefault;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{
  THackDBGrid(dbgrid1).ControlStyle :=
  THackDBGrid(dbgrid1).ControlStyle + [csClickEvents];
  THackDBGrid(DBGrid1).OnClick:=DBGrid1OnClick;
}
end;

end.
