unit uADApplicationHook;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, 
  Forms, Dialogs;

{$R adRegister.dcr}

type

  TOnHookMessage = procedure (Sender : TObject; var Message : TMessage; var Handled : boolean) of object;

  THookItem = class(TCollectionItem)
  private
    FHook : TWindowHook;
    FOnMessage : TOnHookMessage;
  protected
    function HookProc(var Message : TMessage) : boolean;
  public
    constructor Create(Collection : TCollection); override;
  published
    property OnMessage : TOnHookMessage read FOnMessage write FonMessage;
  end;

  THookItems = class(TCollection)
  private
    FOwner : TPersistent;
  protected
    function GetItem(Index : integer) : THookItem;
    procedure SetItem(Index : integer; Value : THookItem);
    function GetOwner : TPersistent; override;
  public
    constructor Create(AOwner : TPersistent; ItemClass : TCollectionItemClass);
    function Add : THookItem;
    property Items[Index : integer] : THookItem read GetItem write SetItem; default;
  end;

  TadApplicationHook = class(TComponent)
  private
    FItems : THookItems;
    procedure SetItems(const Value: THookItems);
  protected
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Activate;
    procedure Deactivate;
  published
    property Items : THookItems read FItems write SetItems;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ActiveDelphi', [TadApplicationHook]);
end;

{ THookItem }

constructor THookItem.Create(Collection: TCollection);
begin
  inherited;
  FHook := HookProc;
end;

function THookItem.HookProc(var Message: TMessage): boolean;
begin
  Result := false;
  if Assigned(FOnMessage) then
     FOnMessage(THookItems(Collection).FOwner, Message, Result);
end;

{ TadApplicationHook }

procedure TadApplicationHook.Activate;
var
 cnt : integer;
begin
  if Assigned(Application) then
  for cnt := 0 to FItems.Count - 1 do
   begin
     Application.HookMainWindow(FItems[cnt].FHook);
   end;
end;

constructor TadApplicationHook.Create(AOwner: TComponent);
begin
  inherited;
  FItems := THookItems.Create(Self, THookItem);
end;

procedure TadApplicationHook.Deactivate;
var
 cnt : integer;
begin
  if Assigned(Application) then
  for cnt := 0 to FItems.Count - 1 do
   begin
     Application.UnHookMainWindow(FItems[cnt].FHook);
   end;
end;

destructor TadApplicationHook.Destroy;
begin
  if (not (csDesigning in ComponentState) ) then
   Deactivate;
  FItems.Free;
  inherited;
end;

procedure TadApplicationHook.SetItems(const Value: THookItems);
begin
  FItems.Assign(Value);
end;

{ THookItems }

function THookItems.Add: THookItem;
begin
  Result := THookItem(inherited Add);
end;

constructor THookItems.Create(AOwner: TPersistent;
  ItemClass: TCollectionItemClass);
begin
  inherited Create(ItemClass);
  FOwner := AOwner;
end;

function THookItems.GetItem(Index: integer): THookItem;
begin
  Result := THookItem(inherited GetItem(Index));
end;

function THookItems.GetOwner: TPersistent;
begin
  Result := FOwner;
end;

procedure THookItems.SetItem(Index: integer; Value: THookItem);
begin
  inherited SetItem(Index, Value);
end;

end.
