unit uStandaloneExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uADApplicationHook;
  
const
  WM_MY_MESSAGE = WM_USER +1;

type
  TfrmHookTest = class(TForm)
    adApplicationHook1: TadApplicationHook;
    btnSendMessage: TButton;
    btnActivateHook: TButton;
    btnDeactivateHook: TButton;
    procedure btnSendMessageClick(Sender: TObject);
    procedure btnActivateHookClick(Sender: TObject);
    procedure btnDeactivateHookClick(Sender: TObject);
    procedure ProcessHookMessage(Sender: TObject; var Message: TMessage;
      var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmHookTest: TfrmHookTest;

implementation

{$R *.dfm}

procedure TfrmHookTest.btnSendMessageClick(Sender: TObject);
begin
  SendMessage(Application.Handle, WM_MY_MESSAGE, 0, 0);
end;

procedure TfrmHookTest.btnActivateHookClick(Sender: TObject);
begin
	btnSendMessage.Enabled 		:= True;
	btnDeactivateHook.Enabled := True;
  btnActivateHook.Enabled 	:= False;
  adApplicationHook1.Activate;
end;

procedure TfrmHookTest.btnDeactivateHookClick(Sender: TObject);
begin
	btnSendMessage.Enabled 		:= False;
	btnDeactivateHook.Enabled := False;
  btnActivateHook.Enabled 	:= True;
  adApplicationHook1.Deactivate;
end;

procedure TfrmHookTest.ProcessHookMessage(Sender: TObject;
  var Message: TMessage; var Handled: Boolean);
begin
	if Message.Msg = WM_MY_MESSAGE then
		ShowMessage('I received a message!');
end;

end.
