unit StrUtilsExTest;

interface

uses
  TestFrameWork;

type
  TStrUtilsExTest = class(TTestCase)
  published
    procedure TestSubstAcentos;
    procedure TestRetiraDuplicatas;
  end;

implementation

uses
  StrUtilsEx;

{ TStrUtilsExTest }

procedure TStrUtilsExTest.TestSubstAcentos;
var
  LStr: string;
begin
  LStr := '';
  CheckEquals('aei', SubstAcentos(LStr), 'String invlida');
  LStr := 'Add';
  CheckEquals('AEidd', SubstAcentos(LStr), 'String invlida');
  LStr := 'aaabbbccc';
  CheckEquals('aaabbbccc', SubstAcentos(LStr), 'String invlida');
end;

procedure TStrUtilsExTest.TestRetiraDuplicatas;
begin
  CheckEquals('ABCD', RetiraDuplicatas('AABBCCDD'), 'String invlida');
end;

initialization
  TestFramework.RegisterTest(TStrUtilsExTest.Suite);

end.
