unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Threading;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    prgBarThread: System.Windows.Forms.ProgressBar;
    Button2: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    MyThread: Thread;
    procedure MoveBar;
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.prgBarThread := System.Windows.Forms.ProgressBar.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(52, 28);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(156, 23);
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Criar Thread';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // prgBarThread
  // 
  Self.prgBarThread.Location := System.Drawing.Point.Create(52, 60);
  Self.prgBarThread.Maximum := 1000000;
  Self.prgBarThread.Name := 'prgBarThread';
  Self.prgBarThread.Size := System.Drawing.Size.Create(156, 23);
  Self.prgBarThread.TabIndex := 1;
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(228, 28);
  Self.Button2.Name := 'Button2';
  Self.Button2.Size := System.Drawing.Size.Create(180, 23);
  Self.Button2.TabIndex := 2;
  Self.Button2.Text := 'Mensagem';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(456, 113);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.prgBarThread);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  MessageBox.Show('Exibindo a mensagem enquanto executa a Thread...');
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  MyThread := Thread.Create(MoveBar);
  MyThread.Priority := ThreadPriority.Lowest;
  MyThread.Start;
end;

procedure TWinForm.MoveBar;
Var
  i: Integer;
begin
  i := prgBarThread.Minimum;
  while i <= prgBarThread.Maximum do
  begin
    prgBarThread.Value := i;
    i := i + 10;
  end;
end;

end.
