unit uFrmEmail;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TDlgEmail = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    txbEmail: System.Windows.Forms.TextBox;
    lbPrompt: System.Windows.Forms.Label;
    BtnOk: System.Windows.Forms.Button;
    BtnCancel: System.Windows.Forms.Button;
    ErrorProvider1: System.Windows.Forms.ErrorProvider;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure txbEmail_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure txbEmail_Validated(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    function ValidaEmail(ATexto : string) : boolean;
  public
    function GetTexto: string;
    procedure SetTexto(const Value: string);
    constructor Create;
    class procedure Edit(var AEmail : string);
    property Texto : string read GetTexto write SetTexto;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TDlgEmail))]

implementation

uses System.Text.RegularExpressions;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TDlgEmail.InitializeComponent;
begin
  Self.txbEmail := System.Windows.Forms.TextBox.Create;
  Self.lbPrompt := System.Windows.Forms.Label.Create;
  Self.BtnOk := System.Windows.Forms.Button.Create;
  Self.BtnCancel := System.Windows.Forms.Button.Create;
  Self.ErrorProvider1 := System.Windows.Forms.ErrorProvider.Create;
  Self.SuspendLayout;
  // 
  // txbEmail
  // 
  Self.txbEmail.Location := System.Drawing.Point.Create(24, 40);
  Self.txbEmail.Name := 'txbEmail';
  Self.txbEmail.Size := System.Drawing.Size.Create(256, 20);
  Self.txbEmail.TabIndex := 1;
  Self.txbEmail.Text := '';
  Include(Self.txbEmail.Validating, Self.txbEmail_Validating);
  Include(Self.txbEmail.Validated, Self.txbEmail_Validated);
  // 
  // lbPrompt
  // 
  Self.lbPrompt.Location := System.Drawing.Point.Create(24, 16);
  Self.lbPrompt.Name := 'lbPrompt';
  Self.lbPrompt.TabIndex := 0;
  Self.lbPrompt.Text := '&E-mail:';
  // 
  // BtnOk
  // 
  Self.BtnOk.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.BtnOk.Location := System.Drawing.Point.Create(112, 80);
  Self.BtnOk.Name := 'BtnOk';
  Self.BtnOk.TabIndex := 2;
  Self.BtnOk.Text := 'Aceitar';
  // 
  // BtnCancel
  // 
  Self.BtnCancel.CausesValidation := False;
  Self.BtnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.BtnCancel.Location := System.Drawing.Point.Create(208, 80);
  Self.BtnCancel.Name := 'BtnCancel';
  Self.BtnCancel.TabIndex := 3;
  Self.BtnCancel.Text := 'Cancelar';
  //
  // ErrorProvider1
  //
  Self.ErrorProvider1.ContainerControl := Self;
  //
  // TDlgEmail
  //
  Self.AcceptButton := Self.BtnOk;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.BtnCancel;
  Self.ClientSize := System.Drawing.Size.Create(296, 117);
  Self.Controls.Add(Self.BtnCancel);
  Self.Controls.Add(Self.BtnOk);
  Self.Controls.Add(Self.txbEmail);
  Self.Controls.Add(Self.lbPrompt);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedDialog;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TDlgEmail';
  Self.ShowInTaskbar := False;
  Self.SizeGripStyle := System.Windows.Forms.SizeGripStyle.Hide;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Escreva um endereo de email vlido';
  Self.TopMost := True;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TDlgEmail.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TDlgEmail.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

class procedure TDlgEmail.Edit(var AEmail: string);
var
  DlgEmail : TDlgEmail;
begin
  DlgEmail := TDlgEmail.Create;
  try
    DlgEmail.Texto := AEmail;
    if DlgEmail.ShowDialog = system.Windows.Forms.DialogResult.OK then
      AEmail := DlgEmail.Texto;
  finally
    DlgEmail.Free;
  end
end;

procedure TDlgEmail.txbEmail_Validated(sender: System.Object; e: System.EventArgs);
begin
  ErrorProvider1.SetError(TxbEmail, '');
end;

procedure TDlgEmail.txbEmail_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  e.Cancel := not ValidaEmail(txbEmail.Text);
  if e.Cancel then ErrorProvider1.SetError(txbEmail,
      'Email com formato incorreto.');
end;

function TDlgEmail.GetTexto: string;
begin
  result := txbEmail.Text;
end;

procedure TDlgEmail.SetTexto(const Value: string);
begin
  txbEmail.Text := Value;
end;

function TDlgEmail.ValidaEmail(ATexto: string): boolean;
begin
  result := Regex.IsMatch(ATexto,
  '^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))' +
  '([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$');
end;

end.
