unit uFrmPessoa;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, uPessoa;

type
  TFmPessoa = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnOk: System.Windows.Forms.Button;
    BtnCancel: System.Windows.Forms.Button;
    txbNome: System.Windows.Forms.TextBox;
    txbEmail: System.Windows.Forms.TextBox;
    DtPckDataDeNascimento: System.Windows.Forms.DateTimePicker;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    Label3: System.Windows.Forms.Label;
    ErrorProvider1: System.Windows.Forms.ErrorProvider;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure txbNome_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure DtPckDataDeNascimento_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure txbEmail_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure txbEmail_Validated(sender: System.Object; e: System.EventArgs);
    procedure DtPckDataDeNascimento_Validated(sender: System.Object; e: System.EventArgs);
    procedure txbNome_Validated(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    function ValidaNome(ANome : string) : boolean;
    function ValidaData(ADate : DateTime) : boolean;
    function ValidaEmail(AEmail : string) : boolean;
  protected
    FPessoa : TPessoa;
    procedure InitCampos;
    procedure AtualizaCampos;
  public
    constructor Create;
    class procedure Edit(APessoa : TPessoa);
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFmPessoa))]

implementation

uses system.Globalization, system.Text.RegularExpressions;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFmPessoa.InitializeComponent;
begin
  Self.btnOk := System.Windows.Forms.Button.Create;
  Self.BtnCancel := System.Windows.Forms.Button.Create;
  Self.txbNome := System.Windows.Forms.TextBox.Create;
  Self.txbEmail := System.Windows.Forms.TextBox.Create;
  Self.DtPckDataDeNascimento := System.Windows.Forms.DateTimePicker.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.ErrorProvider1 := System.Windows.Forms.ErrorProvider.Create;
  Self.SuspendLayout;
  // 
  // btnOk
  // 
  Self.btnOk.DialogResult := System.Windows.Forms.DialogResult.OK;
  Self.btnOk.Location := System.Drawing.Point.Create(160, 184);
  Self.btnOk.Name := 'btnOk';
  Self.btnOk.TabIndex := 3;
  Self.btnOk.Text := 'Aceitar';
  // 
  // BtnCancel
  // 
  Self.BtnCancel.CausesValidation := False;
  Self.BtnCancel.DialogResult := System.Windows.Forms.DialogResult.Cancel;
  Self.BtnCancel.Location := System.Drawing.Point.Create(248, 184);
  Self.BtnCancel.Name := 'BtnCancel';
  Self.BtnCancel.TabIndex := 4;
  Self.BtnCancel.Text := 'Cancelar';
  // 
  // txbNome
  // 
  Self.txbNome.Location := System.Drawing.Point.Create(112, 24);
  Self.txbNome.Name := 'txbNome';
  Self.txbNome.Size := System.Drawing.Size.Create(208, 20);
  Self.txbNome.TabIndex := 0;
  Self.txbNome.Text := '';
  Include(Self.txbNome.Validating, Self.txbNome_Validating);
  Include(Self.txbNome.Validated, Self.txbNome_Validated);
  // 
  // txbEmail
  // 
  Self.txbEmail.Location := System.Drawing.Point.Create(112, 129);
  Self.txbEmail.Name := 'txbEmail';
  Self.txbEmail.Size := System.Drawing.Size.Create(208, 20);
  Self.txbEmail.TabIndex := 2;
  Self.txbEmail.Text := '';
  Include(Self.txbEmail.Validating, Self.txbEmail_Validating);
  Include(Self.txbEmail.Validated, Self.txbEmail_Validated);
  // 
  // DtPckDataDeNascimento
  // 
  Self.DtPckDataDeNascimento.CustomFormat := 'dd/MM/yyyy';
  Self.DtPckDataDeNascimento.Format := System.Windows.Forms.DateTimePickerFormat.Custom;
  Self.DtPckDataDeNascimento.Location := System.Drawing.Point.Create(112, 73);
  Self.DtPckDataDeNascimento.Name := 'DtPckDataDeNascimento';
  Self.DtPckDataDeNascimento.Size := System.Drawing.Size.Create(208, 20);
  Self.DtPckDataDeNascimento.TabIndex := 1;
  Include(Self.DtPckDataDeNascimento.Validating, Self.DtPckDataDeNascimento_Validating);
  Include(Self.DtPckDataDeNascimento.Validated, Self.DtPckDataDeNascimento_Validated);
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(16, 23);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(80, 23);
  Self.Label1.TabIndex := 5;
  Self.Label1.Text := 'Nome';
  Self.Label1.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(16, 72);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(80, 23);
  Self.Label2.TabIndex := 6;
  Self.Label2.Text := 'Data de Nascimento';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(16, 128);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(80, 23);
  Self.Label3.TabIndex := 7;
  Self.Label3.Text := 'Email';
  Self.Label3.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  // 
  // ErrorProvider1
  // 
  Self.ErrorProvider1.ContainerControl := Self;
  // 
  // TFmPessoa
  // 
  Self.AcceptButton := Self.btnOk;
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.CancelButton := Self.BtnCancel;
  Self.ClientSize := System.Drawing.Size.Create(346, 231);
  Self.Controls.Add(Self.DtPckDataDeNascimento);
  Self.Controls.Add(Self.txbEmail);
  Self.Controls.Add(Self.txbNome);
  Self.Controls.Add(Self.BtnCancel);
  Self.Controls.Add(Self.btnOk);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label3);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedDialog;
  Self.MaximizeBox := False;
  Self.MinimizeBox := False;
  Self.Name := 'TFmPessoa';
  Self.ShowInTaskbar := False;
  Self.SizeGripStyle := System.Windows.Forms.SizeGripStyle.Hide;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'Editar Pessoa';
  Self.TopMost := True;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFmPessoa.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFmPessoa.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

class procedure TFmPessoa.Edit(APessoa: TPessoa);
var
  DlgPessoa : TFmPessoa;
begin
  DlgPessoa := TFmPessoa.Create;
  try
    DlgPessoa.FPessoa := APessoa;
    DlgPessoa.InitCampos;
    if DlgPessoa.ShowDialog = system.Windows.Forms.DialogResult.OK then
      DlgPessoa.AtualizaCampos;
  finally
    DlgPessoa.Free;
  end;
end;

procedure TFmPessoa.txbNome_Validated(sender: System.Object; e: System.EventArgs);
begin
  ErrorProvider1.SetError(txbNome, '');
end;

procedure TFmPessoa.DtPckDataDeNascimento_Validated(sender: System.Object; e: System.EventArgs);
begin
  ErrorProvider1.SetError(dtPckDataDeNascimento, '');
end;

procedure TFmPessoa.txbEmail_Validated(sender: System.Object; e: System.EventArgs);
begin
  ErrorProvider1.SetError(txbEmail, '');
end;

procedure TFmPessoa.txbEmail_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  e.Cancel := not ValidaEmail(txbEmail.Text);
  if e.Cancel then
    ErrorProvider1.SetError(txbEmail, 'Formato do Email incorreto.');
end;

procedure TFmPessoa.DtPckDataDeNascimento_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  e.Cancel:= not ValidaData(DtPckDataDeNascimento.Value);
  if e.Cancel then
    ErrorProvider1.SetError(dtPckDataDeNascimento, 'Pessoa deve ter 18 anos ou mais.');
end;

procedure TFmPessoa.txbNome_Validating(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  e.Cancel := not ValidaNome(txbNome.Text);
  if e.Cancel then
    ErrorProvider1.SetError(txbNome, 'Nome no pode ser vazio.');
end;

procedure TFmPessoa.AtualizaCampos;
begin
  FPessoa.Nome := txbNome.Text;
  FPessoa.DataDeNascimento := DtPckDataDeNascimento.Value;
  FPessoa.Email := txbEmail.Text;
end;

procedure TFmPessoa.InitCampos;
begin
  txbNome.Text := FPessoa.Nome;
  DtPckDataDeNascimento.Value := FPessoa.DataDeNascimento;
  txbEmail.Text := FPessoa.Email;
end;

function TFmPessoa.ValidaData(ADate: DateTime): boolean;
var
  MyCal : Calendar;
begin
  MyCal := CultureInfo.InvariantCulture.Calendar;
  result := ADate < MyCal.AddYears(DateTime.Today, -18);
end;

function TFmPessoa.ValidaEmail(AEmail: string): boolean;
begin
  result := Regex.IsMatch(AEmail,
    '^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)' +
    '|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$');
end;

function TFmPessoa.ValidaNome(ANome: string): boolean;
begin
  //nome no pode ser vazio
  result := ANome <> System.&String.Empty;
end;

end.
