unit uPessoa;

interface

type
  TPessoa = class
  private
    FNome: string;
    FEmail: string;
    FDataDeNascimento: TDateTime;
  public
    constructor Create;
  published
    function GetIdade: integer;
    property Nome : string read FNome write FNome;
    property Idade : integer read GetIdade;
    property DataDeNascimento : TDateTime read FDataDeNascimento
      write FDataDeNascimento;
    property Email : string read FEmail write FEmail;
  end;

implementation

uses system.Globalization;

constructor TPessoa.Create;
begin
  inherited Create;
  FNome := '<Nome>';
  FDataDeNascimento := system.DateTime.Parse('01/01/1987');
  FEmail := 'joao@email.com';
end;

function TPessoa.GetIdade: integer;
var
  meses : integer;
begin
  result := DateTime.Today.Year - FDataDeNascimento.Year;
  meses := DateTime.Today.Month -  FDataDeNascimento.Month;
  if meses = 0 then
    if (DateTime.Today.Day < FDataDeNascimento.Day) then
      meses := -1;
  if meses < 0 then dec(result);
end;

end.
