unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    lbNome: System.Windows.Forms.Label;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    Label3: System.Windows.Forms.Label;
    txtNome: System.Windows.Forms.TextBox;
    txtEmail: System.Windows.Forms.TextBox;
    txtTelefone: System.Windows.Forms.TextBox;
    txtObs: System.Windows.Forms.TextBox;
    btNovo: System.Windows.Forms.Button;
    btDeletar: System.Windows.Forms.Button;
    btProximo: System.Windows.Forms.Button;
    btAnterior: System.Windows.Forms.Button;
    StatusBar1: System.Windows.Forms.StatusBar;
    btGravar: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure btNovo_Click(sender: System.Object; e: System.EventArgs);
    procedure btProximo_Click(sender: System.Object; e: System.EventArgs);
    procedure btAnterior_Click(sender: System.Object; e: System.EventArgs);
    procedure btGravar_Click(sender: System.Object; e: System.EventArgs);
    procedure btDeletar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    Ds : DataSet;
    Cur : CurrencyManager;
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.lbNome := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.txtNome := System.Windows.Forms.TextBox.Create;
  Self.txtEmail := System.Windows.Forms.TextBox.Create;
  Self.txtTelefone := System.Windows.Forms.TextBox.Create;
  Self.txtObs := System.Windows.Forms.TextBox.Create;
  Self.btNovo := System.Windows.Forms.Button.Create;
  Self.btDeletar := System.Windows.Forms.Button.Create;
  Self.btProximo := System.Windows.Forms.Button.Create;
  Self.btAnterior := System.Windows.Forms.Button.Create;
  Self.StatusBar1 := System.Windows.Forms.StatusBar.Create;
  Self.btGravar := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // lbNome
  // 
  Self.lbNome.Location := System.Drawing.Point.Create(8, 8);
  Self.lbNome.Name := 'lbNome';
  Self.lbNome.Size := System.Drawing.Size.Create(72, 16);
  Self.lbNome.TabIndex := 0;
  Self.lbNome.Text := 'Nome:';
  Self.lbNome.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(8, 32);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(72, 16);
  Self.Label1.TabIndex := 1;
  Self.Label1.Text := 'Email:';
  Self.Label1.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(8, 56);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(72, 16);
  Self.Label2.TabIndex := 2;
  Self.Label2.Text := 'Telefone:';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(8, 80);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(72, 16);
  Self.Label3.TabIndex := 3;
  Self.Label3.Text := 'Observao:';
  Self.Label3.TextAlign := System.Drawing.ContentAlignment.TopRight;
  // 
  // txtNome
  // 
  Self.txtNome.Location := System.Drawing.Point.Create(80, 6);
  Self.txtNome.Name := 'txtNome';
  Self.txtNome.Size := System.Drawing.Size.Create(216, 20);
  Self.txtNome.TabIndex := 4;
  Self.txtNome.Text := '';
  // 
  // txtEmail
  // 
  Self.txtEmail.Location := System.Drawing.Point.Create(80, 30);
  Self.txtEmail.Name := 'txtEmail';
  Self.txtEmail.Size := System.Drawing.Size.Create(216, 20);
  Self.txtEmail.TabIndex := 5;
  Self.txtEmail.Text := '';
  // 
  // txtTelefone
  // 
  Self.txtTelefone.Location := System.Drawing.Point.Create(80, 56);
  Self.txtTelefone.Name := 'txtTelefone';
  Self.txtTelefone.Size := System.Drawing.Size.Create(120, 20);
  Self.txtTelefone.TabIndex := 6;
  Self.txtTelefone.Text := '';
  // 
  // txtObs
  // 
  Self.txtObs.Location := System.Drawing.Point.Create(80, 80);
  Self.txtObs.Multiline := True;
  Self.txtObs.Name := 'txtObs';
  Self.txtObs.Size := System.Drawing.Size.Create(192, 88);
  Self.txtObs.TabIndex := 7;
  Self.txtObs.Text := '';
  // 
  // btNovo
  // 
  Self.btNovo.Location := System.Drawing.Point.Create(112, 176);
  Self.btNovo.Name := 'btNovo';
  Self.btNovo.TabIndex := 8;
  Self.btNovo.Text := 'Novo';
  Include(Self.btNovo.Click, Self.btNovo_Click);
  // 
  // btDeletar
  // 
  Self.btDeletar.Location := System.Drawing.Point.Create(272, 176);
  Self.btDeletar.Name := 'btDeletar';
  Self.btDeletar.TabIndex := 9;
  Self.btDeletar.Text := 'Deletar';
  Include(Self.btDeletar.Click, Self.btDeletar_Click);
  // 
  // btProximo
  // 
  Self.btProximo.Location := System.Drawing.Point.Create(72, 176);
  Self.btProximo.Name := 'btProximo';
  Self.btProximo.Size := System.Drawing.Size.Create(32, 23);
  Self.btProximo.TabIndex := 10;
  Self.btProximo.Text := '>>';
  Include(Self.btProximo.Click, Self.btProximo_Click);
  // 
  // btAnterior
  // 
  Self.btAnterior.Location := System.Drawing.Point.Create(32, 176);
  Self.btAnterior.Name := 'btAnterior';
  Self.btAnterior.Size := System.Drawing.Size.Create(32, 23);
  Self.btAnterior.TabIndex := 11;
  Self.btAnterior.Text := '<<';
  Include(Self.btAnterior.Click, Self.btAnterior_Click);
  // 
  // StatusBar1
  // 
  Self.StatusBar1.Location := System.Drawing.Point.Create(0, 216);
  Self.StatusBar1.Name := 'StatusBar1';
  Self.StatusBar1.Size := System.Drawing.Size.Create(376, 22);
  Self.StatusBar1.TabIndex := 12;
  Self.StatusBar1.Text := 'Agenda - Jefferson Luis Junglaus';
  // 
  // btGravar
  // 
  Self.btGravar.Location := System.Drawing.Point.Create(192, 176);
  Self.btGravar.Name := 'btGravar';
  Self.btGravar.TabIndex := 13;
  Self.btGravar.Text := 'Gravar';
  Include(Self.btGravar.Click, Self.btGravar_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(376, 238);
  Self.Controls.Add(Self.btGravar);
  Self.Controls.Add(Self.StatusBar1);
  Self.Controls.Add(Self.btAnterior);
  Self.Controls.Add(Self.btProximo);
  Self.Controls.Add(Self.btDeletar);
  Self.Controls.Add(Self.btNovo);
  Self.Controls.Add(Self.txtObs);
  Self.Controls.Add(Self.txtTelefone);
  Self.Controls.Add(Self.txtEmail);
  Self.Controls.Add(Self.txtNome);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.lbNome);
  Self.Name := 'TWinForm';
  Self.Text := 'Agenda de Contatos';
  Include(Self.Load, Self.TWinForm_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.btDeletar_Click(sender: System.Object; e: System.EventArgs);
begin
  //Deleta a Row Atual
  Ds.Tables[0].Rows[Cur.Position].Delete;
  Cur.Position := Cur.Count;
end;

procedure TWinForm.btGravar_Click(sender: System.Object; e: System.EventArgs);
begin
  Ds.WriteXml('dados.xml'); //Grava alteraes feitas no DataSet
end;

procedure TWinForm.btAnterior_Click(sender: System.Object; e: System.EventArgs);
begin
  if Cur.Position <> 0 then
    Cur.Position := Cur.Position - 1;
end;

procedure TWinForm.btProximo_Click(sender: System.Object; e: System.EventArgs);
begin
  if Cur.Position < Cur.Count then
    Cur.Position := Cur.Position + 1;
end;

procedure TWinForm.btNovo_Click(sender: System.Object; e: System.EventArgs);
var
  Dr : DataRow;
begin
  //Novo Registro
  Dr := Ds.Tables[0].NewRow;
  Dr['NOME'] := 'Digite o Nome do Contato';
  Dr['EMAIL'] := 'Digite o Email do Contato';
  Dr['TELEFONE'] := 'Digite o Telefone do Contato';
  Dr['OBS'] := 'Observao';
  Ds.Tables[0].Rows.Add(Dr); //Adiciona a Nova Linha ao DataSet

  Cur.Position := Cur.Count; //Vai para o Ultimo Registro, no caso o Registro Incluido
  txtNome.Focus;
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  Ds := DataSet.Create('AGENDA'); //Cria o Objeto Ds
  Ds.ReadXml('dados.xml'); //Le o arquivo XML ja criado
    Cur := CurrencyManager(BindingContext[Ds.Tables[0]]);
  //Configura os DataBindings dos Controles
  txtNome.DataBindings.Add('Text', Ds.Tables[0], 'NOME');
  txtEmail.DataBindings.Add('Text', Ds.Tables[0], 'EMAIL');
  txtTelefone.DataBindings.Add('Text', Ds.Tables[0], 'TELEFONE');
  txtObs.DataBindings.Add('Text', Ds.Tables[0], 'OBS');
end;

end.
