unit UAtualizar;

interface

uses
  ShellApi, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, 
  IniFiles, Gauges, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdHTTP, IdAntiFreezeBase, IdAntiFreeze;

type
  TFrmAtualizar = class(TForm)
    btnIniciar: TBitBtn;
    btnFechar: TBitBtn;
    Gauge1: TGauge;
    StatusBar1: TStatusBar;
    btnAbortar: TBitBtn;
    btnConfigurar: TBitBtn;
    lbURL: TLabel;
    IdHTTP1: TIdHTTP;
    IdAntiFreeze1: TIdAntiFreeze;

    procedure btnFecharClick(Sender: TObject);
    procedure btnConfigurarClick(Sender: TObject);
    procedure IdHTTP1Work(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
    procedure IdHTTP1WorkBegin(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCountMax: Integer);
    procedure StatusBar1DrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure btnIniciarClick(Sender: TObject);
    procedure btnAbortarClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    //variveis usadas para mostrar o progresso do download
    ini_file_name, unidade: string;
    quant_bytes_divisor: integer;

    //indicar a URL para download do arquivo
    URL: string;
    //indicar se o download do arquivo foi abortado pelo usurio
    Abortado: Boolean;
    
    //retorna o endereo do diretrio temporrio do windows
    Function TempDir: String;
    //deleta um arquivo baixado
    function DeleteDownload(NomeArq: String): boolean;
    {inicia o processo de download de um arquivo.
    A funo s retorna quando o download for concludo ou cancelado}
    function GetFile(RemoteFile, LocalFile: String): Boolean;
    //retorna o nmero de verso do arquivo passado como parmetro
    function FileVersion(path: string): ShortString;
    procedure VerificaVersao(NomeArqVersaoLocal: String);
    {Compara 2 nmeros de verso passados como parmetro e
     verifica qual nmero  maior ou se os nmeros so iguais

     retorno da funo:
       0 - as verses so iguais;
       1 - a verso 1  maior verso que a 2,
       2 - a verso 2  maior verso que a 1 }
    function ComparaVersaoArquivo(VersaoArquivo1,
      VersaoArquivo2: ShortString): Byte;
    procedure DivNumeroVersao(version_str: ShortString;
      var major_version, minor_version, release, build: word);
    procedure ExecutaUpdate(NomeArqLocal: String);
    function Atualizar(UpdateProgram, NovoEXE: String; Opcao: String): boolean;
  public
    { Public declarations }
    //armazena o caminho completo do programa de atualizao
    PathUpdateProgram: String;
    //armazena o nome do arquivo (sem extenso) que vai ser baixado da internet
    NomeArqSemExtensao: String;
  end;


const
  URLPadrao = 'http://localhost/';

var
  FrmAtualizar: TFrmAtualizar;

implementation

{$R *.dfm}

{funo responsvel por executar o programa de atualizao
e finalizar o sistema para permitir a atualizao do executvel}
function TFrmAtualizar.Atualizar(UpdateProgram, NovoEXE: String; Opcao: String): boolean;
var params: string;
begin
{O programa de atualizao (update.exe) deve ser executado passando-se
 parmetros:

1 parmetro: caminho do novo executvel
2 parmetro: caminho do executvel antigo
3 parmetro: opo
   Valores possveis: delete_exe_origem ou nao_delete_exe_origem
   Valores usados para informar ao programa de atualizao
   se  para deletar ou no o executvel de onde foi feita a atualizao.

  Quando a atualizao  feita pela internet, o arquivo de origem
   salvo na pasta Temp do Windows. Assim, aps ser feita a atualizao,
  deve-se deletar o arquivo temporrio informando neste 3 parmetro o valor
 'delete_exe_origem'
}
   //cria a lista de parmetros a ser passada para o programa de atualizao
   params:= '"' + NovoEXE + '"' + ' ' +
            '"' +  Application.ExeName  + '" ' + opcao;

   //executa o programa de atualizao passando os devidos parmetros
   {se o resultado da funo ShellExecute for maior que 32  porque o
   programa foi executado com sucesso.}
   result:=
     (ShellExecute(application.handle,'open',PChar(UpdateProgram),
     PChar(params),'',sw_showNormal) > 32);
end;

//retorna o nmero de verso do arquivo passado como parmetro
function TFrmAtualizar.FileVersion(path: string): ShortString;
var
  size, size2: DWord;
  pt, pt2: Pointer;
begin
  result:= '';
  size:= GetFileVersionInfoSize(PChar(path),size2);
  if size > 0 then
  begin
     GetMem(pt, size);
     try
       GetFileVersionInfo(PChar(path),0,size,pt);
       VerQueryValue(pt,'\',pt2,size2);
       with TVSFixedFileInfo(pt2^) do
       begin
           result:=
             IntToStr(HiWord(dwFileVersionMS)) + '.' +
             IntToStr(LoWord(dwFileVersionMS)) + '.' +
             IntToStr(HiWord(dwFileVersionLS)) + '.' +
             IntToStr(LoWord(dwFileVersionLS))
       end;
     finally
       FreeMem(pt);
     end;
  end;
end;


//retorna o endereo do diretrio temporrio do windows
function TFrmAtualizar.TempDir: String;
var dir: PChar;
begin
  GetMem(dir,255);
  try
    GetTempPath(255,dir);
    if dir = '' then
      result:= 'c:\'
    else Result := StrPas(dir);
    if result[length(Result)] <> '\' then
      result:= result + '\';
  finally
    FreeMem(dir);
  end;
end;

//deleta um arquivo baixado
function TFrmAtualizar.DeleteDownload(NomeArq: String): boolean;
begin
   result:= false;
   if FileExists(NomeArq) then
      result:= DeleteFile(NomeArq);
end;

procedure TFrmAtualizar.btnIniciarClick(Sender: TObject);
var ini: TIniFile;
begin
  {Varivel que informa se o donwload foi abortado
  Caso o usurio clique no boto Abortar, essa varivel recebe True
  para informar que o donwload foi interrompido pelo usurio }
  Abortado:= false;

  if URL = '' then
  begin
     {l no arquivo ini a URL do site de onde a atualizao ser baixado}
     ini:= TIniFile.Create(ini_file_name);
     try
       URL:= trim(ini.ReadString('update','URL', ''));
       if url = '' then
          URL:= URLPadrao;
     finally
       ini.free;
     end;
  end;

  try
    btnAbortar.Visible := false;
    btnConfigurar.enabled:= false;
    btnFechar.enabled:= false;
    btnIniciar.visible := false;
    StatusBar1.SimpleText:= 'Verificando nova verso no servidor remoto...';

    lbURL.caption:= 'Fazendo Download a partir do site'#13 + URL;

    {a funo GetFile baixa um arquivo utilizando o objeto IdHTTP1.
    Na linha abaixo  feito o download do arquivo .ini que contm
    o nmero da verso existente no site.
    A atulizao s  baixada se o nmero da verso informada
    no arquivo .ini for maior que o do arquivo executvel
    instalado no computador. O procedure VerificaVersao se
    encarrega de fazer as verificaes necessrias e
    executar o download e instalao da atualizao.}
    if GetFile(URL + NomeArqSemExtensao + '.ini',
    TempDir + NomeArqSemExtensao + '.ini') then
       VerificaVersao(TempDir + NomeArqSemExtensao + '.ini');
    {A varivel NomeArqSemExtensao indica o nome do arquivo a ser baixado.
    Tando o arquivo .ini quanto o .exe devem ter o mesmo nome.}
  finally
    StatusBar1.SimpleText:= '';
    Gauge1.Progress := 0;
    lbURL.caption:= '';
    btnIniciar.visible := true;
    btnAbortar.visible := false;
    btnFechar.enabled:= true;
    btnConfigurar.enabled:= true;

    DeleteDownload(TempDir + NomeArqSemExtensao + '.ini');
  end;
end;

procedure TFrmAtualizar.FormCreate(Sender: TObject);
begin
  lbURL.caption:= '';
  {define o nome do arquivo .ini que armazenar a URL para download
  de atualizaes}
  ini_file_name:= ExtractFilePath(Application.ExeName) + 'config.ini';
  btnAbortar.Top := btnIniciar.top;
  btnAbortar.Left := btnIniciar.left;

  {Faz com que o Gauge1 seja parente do StatusBar1, assim
  o Gauge1 vai ficar dentro do StatusBar1 fazendo com que o cdigo
  do evento OnDrawPanel do StatusBar1 funcione.}
  Gauge1.Parent := StatusBar1;
end;

procedure TFrmAtualizar.btnAbortarClick(Sender: TObject);
begin
  if Application.MessageBox(PChar(
  'Tem certeza que deseja cancelar o download da atualizao do sistema?'),
  'Confirmao',mb_IconQuestion + mb_YesNo + mb_DefButton2) = mrYes then
  begin
    StatusBar1.SimpleText:= 'Abortando...';
    Abortado:= true;
    IdHTTP1.Disconnect;
  end;
end;

procedure TFrmAtualizar.btnFecharClick(Sender: TObject);
begin
  close;
end;

procedure TFrmAtualizar.btnConfigurarClick(Sender: TObject);
var
   aux: string;
   ini: TIniFile;
begin
   {Cria um objeto da class TIniFile para acessar o arquivo indicado na
   varivel ini_file_name
   Esta varivel recebe um valor no evento OnCreate do Form}
   ini:= TIniFile.Create(ini_file_name);
   try
     {O mtodo ReadString do objeto ini l o valor do identificador
     'URL' da seo 'update' do arquivo ini}
     //A funo Trim remove os espaos em branco do incio e fim de uma string
     URL:= Trim(ini.ReadString('update', 'URL', ''));
     if URL = '' then
        URL:= URLPadrao;
     {Funo que abre uma janela com um edit e um boto de OK e Cancelar.
      retornado o texto que foi digitado no edit.}
     aux:= InputBox('Endereo para Download de Atualizaes',
     'Digite o endereo do site para efetuar o download',URL);

     {Converte para minsculas a URL digitada pelo usurio na janela criada pela funo InputBox.
     Apenas para efeito visual, pois todo endereo de internet  em minsculas.}
     aux:= AnsiLowerCase(trim(aux));
     if aux <> '' then
     begin
       //se nas 7 primeiras posies da URL digitada pelo usurio no possuem o http:// ento coloca-o na string 
       if copy(aux,1,7) <> 'http://' then
          aux:= 'http://' + aux;

       {Como a URL para download das atualizaes  o endereo de um site e no o de um arquivo na web,
       o final do endereo deve ter uma barra pois, a partir desse endereo, ser concatenado
       o nome de um arquivo que ser baixado. Com as 2 linhas abaixo  verificado se existe a
       barra no final da URL digitada pelo usurio, se no existir, coloca-a.}
       if aux[length(aux)] <> '/' then
          aux:= aux + '/';
     end
     else aux:= URLPadrao; {se o usurio no digitou uma URL na janela do InputBox, ento
     deve-se assumir uma URL padro. O valor desta URL padro vem da constante URLPadrao}

     //grava no arquivo .ini a URL armazenada na varivel aux
     ini.WriteString('update', 'URL', aux);
   finally
     ini.free;
   end;
end;

procedure TFrmAtualizar.IdHTTP1WorkBegin(Sender: TObject;
  AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
  //AWorkCountMax indica a quantidade de bytes do arquivo que ser baixado

  {indica que o valor mximo do progresso do gauge
  ser igual ao total de bytes do arquivo}
  Gauge1.MaxValue := AWorkCountMax;
  //posiciona o progresso no gauge em zero
  Gauge1.Progress := 0;

  {se o arquivo tiver menos de 1024 bytes, ser menor que 1 KB,
  ento a unidade ser mostrada em bytes}
  if AWorkCountMax < 1024 then
  begin
    unidade:= 'bytes';
    quant_bytes_divisor:= 1;
  end
  {se o arquivo tiver menos de 1048576 bytes, ser menor que 1 MB,
  ento a unidade ser mostrada em KB}
  else if AWorkCountMax < 1048576 then
  begin
    unidade:= 'KB';
    {valor utilizado para converter de bytes para KB,
    pois 1 KB  igual a 1024 bytes}
    quant_bytes_divisor:= 1024;
  end
  else //seno, mostrar unidade em MB
  begin
    unidade:= 'MB';
    {valor utilizado para converter de bytes para MB,
    pois 1 MB  igual a 1048576 bytes}
    quant_bytes_divisor:= 1048576;
  end;

  {As variveis unidade e quant_bytes_divisor so utilizandas
  no evento OnWork do IdHTTP para mostrar quanto do arquivo j foi
  baixado. }
end;

procedure TFrmAtualizar.IdHTTP1Work(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCount: Integer);
begin
  {Faz com que a aplicao responda aos eventos do sistema como
  cliques de mouse e pressionamento de teclas}
  Application.ProcessMessages;
  {O parmetro AWorkCount indica o total de bytes j baixados do arquivo.
  A instruo abaixo faz com que a barra de progresso do gauge seja incrementado
  pois o valor do parmetro AWorkCount vai aumentando a cada
  vez que este evento  disparado.}
  Gauge1.progress:= AWorkCount;

  {A funo AnsiSameText compara duas string e retorna true
  se as duas forem iguais, s que ela no faz diferena entre
  maiculas e minsculas (case-insensitive). }

  {As intrues abaixo exibem no StatusBar, o tamanho total do
  arquivo (Gauge1.MaxValue) e o quanto j foi baixado (AWorkCount).

  O Gauge1.MaxValue recebeu o total de bytes do arquivo no evento OnWorkBegin

  A varivel quant_bytes_divisor tem o valor necessrio para
  converter de bytes para a unidade especificada na varivel bytes.
  O valor de quant_bytes_divisor foi atribudo no evento OnWorkBegin. }
  if AnsiSameText(unidade,'bytes') then
    StatusBar1.SimpleText:=
      IntToStr(AWorkCount div quant_bytes_divisor) + ' ' + unidade +
      ' de ' + IntToStr(Gauge1.MaxValue div quant_bytes_divisor) + ' ' + unidade
  else
    StatusBar1.SimpleText:=
      FormatFloat('0.00', AWorkCount / quant_bytes_divisor) + ' ' + unidade +
      ' de ' + FormatFloat('0.00', Gauge1.MaxValue / quant_bytes_divisor)
      + ' ' + unidade;
end;

procedure TFrmAtualizar.VerificaVersao(NomeArqVersaoLocal: String);
var
   versao_exe_remoto_str, versao_exe_instalado_str: ShortString;
   i: integer;
   ini: TIniFile;
begin
   {l do arquivo .ini, que foi baixado da internet, o nmero
   da verso do programa que est disponvel para download}
   ini:= TIniFile.Create(NomeArqVersaoLocal);
   try
     versao_exe_remoto_str:= ini.ReadString('update','versao','');
   finally
     ini.free;
   end;

   //extrai o nmero da verso do aplicativo que est rodando
   versao_exe_instalado_str:= FileVersion(Application.ExeName);
   if versao_exe_instalado_str = '' then
      raise exception.create(
      'No foi possvel determinar a verso deste programa. ' +
      #13'A atualizao no pode prosseguir.' +
      #13'Contate o Desenvolvedor do Sistema.');
      
   if versao_exe_remoto_str <> '' then
   begin
     {Se a funo ComparaVersaoArquivo retornar 2,  porque o 2 n de verso
     (o do 2 parmetro, que indica a verso do exe remoto)
      maior que o 1 (passado no 1 parmetro, que
     indica a verso do executvel instalado ), ento
      perguntado ao usurio se ele deseja fazer o download
     da atualizao.}
     if ComparaVersaoArquivo(versao_exe_instalado_str,
     versao_exe_remoto_str) = 2 then
     begin
        if Application.MessageBox(PChar(
          'Existe uma nova verso do sistema no servidor remoto.'#13 +
          'Voc est utilizando a verso ' + versao_exe_instalado_str +
          ' e existe a verso ' + versao_exe_remoto_str +
          ' disponvel para download.'#13#13'Deseja fazer a atualizao agora?'),
          'Confirmao',mb_IconQuestion+mb_YesNo) = mrYes then
        begin
          btnAbortar.Visible := true;
          if GetFile(URL + NomeArqSemExtensao + '.exe',
          TempDir + NomeArqSemExtensao + '.exe') then
             ExecutaUpdate(TempDir + NomeArqSemExtensao + '.exe')
          else DeleteDownload(TempDir + NomeArqSemExtensao + '.exe');
        end;
     end
     else
     begin
       Application.MessageBox(
       PChar('No existe nenhuma nova verso do sistema no servidor remoto.'
       + #13'Voc possui a verso mais atual no momento.'),
       'Informao',mb_IconInformation);
     end;
   end
   else raise exception.create(
     'No foi possvel determinar a verso do programa no servidor remoto.'
     + #13'A atualizao no pode prosseguir.' 
     + #13'Contate o Desenvolvedor do Sistema.');
end;

{Procedimento que executa o programa de atualizao e finaliza
o programa antigo para que o executvel possa ser atualizado.}
procedure TFrmAtualizar.ExecutaUpdate(NomeArqLocal: String);
var exe: TFileName;
begin
  StatusBar1.SimpleText:= 'Download da atualizao concludo';

  Application.MessageBox(pchar('O download da atualizao foi concludo.'#13 +
  'O sistema ser reiniciado agora para executar a atualizao.'),
  'Informao',mb_IconInformation);

  {O download da atualizao  feito na pasta temporria do windows.
  A instruo abaixo pega o caminho completo do programa baixado da internet.}
  exe:= TempDir + ExtractFileName(Application.ExeName);
  if FileExists(exe) then
  begin
    {funo que executa o programa de atualizao passando os
    devidos parmetros para o mesmo}
    if Atualizar(PathUpdateProgram + 'update.exe', exe,
    'Delete_EXE_Origem') then
       Application.Terminate
    else  Application.MessageBox(PChar(
      'No foi possvel executar o programa de atualizao. '#13 +
      'Talves o servidor local (onde o programa de atualizao reside) ' +
      'no esteja acessvel.'),'Erro',mb_IconError)
  end
  else Application.MessageBox(pchar(
    'O arquivo "' + NomeArqLocal + '" no existe.'),'Erro',mb_IconError);
end;

{inicia o processo de download de um arquivo.
A funo s retorna quando o download for concludo ou cancelado}
function TFrmAtualizar.GetFile(RemoteFile, LocalFile: String): Boolean;
var fs: TFileStream;
begin
  result:= false;

  {cria um objeto da classe TFileStream onde o arquivo que ser manipulado
   informado atravs do parmetro LocalFile. O segundo parmetro,
  de valor fmCreate,  utilizado para informar que se o arquivo
  no existir  pra cri-lo, se existir  pra substitu-lo.}
  fs:= TFileStream.Create(LocalFile, fmCreate);
  try
    try
      {o procedimento Get do objeto IdHTTP baixa o arquivo especificado
      no parmetro RemoteFile e vai salvando no disco rgido atravs do
      objeto fs (da classe TFileStream). Enquanto o download no for
      concludo ou abortado, o procedimento no retorna.}
      IdHTTP1.Get(RemoteFile,fs);

      {A varivel Abortado indica se o usurio interrompeu o download.
      Esta funo retorna true caso o usurio no tenha abortado o download.
      Abortado recebe true quando o usurio clica no boto Abortar.}
      result:= not Abortado;
    except
      {Tratamento de erros
       Caso ocorra um erro e na mensagem tiver a expresso not found, ento
       traduz a mensagem para o portugus informando que o arquivo remoto
       no foi encontrado}
      on e: exception do
      begin
        if pos('not found',AnsiLowerCase(e.message)) > 0 then
           e.message:= 'O arquivo "' + RemoteFile +
           '" no foi encontrado no servidor remoto.';
        raise;
      end;
    end;
  finally
    fs.free;
    //fecha a conexo com o servidor de onde foi baixado o arquivo
    IdHTTP1.Disconnect;
  end;
end;

procedure TFrmAtualizar.StatusBar1DrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
var aRect: TRect;
begin
  {Desenha o Gauge1 dentro do Panel de nmero 1
  (segundo Panel) da StatusBar1}
  if Panel.ID = 1 then
  begin
    aRect := Rect;
    InflateRect(aRect, 1, 1);
    Gauge1.BoundsRect := aRect;
  end;
end;

{divide uma string contendo o nmero de verso em quatro partes inteiras}
procedure TFrmAtualizar.DivNumeroVersao(version_str: ShortString;
  var major_version, minor_version, release, build: word);
var p: integer;
begin
  major_version:= 0;
  minor_version:= 0;
  release:= 0;
  build:= 0;
  //retira possveis espaos em branco no incio e final da verso
  version_str:= trim(version_str);

  //procura a posio do ponto dentro da string da verso
  p:= pos('.', version_str);
  //se encontrou um ponto ento
  if p <> 0 then
  begin
     //copia a string da posio 1 at a posio antes do ponto
     major_version:= StrToInt(copy(version_str, 1,p-1));
     //deleta da posio 1 at o ponto dentro da string da verso
     delete(version_str,1,p);
  end;

  p:= pos('.', version_str);
  if p <> 0 then
  begin
     minor_version:= StrToInt(copy(version_str, 1,p-1));
     delete(version_str,1,p);
  end;

  p:= pos('.', version_str);
  if p <> 0 then
  begin
     release:= StrToInt(copy(version_str, 1,p-1));
     delete(version_str,1,p);
  end;

  if version_str <> '' then
     build:= StrToInt(version_str);
end;

{Compara 2 nmeros de verso passados como parmetro e
 verifica qual nmero  maior ou se os nmeros so iguais

 retorno da funo:
   0 - as verses so iguais;
   1 - a verso 1  maior verso que a 2,
   2 - a verso 2  maior verso que a 1 }
function TFrmAtualizar.ComparaVersaoArquivo(VersaoArquivo1,
  VersaoArquivo2: ShortString): Byte;
var
  major_version1, minor_version1, release1, build1,
  major_version2, minor_version2, release2, build2: word;
begin
    {pega o n de verso do parmetro VersaoArquivo1 e divide suas partes
    nas variveis major_version1, minor_version1, release1, build1}
    DivNumeroVersao(VersaoArquivo1, major_version1,
      minor_version1, release1, build1);

    {pega o n de verso do parmetro VersaoArquivo2 e divide suas partes
    nas variveis major_version2, minor_version2, release2, build2}
    DivNumeroVersao(VersaoArquivo2, major_version2,
      minor_version2, release2, build2);
      
    if major_version1 > major_version2 then
       result:= 1
    else if major_version1 < major_version2 then
       result:= 2
    else
    begin
       if minor_version1 > minor_version2 then
          result:= 1
       else if minor_version1 < minor_version2 then
          result:= 2
       else
       begin
          if release1 > release2 then
             result:= 1
          else if release1 < release2 then
             result:= 2
          else
          begin
             if build1 > build2 then
                result:= 1
             else if build1 < build2 then
                result:= 2
             {se chegar at esse else,  porque as duas verses so iguais
             e a funo retornar zero}
             else result:= 0;
          end;
       end;
    end;
end;

end.
